/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyInterface;

@Entity
public class Taxon
implements Serializable,
FetchingElement,
TaxonomyInterface,
Comparable<Taxon> {
    private static final long serialVersionUID = -3579358036639552802L;
    public static final String ID_FIELD = "id";
    public static final String PARENTFOREIGN_KEY_TAXON = "parent";
    public static final String RANK = "rank";
    public static final String NAME = "name";
    public static final String ACCORDING_TO = "accordingTo";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected int internalId;
    protected int id;
    protected String name;
    protected String accordingTo;
    protected String rank;

    public Taxon() {
    }

    public Taxon(int id) {
        this.id = id;
    }

    public Taxon(int id, String name, String accordingTo, String rank) {
        this.id = id;
        this.name = name;
        this.accordingTo = accordingTo;
        this.rank = rank;
    }

    public String getTaxonId() {
        return this.id + "";
    }

    public String getName() {
        return this.name;
    }

    public String getAccordingTo() {
        return this.accordingTo;
    }

    public String getRank() {
        return this.rank;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(Taxon o) {
        return this.id - o.getId();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Taxon [internalId=");
        builder.append(this.internalId);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", accordingTo=");
        builder.append(this.accordingTo);
        builder.append(", rank=");
        builder.append(this.rank);
        builder.append("]");
        return builder.toString();
    }
}

