/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyJob;

public class TaxonomyJobPersistence
extends AbstractPersistence<TaxonomyJob> {
    public TaxonomyJobPersistence(EntityManagerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAll() throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM TaxonomyJob").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("DELETE FROM TaxonomyJob " + removed + " items"));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM TaxonomyJob t WHERE t.jobId='" + idField + "'").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("Item " + idField + " was deleted from TaxonomyJob. removed " + removed + " item"));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyJob> getList() throws DatabaseServiceException {
        ArrayList<TaxonomyJob> listTaxJob = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from TaxonomyJob t");
            listTaxJob = query.getResultList();
        }
        return listTaxJob;
    }

    public int countItems() throws DatabaseServiceException {
        return this.getList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyJob getItemByKey(Integer id) throws DatabaseServiceException {
        this.logger.trace((Object)("getItemByKey id:  " + id));
        TaxonomyJob taxJob = null;
        try (EntityManager em = super.createNewManager();){
            taxJob = (TaxonomyJob)em.getReference(TaxonomyJob.class, (Object)id);
        }
        if (taxJob != null) {
            this.logger.trace((Object)("getItemByKey return row:  " + taxJob.getId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return taxJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyJob> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        ArrayList<TaxonomyJob> listTaxJob = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery query = em.createQuery(criteriaQuery);
            listTaxJob = query.getResultList();
        }
        return listTaxJob;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    public Root<TaxonomyJob> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(TaxonomyJob.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyJob> getList(int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<TaxonomyJob> listTaxJob = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from TaxonomyJob t");
            query.setFirstResult(startIndex);
            query.setMaxResults(offset);
            listTaxJob = query.getResultList();
        }
        return listTaxJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyJob> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<TaxonomyJob> listTaxJob = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            String queryString = "select t from TaxonomyJob t";
            if (filterMap != null && filterMap.size() > 0) {
                queryString = queryString + " where ";
                for (String param : filterMap.keySet()) {
                    String value = filterMap.get(param);
                    queryString = queryString + " t." + param + "=" + value;
                    queryString = queryString + "AND";
                }
                queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
            }
            Query query = em.createQuery(queryString);
            if (startIndex > -1) {
                query.setFirstResult(startIndex);
            }
            if (offset > -1) {
                query.setMaxResults(offset);
            }
            listTaxJob = query.getResultList();
        }
        return listTaxJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyJob> executeTypedQuery(CriteriaQuery<Object> cq, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<TaxonomyJob> listOJ = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery typedQuery = em.createQuery(cq);
            if (startIndex > -1) {
                typedQuery.setFirstResult(startIndex);
            }
            if (offset > -1) {
                typedQuery.setMaxResults(offset);
            }
            listOJ = typedQuery.getResultList();
        }
        return listOJ;
    }
}

