/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;

public class ResultRowPersistence
extends AbstractPersistence<ResultRow> {
    protected CriteriaBuilder criteriaBuilder;
    protected CriteriaQuery<Object> criteriaQuery;
    protected Root<ResultRow> rootFrom;
    protected Logger logger = Logger.getLogger(ResultRowPersistence.class);

    public ResultRowPersistence(EntityManagerFactory factory) throws DatabaseServiceException {
        super(factory);
        this.criteriaBuilder = super.createNewManager().getCriteriaBuilder();
    }

    public Root<ResultRow> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(ResultRow.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> getList() throws DatabaseServiceException {
        ArrayList<ResultRow> listResultRow = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from ResultRow t");
            listResultRow = query.getResultList();
        }
        return listResultRow;
    }

    public int countItems() throws DatabaseServiceException {
        return this.getList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        ArrayList<ResultRow> listResultRow = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery query = em.createQuery(criteriaQuery);
            listResultRow = query.getResultList();
        }
        return listResultRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultRow getItemByKey(Integer id) throws DatabaseServiceException {
        this.logger.trace((Object)("getItemByKey id:  " + id));
        ResultRow row = null;
        try (EntityManager em = super.createNewManager();){
            row = (ResultRow)em.getReference(ResultRow.class, (Object)id);
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row:  " + row.getId() + ", service id: " + row.getServiceId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAll() throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM ResultRow").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("DELETE FROM ResultRow " + removed + " items"));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> getList(int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<ResultRow> listResultRow = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from ResultRow t");
            query.setFirstResult(startIndex);
            query.setMaxResults(offset);
            listResultRow = query.getResultList();
        }
        return listResultRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<ResultRow> listResultRow = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            String queryString = "select t from ResultRow t";
            if (filterMap != null && filterMap.size() > 0) {
                queryString = queryString + " where ";
                for (String param : filterMap.keySet()) {
                    String value = filterMap.get(param);
                    queryString = queryString + " t." + param + "=" + value;
                    queryString = queryString + "AND";
                }
                queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
            }
            Query query = em.createQuery(queryString);
            listResultRow = query.getResultList();
        }
        return listResultRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> executeTypedQuery(CriteriaQuery<Object> cq, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<ResultRow> listOJ = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery typedQuery = em.createQuery(cq);
            if (startIndex > -1) {
                typedQuery.setFirstResult(startIndex);
            }
            if (offset > -1) {
                typedQuery.setMaxResults(offset);
            }
            listOJ = typedQuery.getResultList();
        }
        return listOJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM ResultRow t WHERE t.id='" + idField + "'").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("Item " + idField + " was deleted from ResultRow"));
        }
        return removed;
    }
}

