/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.cluster;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TabItemForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.TaxonomyGridField;
import org.gcube.portlets.user.speciesdiscovery.shared.LightTaxonomyRow;

public class TablesForTaxonomyRow {
    private TabPanel tabPanel;
    private EventBus eventBus;
    private List<LightTaxonomyRow> parents = null;
    private TabItemForTaxonomyRow tabTR;
    private AbstractImagePrototype imageLoading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls());

    public List<LightTaxonomyRow> getParents() {
        return this.parents;
    }

    public void setParents(List<LightTaxonomyRow> parents) {
        this.parents = parents;
    }

    public TablesForTaxonomyRow(TabPanel tabPanel2, EventBus eventBus2) {
        this.tabPanel = tabPanel2;
        this.eventBus = eventBus2;
        this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);
    }

    public VerticalPanel getPanelClassificationForTaxonomy(LightTaxonomyRow taxonomy, String dataSource, boolean isNewTab) {
        this.tabTR.setCurrentTaxonomy(taxonomy);
        return this.tabTR.getPanelClassificationForTaxonomy(taxonomy, dataSource, isNewTab);
    }

    protected ContentPanel getPanelForTaxonomy(LightTaxonomyRow taxon, String dataSource, boolean isNewTab) {
        ContentPanel contentPanel = new ContentPanel();
        contentPanel.setHeaderVisible(false);
        contentPanel.setBodyBorder(false);
        contentPanel.setStyleAttribute("padding", "5px");
        contentPanel.setStyleAttribute("margin", "5px");
        VerticalPanel verticaPanel = new VerticalPanel();
        verticaPanel.setSize("100%", "100%");
        contentPanel.add((Widget)new Html("<br/><br/><p style=\"font-size:18px;\"><b>" + taxon.getName() + "</b></p><hr>"));
        contentPanel.add((Widget)new Html("<br/><br/><p style=\"font-size:12px;\"><b>Scientific Classification</b></p><br/>"));
        contentPanel.add((Widget)this.getPanelClassificationForTaxonomy(taxon, dataSource, isNewTab));
        contentPanel.add((Widget)new Html("<p style=\"font-size:11px; margin-top:10px;\"><b>Status and Synonyms</b></p>"));
        contentPanel.add((Widget)this.getStatusAndSynonyms(taxon, dataSource));
        contentPanel.add((Widget)new Html("<p style=\"font-size:11px; margin-top:10px;\"><b>Metadata</b></p"));
        LayoutContainer lcRRTables = new LayoutContainer();
        lcRRTables.setStyleAttribute("width", "99%");
        lcRRTables.setStyleAttribute("margin", "5px");
        lcRRTables.setStyleAttribute("padding", "5px");
        lcRRTables.setStyleAttribute("font-size", "12px");
        contentPanel.add((Widget)lcRRTables);
        Image loading = this.imageLoading.createImage();
        lcRRTables.add((Widget)loading);
        String urlRequest = GWT.getModuleBaseURL() + "TaxonomyRowTable" + "?" + "oid=" + taxon.getServiceId();
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, urlRequest);
        requestBuilder.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            requestBuilder.sendRequest("", (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            lcRRTables.remove((Widget)loading);
            lcRRTables.add((Widget)new Html("Sorry, an error occurred while contacting server, try again"));
        }
        return contentPanel;
    }

    protected void addTabItem(LightTaxonomyRow taxon, String dataSource) {
        this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);
        TabItem tabItem = new TabItem();
        tabItem.setScrollMode(Style.Scroll.AUTO);
        tabItem.setClosable(true);
        ContentPanel cp = new ContentPanel();
        cp.setHeaderVisible(false);
        ToolBar toolbar = new ToolBar();
        Button btnSaveTaxonomyChildren = new Button("Save Taxonomy Children");
        Menu formatSubMenu = new Menu();
        btnSaveTaxonomyChildren.setMenu(formatSubMenu);
        btnSaveTaxonomyChildren.setScale(Style.ButtonScale.SMALL);
        btnSaveTaxonomyChildren.setIconAlign(Style.IconAlign.TOP);
        btnSaveTaxonomyChildren.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        btnSaveTaxonomyChildren.setToolTip(new ToolTipConfig("Save Taxonomy Children", "Saves taxonomy children from result."));
        MenuItem darwinCoreArchiveItem = new MenuItem("Darwin Core Archive");
        darwinCoreArchiveItem.setToolTip(new ToolTipConfig("Saves in Darwin Core Archive format"));
        darwinCoreArchiveItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        formatSubMenu.add((Component)darwinCoreArchiveItem);
        toolbar.add((Component)btnSaveTaxonomyChildren);
        cp.setTopComponent((Component)toolbar);
        cp.setBodyBorder(false);
        String tabName = taxon.getName() + " (" + dataSource + ")";
        tabItem.setText(tabName);
        cp.add((Widget)this.getPanelForTaxonomy(taxon, dataSource, true));
        tabItem.add((Widget)cp);
        this.tabPanel.add(tabItem);
    }

    public FlexTable getStatusAndSynonyms(LightTaxonomyRow taxon, String dataSource) {
        String refId = null;
        String statusRemark = "";
        String statusName = "";
        if (taxon.getStatusRefId() != null && !taxon.getStatusRefId().isEmpty()) {
            refId = taxon.getStatusRefId();
        }
        if (taxon.getStatusRemarks() != null) {
            statusRemark = taxon.getStatusRemarks();
        }
        if (taxon.getStatusName() != null) {
            statusName = taxon.getStatusName();
        }
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName("imagetable-status");
        flexTable.setWidget(0, 0, (Widget)new Label(TaxonomyGridField.STATUSREFNAME.getName()));
        flexTable.setWidget(0, 1, (Widget)new Label(statusName));
        if (refId != null) {
            String status = !statusRemark.isEmpty() ? statusRemark : statusName;
            String referenceId = refId;
            flexTable.setWidget(1, 0, (Widget)new Label(TaxonomyGridField.STATUS_REMARKS.getName()));
            AbstractImagePrototype synonyms = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSearch());
            Image imageStatusRemark = synonyms.createImage();
            imageStatusRemark.setStyleName("image-load-synonyms");
            imageStatusRemark.setAltText("show accepted name");
            imageStatusRemark.setTitle("show accepted name");
            LayoutContainer layoutContainer = new LayoutContainer();
            Label labelStatusRemark = new Label(statusRemark);
            labelStatusRemark.addStyleName("status-of");
            layoutContainer.add((Widget)labelStatusRemark);
            imageStatusRemark.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            layoutContainer.add((Widget)labelStatusRemark);
            layoutContainer.add((Widget)imageStatusRemark);
            flexTable.setWidget(1, 1, (Widget)layoutContainer);
        } else {
            flexTable.setWidget(1, 0, (Widget)new Label(TaxonomyGridField.STATUS_REMARKS.getName()));
            flexTable.setWidget(1, 1, (Widget)new Label(statusRemark));
        }
        flexTable.setWidget(2, 0, (Widget)new Label(TaxonomyGridField.SYNONYMS.getName()));
        AbstractImagePrototype synonyms = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSearch());
        Image imageSynonyms = synonyms.createImage();
        imageSynonyms.setStyleName("image-load-synonyms");
        imageSynonyms.setAltText("show synonyms");
        imageSynonyms.setTitle("show synonyms");
        imageSynonyms.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(2, 1, (Widget)imageSynonyms);
        return flexTable;
    }

    static /* synthetic */ EventBus access$000(TablesForTaxonomyRow x0) {
        return x0.eventBus;
    }

    static /* synthetic */ TabItemForTaxonomyRow access$100(TablesForTaxonomyRow x0) {
        return x0.tabTR;
    }
}

