/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.cluster;

import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TablesForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.LightTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class TabItemForTaxonomyRow {
    private TabPanel tabPanel;
    private AbstractImagePrototype imageLoading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls());
    private EventBus eventBus;
    private TablesForTaxonomyRow tablesForTaxonomyRow;
    private LightTaxonomyRow currentTaxonomy;

    public void setCurrentTaxonomy(LightTaxonomyRow taxonomy) {
        this.currentTaxonomy = taxonomy;
    }

    public TabItemForTaxonomyRow(TablesForTaxonomyRow tablesForTaxonomyRow, TabPanel tabPanel2, EventBus eventBus2) {
        this.tablesForTaxonomyRow = tablesForTaxonomyRow;
        this.tabPanel = tabPanel2;
        this.eventBus = eventBus2;
    }

    public VerticalPanel getPanelClassificationForTaxonomy(LightTaxonomyRow taxonomy, String dataSource, boolean isNewTab) {
        VerticalPanel vpClassification = new VerticalPanel();
        vpClassification.setSpacing(5);
        if (taxonomy != null) {
            int parentsSize = taxonomy.getParents().size();
            for (int i = parentsSize - 1; i >= 0; --i) {
                this.createPanelForParentTaxonomy((LightTaxonomyRow)taxonomy.getParents().get(i), vpClassification, taxonomy.getServiceId(), isNewTab, dataSource, i + 1);
            }
            this.createPanelForParentTaxonomy(taxonomy, vpClassification, taxonomy.getServiceId(), isNewTab, dataSource, 0);
        }
        return vpClassification;
    }

    public void createPanelForParentTaxonomy(LightTaxonomyRow taxon, VerticalPanel vpClassification, String taxonomyServiceId, boolean isNewTab, String dataSource, int parentIndex) {
        if (taxon == null) {
            return;
        }
        HorizontalPanel hp = new HorizontalPanel();
        Text labelRank = !NormalizeString.isUndefined((String)taxon.getRank()) ? new Text(taxon.getRank() + ":") : new Text("Rank not found:");
        hp.add((Widget)labelRank);
        hp.setCellWidth((Widget)labelRank, "120px");
        Anchor anchor = this.getAnchorByTaxonomy(taxon, dataSource, parentIndex);
        hp.add((Widget)anchor);
        hp.setCellHorizontalAlignment((Widget)anchor, HorizontalPanel.ALIGN_LEFT);
        vpClassification.add((Widget)hp);
        if (taxon.getServiceId().compareTo(taxonomyServiceId) == 0 && isNewTab) {
            this.loadChildrenListOfItem(vpClassification, taxon, dataSource, taxon.getName(), -1);
        }
    }

    private void loadChildrenListOfItem(VerticalPanel vpClassification, LightTaxonomyRow taxonomyItem, String dataSource, String parentName, int parentIndex) {
        ContentPanel cp = new ContentPanel();
        cp.setId("cp" + taxonomyItem.getId());
        cp.setHeaderVisible(false);
        cp.setBodyBorder(false);
        cp.add((Widget)this.imageLoading.createImage());
        vpClassification.add((Widget)cp);
        SpeciesDiscovery.taxonomySearchService.loadListChildrenByParentId(taxonomyItem.getServiceId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        vpClassification.layout();
    }

    private boolean replaceLabelRank(HorizontalPanel hp, Text oldLabelRank, String rank) {
        if (!NormalizeString.isUndefined((String)rank)) {
            hp.remove((Widget)oldLabelRank);
            Text setlabelRank = new Text(rank + ":");
            hp.add((Widget)setlabelRank);
            hp.setCellWidth((Widget)setlabelRank, "120px");
            return true;
        }
        return false;
    }

    private Anchor getAnchorByTaxonomy(LightTaxonomyRow taxon, String dataSource, int parentIndex) {
        Anchor anchor = null;
        if (taxon != null) {
            anchor = new Anchor("<nobr>" + taxon.getName() + "</nobr>", true);
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return anchor;
    }

    void printParents(LightTaxonomyRow taxon) {
        System.out.println("principal " + taxon.getName());
        int i = 0;
        for (LightTaxonomyRow tax : taxon.getParents()) {
            System.out.println(++i + " parent name " + tax.getName());
        }
    }

    private Text getLabelByTaxonomy(TaxonomyRow taxon) {
        Text label = null;
        if (taxon != null) {
            label = !NormalizeString.isUndefined((String)taxon.getName()) ? new Text(taxon.getName()) : new Text("Name not found");
        }
        return label;
    }

    public void getSynonymsByReferenceId(FlexTable flexTable, int row, int col, String refId, String dataSource, List<LightTaxonomyRow> parents) {
        LayoutContainer layoutContainer = new LayoutContainer();
        Image loading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls()).createImage();
        layoutContainer.add((Widget)loading);
        flexTable.setWidget(row, col, (Widget)layoutContainer);
        SpeciesDiscovery.taxonomySearchService.retrieveSynonymsByRefId(refId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getTaxonomyByReferenceId(FlexTable flexTable, int row, int col, String statusRemark, String refId, String dataSource, List<LightTaxonomyRow> parents) {
        LayoutContainer layoutContainer = new LayoutContainer();
        Label status = new Label(statusRemark);
        layoutContainer.add((Widget)status);
        Image loading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls()).createImage();
        layoutContainer.add((Widget)loading);
        flexTable.setWidget(row, col, (Widget)layoutContainer);
        ArrayList<String> listId = new ArrayList<String>();
        listId.add(refId);
        SpeciesDiscovery.taxonomySearchService.retrieveTaxonomyByIds(listId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ boolean access$000(TabItemForTaxonomyRow x0, HorizontalPanel x1, Text x2, String x3) {
        return x0.replaceLabelRank(x1, x2, x3);
    }

    static /* synthetic */ Anchor access$100(TabItemForTaxonomyRow x0, LightTaxonomyRow x1, String x2, int x3) {
        return x0.getAnchorByTaxonomy(x1, x2, x3);
    }

    static /* synthetic */ LightTaxonomyRow access$200(TabItemForTaxonomyRow x0) {
        return x0.currentTaxonomy;
    }

    static /* synthetic */ TablesForTaxonomyRow access$300(TabItemForTaxonomyRow x0) {
        return x0.tablesForTaxonomyRow;
    }
}

