/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream;

import java.util.HashMap;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Aggregator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.KeyProvider;

public abstract class CounterAggregator<T>
implements Aggregator<T, HashMap<String, Integer>> {
    protected String name;
    protected HashMap<String, Integer> aggregation;
    protected KeyProvider<T> keyProvider;

    public CounterAggregator(String name, KeyProvider<T> keyProvider) {
        this.name = name;
        this.aggregation = new HashMap();
        this.keyProvider = keyProvider;
    }

    public String getName() {
        return this.name;
    }

    public void aggregate(T input) {
        String key = this.keyProvider.getKey(input);
        Integer counter = (Integer)this.aggregation.get(key);
        if (counter == null) {
            counter = 0;
        }
        this.aggregation.put(key, counter + 1);
    }

    public HashMap<String, Integer> getAggregation() {
        return this.aggregation;
    }
}

