package org.gcube.portlets.user.td.columnwidget.client.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.util.OrderInfo;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.SortDir;
import com.sencha.gxt.data.shared.SortInfo;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.data.shared.loader.PagingLoadConfig;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoadResultBean;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.LiveGridView;
import com.sencha.gxt.widget.core.client.grid.LiveToolItem;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

public class DialogCodelistSelection extends Window {
	protected static final int WIDTH = 550;
	protected static final int HEIGHT = 520;
	protected static final int CACHE_SIZE = 200;

	private static final TabResourcesProperties properties = GWT
			.create(TabResourcesProperties.class);

	protected static final ColumnConfig<TabResource, String> nameColumn = new ColumnConfig<TabResource, String>(
			properties.name(), 50, "Name");
	protected static final ColumnConfig<TabResource, String> agencyColumn = new ColumnConfig<TabResource, String>(
			properties.agency(), 50, "Agency");
	protected static final ColumnConfig<TabResource, String> dateColumn = new ColumnConfig<TabResource, String>(
			properties.date(), 50, "Date");

	protected Grid<TabResource> grid;
	protected ExtendedLiveGridView liveGridView;
	protected PagingLoader<PagingLoadConfig, PagingLoadResult<TabResource>> loader;
	
	protected ResourceBundle res;

	public DialogCodelistSelection() {
		Log.info("Dialog CodelistSelection");
		setWidth(WIDTH);
		setHeight(HEIGHT);
		res = ResourceBundle.INSTANCE;
		setBodyBorder(false);
		setResizable(true);
		setHeadingText("Select Codelist");

		FramedPanel panel = new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);

		VerticalLayoutContainer v = new VerticalLayoutContainer();

		// Search
		ToolBar toolBar = new ToolBar();
		toolBar.add(new LabelToolItem("Search: "));
		final TextField searchField = new TextField();
		toolBar.add(searchField);

		TextButton btnReload = new TextButton();
		btnReload.setText("Reload");
		btnReload.setIcon(res.refresh());
		btnReload.setToolTip("Reload");
		toolBar.add(btnReload);

		IdentityValueProvider<TabResource> identity = new IdentityValueProvider<TabResource>();
		final CheckBoxSelectionModel<TabResource> sm = new CheckBoxSelectionModel<TabResource>(
				identity);

		List<ColumnConfig<TabResource, ?>> columns = Arrays
				.<ColumnConfig<TabResource, ?>> asList(nameColumn,
						agencyColumn, dateColumn);

		ColumnModel<TabResource> cm = new ColumnModel<TabResource>(columns);

		final ListStore<TabResource> store = new ListStore<TabResource>(
				properties.id());

		searchField.addKeyUpHandler(new KeyUpHandler() {

			public void onKeyUp(KeyUpEvent event) {
				Log.trace("searchTerm: " + searchField.getCurrentValue());
				// store.applyFilters();
			}
		});

		RpcProxy<PagingLoadConfig, PagingLoadResult<TabResource>> proxy = new RpcProxy<PagingLoadConfig, PagingLoadResult<TabResource>>() {

			public void load(PagingLoadConfig loadConfig,
					final AsyncCallback<PagingLoadResult<TabResource>> callback) {
				loadData(loadConfig, callback);

			}
		};
	    loader = new PagingLoader<PagingLoadConfig, PagingLoadResult<TabResource>>(
				proxy);

		loader.setRemoteSort(true);

		loader.addLoadHandler(new LoadResultListStoreBinding<PagingLoadConfig, TabResource, PagingLoadResult<TabResource>>(
				store));

		liveGridView = new ExtendedLiveGridView();
		liveGridView.setForceFit(true);
		liveGridView.setEmptyText("No Matching Results.");
		liveGridView.setCacheSize(CACHE_SIZE);

		grid = new Grid<TabResource>(store, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load(0, liveGridView.getCacheSize());
					}
				});
			}
		};

		sm.setSelectionMode(SelectionMode.SINGLE);
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		grid.setView(liveGridView);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);

		
		SelectHandler sh = new SelectHandler() {
			public void onSelect(SelectEvent event) {
				loader.load();
			}
		};

		btnReload.addSelectHandler(sh);

		ToolBar baseToolBar = new ToolBar();
		baseToolBar.add(new LiveToolItem(grid));
		baseToolBar.addStyleName(ThemeStyles.getStyle().borderTop());
		baseToolBar.getElement().getStyle().setProperty("borderBottom", "none");

		v.add(toolBar, new VerticalLayoutData(-1, -1));
		v.add(grid, new VerticalLayoutData(1, 1));
		v.add(baseToolBar, new VerticalLayoutData(1, 25));

		panel.add(v);
		panel.addButton(new TextButton("Select"));

		add(panel);

	}

	protected void loadData(PagingLoadConfig loadConfig,
			final AsyncCallback<PagingLoadResult<TabResource>> callback) {
		/*
		 * TDGWTServiceAsync.INSTANCE.getTabularResources(new
		 * AsyncCallback<ArrayList<TabResource>>() {
		 * 
		 * public void onFailure(Throwable caught) {
		 * Log.error("load combo failure:" + caught.getLocalizedMessage());
		 * callback.onFailure(caught); }
		 * 
		 * public void onSuccess(ArrayList<TabResource> result) {
		 * Log.trace("loaded " + result.size() + " ColumnData"); /*if
		 * (columnName != null) { for (ColumnData cd : result) { if
		 * (cd.getName().compareTo(columnName) == 0) { comboColumn.setValue(cd);
		 * labelColumn.setValue(cd.getLabel());
		 * comboColumnTypeCode.select(ColumnTypeCodeStore
		 * .selected(cd.getTypeCode())); } } } callback.onSuccess(new
		 * ListLoadResultBean<TabResource>( result));
		 * 
		 * }
		 * 
		 * 
		 * });
		 */
		
		
		ArrayList<TabResource> trs = new ArrayList<TabResource>(1000);
		List<? extends SortInfo> sortInfo=loadConfig.getSortInfo();
		Iterator<? extends SortInfo> iterator=sortInfo.iterator();
		ArrayList<OrderInfo> listOrderInfo=new ArrayList<OrderInfo>();
		
		
		while(iterator.hasNext()){
			SortInfo info=iterator.next();
			OrderInfo ord=new OrderInfo();
			SortDir sd=info.getSortDir();
			if(sd.compareTo(SortDir.ASC)==0){
				ord.setDirection("ASC");
			} else {
				ord.setDirection("DESC");
			}
			ord.setField(info.getSortField());
			listOrderInfo.add(ord);
		}
		
		int totalLength = loadConfig.getOffset() + loadConfig.getLimit();
		int offset = loadConfig.getOffset();
		Log.debug("Offset: " + offset);
		Log.debug("Limit:" + loadConfig.getLimit());
		Log.debug("TotalLength:" + totalLength);
		int cur = 0;
		for (int i = offset; i < totalLength; i++) {
			try {
				cur = i + 1;
				TabResource tr = new TabResource();
				tr.setId(String.valueOf(i));
				tr.setName("Number" + cur);
				tr.setAgency("Agency" + cur);
				tr.setDate("2013/11/01");

				trs.add(tr);

			} catch (IndexOutOfBoundsException e) {
				Log.debug("OutOfBounds size:" + trs.size() + " index: " + i
						+ " Error:" + e.getMessage() + "\n");
			}
		}

		callback.onSuccess(new PagingLoadResultBean<TabResource>(trs, 1000,
				offset));
	}

	protected HandlerRegistration addSelectionHandler(
			SelectionHandler<TabResource> handler) {
		SelectionHandler<TabResource> hand = new SelectionHandler<TabResource>() {

			public void onSelection(SelectionEvent<TabResource> event) {
				// tabResourcesSelectionPanel.getSelectedItem();
				// getWizardWindow().setEnableNextButton(true);
			}

		};

		return grid.getSelectionModel().addSelectionHandler(hand);
	}

	public TabResource getSelectedItem() {
		return grid.getSelectionModel().getSelectedItem();
	}

	protected class ExtendedLiveGridView extends LiveGridView<TabResource> {

		@Override
		public void refresh(boolean headerToo) {
			preventScrollToTopOnRefresh = true;
			super.refresh(headerToo);
		}
	};

}
