package org.gcube.portlets.user.td.columnwidget.client;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.form.ComboBox;

/**
 * Dialog for Change Column Type 
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ChangeColumnTypeDialog extends Window {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";
	protected TRId trId;
	
	protected String columnName=null;
	protected ColumnData column=null;
	protected ComboBox<ColumnData> combo=null;
	
	public ChangeColumnTypeDialog(TRId trId, EventBus eventBus) {
		create(trId, null, eventBus);
	}

	public ChangeColumnTypeDialog(TRId trId, String columnName, EventBus eventBus) {
		create(trId, columnName, eventBus);
	}

	protected void create(TRId trId, String columnName, EventBus eventBus) {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Change Column Type");
		//getHeader().setIcon(Resources.IMAGES.side_list());
		this.trId=trId;
		this.columnName=columnName;
		
		ChangeColumnTypePanel changeColumnTypePanel= new ChangeColumnTypePanel(trId, columnName, eventBus);
		add(changeColumnTypePanel);
		
		
	}
}
