package org.gcube.portlets.user.td.columnwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.dimension.DialogCodelistSelection;
import org.gcube.portlets.user.td.columnwidget.client.progress.ChangeColumnTypeProgressDialog;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnTypeCodeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.TabResourceProperties;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeStore;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadConfigBean;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.BeforeShowContextMenuEvent;
import com.sencha.gxt.widget.core.client.event.BeforeShowContextMenuEvent.BeforeShowContextMenuHandler;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * ChangeColumnTypePanel is the panel for change column type
 * 
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ChangeColumnTypePanel extends FramedPanel {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected ChangeColumnTypeDialog parent;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;
	protected ColumnData column;
	protected ComboBox<ColumnData> comboColumn = null;
	protected ComboBox<ColumnTypeCodeElement> comboColumnTypeCode = null;
	protected ComboBox<ColumnDataTypeElement> comboMeasureType = null;
	protected FieldLabel comboMeasureTypeLabel;
	protected ComboBox<ColumnDataTypeElement> comboAttributeType = null;
	protected FieldLabel comboAttributeTypeLabel;
	protected ComboBox<TabResource> comboDimensionType = null;
	protected FieldLabel comboDimensionTypeLabel;

	protected ListLoader<ListLoadConfig, ListLoadResult<ColumnData>> loader;

	protected TextButton change;

	protected ChangeColumnTypeSession changeColumnTypeSession;
	protected ChangeColumnTypeProgressDialog changeColumnTypeProgressDialog;

	public ChangeColumnTypePanel(TRId trId, String columnName, EventBus eventBus) {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		Log.debug("Create ChangeColumnTypePanel(): [" + trId.toString()
				+ " columnName: " + columnName + "]");

		// Column Data
		ColumnDataProperties propsColumnData = GWT
				.create(ColumnDataProperties.class);
		ListStore<ColumnData> storeCombo = new ListStore<ColumnData>(
				propsColumnData.id());

		Log.trace("StoreCombo created");

		RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<ColumnData>> callback) {
				loadData(loadConfig, callback);
			}
		};

		loader = new ListLoader<ListLoadConfig, ListLoadResult<ColumnData>>(
				proxy) {
			@Override
			protected ListLoadConfig newLoadConfig() {
				return (ListLoadConfig) new ListLoadConfigBean();
			}

		};

		// loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ColumnData, ListLoadResult<ColumnData>>(
				storeCombo));
		Log.trace("LoaderCombo created");

		comboColumn = new ComboBox<ColumnData>(storeCombo,
				propsColumnData.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load();
					}
				});
			}
		};
		Log.trace("Combo ColumnData created");

		// addHandlersForEventObservation(comboColumn, propsColumnData.label());
		addHandlersForComboColumn(propsColumnData.label());

		comboColumn.setLoader(loader);
		comboColumn.setEmptyText("Select a column...");
		comboColumn.setWidth(150);
		comboColumn.setTypeAhead(false);
		comboColumn.setEditable(false);
		comboColumn.setTriggerAction(TriggerAction.ALL);

		// comboColumnTypeCode
		ColumnTypeCodeProperties propsColumnTypeCode = GWT
				.create(ColumnTypeCodeProperties.class);
		ListStore<ColumnTypeCodeElement> storeComboTypeCode = new ListStore<ColumnTypeCodeElement>(
				propsColumnTypeCode.id());
		storeComboTypeCode.addAll(ColumnTypeCodeStore.getColumnTypeCodes());

		comboColumnTypeCode = new ComboBox<ColumnTypeCodeElement>(
				storeComboTypeCode, propsColumnTypeCode.label());
		Log.trace("ComboColumnTypeCode created");

		addHandlersForComboColumnTypeCode(propsColumnTypeCode.label());

		comboColumnTypeCode.setEmptyText("Select a column type...");
		comboColumnTypeCode.setWidth(150);
		comboColumnTypeCode.setTypeAhead(true);
		comboColumnTypeCode.setTriggerAction(TriggerAction.ALL);

		// comboMeasureType
		ColumnDataTypeProperties propsMeasureType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboMeasureType = new ListStore<ColumnDataTypeElement>(
				propsMeasureType.id());
		storeComboMeasureType.addAll(ColumnDataTypeStore.getMeasureType());

		comboMeasureType = new ComboBox<ColumnDataTypeElement>(
				storeComboMeasureType, propsMeasureType.label());
		Log.trace("ComboMeasureType created");

		addHandlersForComboMeasureType(propsMeasureType.label());

		comboMeasureType.setEmptyText("Select a column type...");
		comboMeasureType.setWidth(150);
		comboMeasureType.setTypeAhead(true);
		comboMeasureType.setTriggerAction(TriggerAction.ALL);

		comboMeasureTypeLabel = new FieldLabel(comboMeasureType, "Measure Type");
		comboMeasureTypeLabel.setVisible(false);

		// comboAttributeType
		ColumnDataTypeProperties propsAttributeType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboAttributeType = new ListStore<ColumnDataTypeElement>(
				propsAttributeType.id());
		storeComboAttributeType.addAll(ColumnDataTypeStore.getAttributeType());

		comboAttributeType = new ComboBox<ColumnDataTypeElement>(
				storeComboAttributeType, propsAttributeType.label());
		Log.trace("ComboAttributeType created");

		addHandlersForComboAttributeType(propsAttributeType.label());

		comboAttributeType.setEmptyText("Select a column type...");
		comboAttributeType.setWidth(150);
		comboAttributeType.setTypeAhead(true);
		comboAttributeType.setTriggerAction(TriggerAction.ALL);

		comboAttributeTypeLabel = new FieldLabel(comboAttributeType,
				"Attribute Type");
		comboAttributeTypeLabel.setVisible(false);

		// comboMeasureType
		TabResourceProperties propsDimensionType = GWT
				.create(TabResourceProperties.class);
		ListStore<TabResource> storeComboDimensionType = new ListStore<TabResource>(
				propsDimensionType.id());

		comboDimensionType = new ComboBox<TabResource>(storeComboDimensionType,
				propsDimensionType.label());
		Log.trace("ComboDimensionType created");

		comboDimensionType.setEmptyText("Select a Dimension...");
		comboDimensionType.setWidth(150);
		comboDimensionType.setTypeAhead(true);
		comboDimensionType.setTriggerAction(TriggerAction.ALL);

		comboDimensionType
				.addBeforeShowContextMenuHandler(new BeforeShowContextMenuHandler() {

					public void onBeforeShowContextMenu(
							BeforeShowContextMenuEvent event) {
						callDialogCodelistSelection();
						comboDimensionType.collapse();

					}
				});

		comboDimensionTypeLabel = new FieldLabel(comboDimensionType, "Codelist");
		comboDimensionTypeLabel.setVisible(false);

		// Change
		change = new TextButton("Change");
		SelectHandler changeHandler = new SelectHandler() {

			public void onSelect(SelectEvent event) {
				onChangeTypeColumn();

			}
		};
		change.addSelectHandler(changeHandler);

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(new FieldLabel(comboColumn, "Column"), new VerticalLayoutData(1,
				-1));
		v.add(new FieldLabel(comboColumnTypeCode, "Column Type"),
				new VerticalLayoutData(1, -1));
		v.add(comboMeasureTypeLabel, new VerticalLayoutData(1, -1));
		v.add(comboAttributeTypeLabel, new VerticalLayoutData(1, -1));
		v.add(change, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		add(v, new VerticalLayoutData(-1, -1, new Margins()));

		// addButton();
	}

	protected void addHandlersForComboColumn(
			final LabelProvider<ColumnData> labelProvider) {
		comboColumn.addSelectionHandler(new SelectionHandler<ColumnData>() {
			public void onSelection(SelectionEvent<ColumnData> event) {
				Info.display(
						"Column Type Selected",
						"You selected "
								+ (event.getSelectedItem() == null ? "nothing"
										: labelProvider.getLabel(event
												.getSelectedItem()) + "!"));
				Log.debug("ComboColumn selected: " + event.getSelectedItem());
				ColumnData columnData = event.getSelectedItem();
				updateComboStatus(columnData);
			}

		});
	}

	protected void addHandlersForComboColumnTypeCode(
			final LabelProvider<ColumnTypeCodeElement> labelProvider) {
		comboColumnTypeCode
				.addSelectionHandler(new SelectionHandler<ColumnTypeCodeElement>() {
					public void onSelection(
							SelectionEvent<ColumnTypeCodeElement> event) {
						Info.display(
								"Column Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnTypeCode selected: "
								+ event.getSelectedItem());
						ColumnTypeCodeElement columnType = event
								.getSelectedItem();
						updateColumnType(columnType.getCode());
					}

				});
	}

	protected void addHandlersForComboMeasureType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboMeasureType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Measure Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboMeasureType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement measureType = event
								.getSelectedItem();
						updateMeasureType(measureType.getType());
					}

				});
	}

	protected void addHandlersForComboAttributeType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboAttributeType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Attribute Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboAttributeType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement attributeType = event
								.getSelectedItem();
						updateAttributeType(attributeType.getType());
					}

				});
	}

	protected void updateColumnType(ColumnTypeCode type) {
		Log.debug("Update ColumnTypeCode " + type.toString());
		if (type == ColumnTypeCode.MEASURE) {
			comboMeasureTypeLabel.setVisible(true);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
		} else {
			if (type == ColumnTypeCode.ATTRIBUTE) {
				comboMeasureTypeLabel.setVisible(false);
				comboAttributeTypeLabel.setVisible(true);
				comboDimensionTypeLabel.setVisible(false);
			} else {
				if (type == ColumnTypeCode.DIMENSION) {
					comboMeasureTypeLabel.setVisible(false);
					comboAttributeTypeLabel.setVisible(false);
					comboDimensionTypeLabel.setVisible(true);
				} else {
					comboMeasureTypeLabel.setVisible(false);
					comboAttributeTypeLabel.setVisible(false);
					comboDimensionTypeLabel.setVisible(false);
				}
			}

		}
	}

	protected void updateMeasureType(ColumnDataType type) {

	}

	protected void updateAttributeType(ColumnDataType type) {

	}

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<ColumnData>> callback) {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						Log.error("load combo failure:"
								+ caught.getLocalizedMessage());
						AlertMessageBox d = new AlertMessageBox("Error",
								"Error retrieving columns of tabular resource:"
										+ trId.getId());
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {

							}
						});
						d.show();
						callback.onFailure(caught);
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						setComboStatus(result);
						callback.onSuccess(new ListLoadResultBean<ColumnData>(
								result));

					}

				});

	}

	protected void setComboStatus(ArrayList<ColumnData> result) {
		Log.debug("ColumnName:" + columnName);
		if (columnName != null) {
			for (ColumnData cd : result) {
				Log.debug("ColumnData name:" + cd.getName());
				if (cd.getName().compareTo(columnName) == 0) {
					updateComboStatus(cd);
				}
			}
		}
	}

	protected void updateComboStatus(ColumnData cd) {
		Log.debug("ColumnData: " + cd.toString());
		changeColumnTypeSession = new ChangeColumnTypeSession();
		changeColumnTypeSession.setColumnData(cd);
		comboColumn.setValue(cd);
		comboColumnTypeCode.setValue(ColumnTypeCodeStore.selectedElement(cd
				.getTypeCode()));
		ColumnTypeCode type = ColumnTypeCodeStore.selected(cd.getTypeCode());
		changeColumnTypeSession.setColumnTypeCode(type);
		updateColumnType(type);
		if (type == ColumnTypeCode.MEASURE) {
			changeColumnTypeSession.setColumnDataType(ColumnDataTypeStore
					.selectedMeasure(cd.getDataTypeName()));
			comboMeasureType.setValue(ColumnDataTypeStore
					.selectedMeasureElement(cd.getDataTypeName()));

		} else {
			if (type == ColumnTypeCode.ATTRIBUTE) {
				changeColumnTypeSession.setColumnDataType(ColumnDataTypeStore
						.selectedAttribute(cd.getDataTypeName()));
				comboAttributeType.setValue(ColumnDataTypeStore
						.selectedAttributeElement(cd.getDataTypeName()));
			} else {

			}

		}
	}

	public void update(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;
		loader.load();
	}

	protected void onChangeTypeColumn() {

		ColumnData columnData = comboColumn.getCurrentValue();
		if (columnData != null) {
			ColumnTypeCodeElement columnTypeCodeElement = comboColumnTypeCode
					.getCurrentValue();
			if (columnTypeCodeElement != null) {
				ColumnTypeCode type = columnTypeCodeElement.getCode();
				if (type == ColumnTypeCode.MEASURE) {
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					ColumnDataTypeElement columnDataTypeElement = comboMeasureType
							.getCurrentValue();
					if (columnDataTypeElement != null) {
						ColumnDataType dataType = columnDataTypeElement
								.getType();
						if (dataType != null) {
							changeColumnTypeSession
									.setColumnDataTypeTarget(dataType);
							callChangeColumnType();
						} else {
							alert("Attention", "Column data type not selected!");
						}

					} else {
						alert("Attention", "Column data type not selected!");
					}
				} else {
					if (type == ColumnTypeCode.ATTRIBUTE) {
						changeColumnTypeSession.setColumnTypeCodeTarget(type);
						ColumnDataTypeElement columnDataTypeElement = comboAttributeType
								.getCurrentValue();
						if (columnDataTypeElement != null) {
							ColumnDataType dataType = columnDataTypeElement
									.getType();
							if (dataType != null) {
								changeColumnTypeSession
										.setColumnDataTypeTarget(dataType);
								callChangeColumnType();
							} else {
								alert("Attention",
										"Column data type not selected!");
							}
						} else {
							alert("Attention", "Column data type not selected!");
						}
					} else {
						if (type == ColumnTypeCode.CODE) {
							changeColumnTypeSession
									.setColumnTypeCodeTarget(type);
							callChangeColumnType();

						} else {
							if (type == ColumnTypeCode.CODENAME) {
								changeColumnTypeSession
										.setColumnTypeCodeTarget(type);
								callChangeColumnType();

							} else {
								if (type == ColumnTypeCode.CODEDESCRIPTION) {
									changeColumnTypeSession
											.setColumnTypeCodeTarget(type);
									callChangeColumnType();

								} else {
									if (type == ColumnTypeCode.ANNOTATION) {
										changeColumnTypeSession
												.setColumnTypeCodeTarget(type);
										callChangeColumnType();

									} else {
										alert("Attention",
												"This column type is not supported now!");
									}
								}
							}
						}

					}

				}
			} else {
				alert("Attention", "Select a column type!");
			}
		} else {
			alert("Attention", "Select a column!");
		}
	}

	private void callChangeColumnType() {
		TDGWTServiceAsync.INSTANCE.startChangeColumnType(
				changeColumnTypeSession, new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						Log.debug("Change Column Type Error: "
								+ caught.getLocalizedMessage());
						alert("Change Column Type Error ",
								"Error in invocation of  change column type operation!");

					}

					public void onSuccess(Void result) {
						changeColumnTypeProgressDialog = new ChangeColumnTypeProgressDialog(
								changeColumnTypeSession, eventBus);
					}

				});

	}

	protected void alert(String title, String message) {
		final AlertMessageBox d = new AlertMessageBox(title, message);
		d.addHideHandler(new HideHandler() {

			public void onHide(HideEvent event) {

			}
		});
		d.show();

	}

	protected void callDialogCodelistSelection() {
		DialogCodelistSelection dialogCodelistSelection = new DialogCodelistSelection(
				eventBus);
		dialogCodelistSelection.show();
	}

}
