package org.gcube.portlets.user.td.columnwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * Change Column Label Dialog
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ChangeLabelColumnDialog extends Window {
	protected int WIDTH=400;
	protected int HEIGHT=140;
	protected TRId trId;
	protected TextField label = null;
	protected String columnName = null;
	protected ColumnData column = null;
	protected ComboBox<ColumnData> combo = null;

	public ChangeLabelColumnDialog(TRId trId) {
		create(trId, null);
	}

	public ChangeLabelColumnDialog(TRId trId, String columnName) {
		create(trId, columnName);
	}

	protected void create(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Change Column Label");
		// getHeader().setIcon(Resources.IMAGES.side_list());

		FramedPanel panel=new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);
		
		VerticalLayoutContainer v = new VerticalLayoutContainer();

		ColumnDataProperties props = GWT.create(ColumnDataProperties.class);
		ListStore<ColumnData> store = new ListStore<ColumnData>(props.id());

		Log.trace("Store created");
		RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<ColumnData>> callback) {
				loadData(loadConfig, callback);
			}
		};
		final ListLoader<ListLoadConfig, ListLoadResult<ColumnData>> loader = new ListLoader<ListLoadConfig, ListLoadResult<ColumnData>>(
				proxy);
		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ColumnData, ListLoadResult<ColumnData>>(
				store));
		Log.trace("Loader created");

		label = new TextField();
		label.setAllowBlank(false);
		label.setWidth(150);

		combo = new ComboBox<ColumnData>(store, props.label()) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load();
					}
				});
			}
		};
		Log.trace("Combo created");

		addHandlersForEventObservation(combo, props.label());

		combo.setEmptyText("Select a column...");
		combo.setWidth(150);
		combo.setTypeAhead(true);
		combo.setTriggerAction(TriggerAction.ALL);
		combo.setLoader(loader);
		v.add(new FieldLabel(combo, "Column"), new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(new FieldLabel(label, "Column Label"), new VerticalLayoutData(1,
				-1, new Margins(1)));


		panel.add(v);
		panel.addButton(new TextButton("Change"));
		
		add(panel);

	}

	private <T> void addHandlersForEventObservation(ComboBox<T> combo,
			final LabelProvider<T> labelProvider) {
		combo.addValueChangeHandler(new ValueChangeHandler<T>() {

			public void onValueChange(ValueChangeEvent<T> event) {
				Info.display(
						"Value Changed",
						"New value: "
								+ (event.getValue() == null ? "nothing"
										: labelProvider.getLabel(event
												.getValue()) + "!"));

			}
		});
		combo.addSelectionHandler(new SelectionHandler<T>() {
			public void onSelection(SelectionEvent<T> event) {
				Info.display(
						"State Selected",
						"You selected "
								+ (event.getSelectedItem() == null ? "nothing"
										: labelProvider.getLabel(event
												.getSelectedItem()) + "!"));
			}
		});
	}

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<ColumnData>> callback) {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						final Throwable c = caught;
						Log.error("load combo failure:"
								+ caught.getLocalizedMessage());
						HideHandler hideHandler = new HideHandler() {
							public void onHide(HideEvent event) {
								callback.onFailure(c);
							}
						};
						AlertMessageBox d  = new AlertMessageBox("Error",
								caught.getMessage());
						d.addHideHandler(hideHandler);
						d.show();

					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						if (columnName != null) {
							for (ColumnData cd : result) {
								if (cd.getName().compareTo(columnName) == 0) {
									combo.setValue(cd);
									column = cd;
									label.setValue(cd.getLabel());

								}
							}
						}
						callback.onSuccess(new ListLoadResultBean<ColumnData>(
								result));

					}

				});

	}
}
