package org.gcube.portlets.user.td.columnwidget.client.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.OrderInfo;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.SortDir;
import com.sencha.gxt.data.shared.SortInfo;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.data.shared.loader.PagingLoadConfig;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoadResultBean;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.LiveGridView;
import com.sencha.gxt.widget.core.client.grid.LiveToolItem;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import com.google.web.bindery.event.shared.EventBus;

public class DialogCodelistSelection extends Window {
	protected static final int WIDTH = 550;
	protected static final int HEIGHT = 520;
	protected static final int CACHE_SIZE = 200;
	
	
	private static final TabResourcesProperties properties = GWT
			.create(TabResourcesProperties.class);

	protected static final ColumnConfig<TabResource, String> nameColumn = new ColumnConfig<TabResource, String>(
			properties.name(), 50, "Name");
	protected static final ColumnConfig<TabResource, String> agencyColumn = new ColumnConfig<TabResource, String>(
			properties.agency(), 50, "Agency");
	protected static final ColumnConfig<TabResource, String> dateColumn = new ColumnConfig<TabResource, String>(
			properties.date(), 50, "Date");
	
	protected EventBus eventBus;
	protected Grid<TabResource> grid;
	protected ExtendedLiveGridView liveGridView;
	protected PagingLoader<PagingLoadConfig, PagingLoadResult<TabResource>> loader;
	protected String filter;
	
	protected ResourceBundle res;
	
	public DialogCodelistSelection(EventBus eventBus) {
		this.eventBus=eventBus;
		Log.info("Dialog CodelistSelection");
		setWidth(WIDTH);
		setHeight(HEIGHT);
		res = ResourceBundle.INSTANCE;
		setBodyBorder(false);
		setResizable(true);
		setHeadingText("Select Codelist");

		FramedPanel panel = new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);

		VerticalLayoutContainer v = new VerticalLayoutContainer();

		// Search
		ToolBar toolBar = new ToolBar();
		toolBar.add(new LabelToolItem("Search: "));
		final TextField searchField = new TextField();
		toolBar.add(searchField);

		TextButton btnReload = new TextButton();
		btnReload.setText("Reload");
		btnReload.setIcon(res.refresh());
		btnReload.setToolTip("Reload");
		toolBar.add(btnReload);

		IdentityValueProvider<TabResource> identity = new IdentityValueProvider<TabResource>();
		final CheckBoxSelectionModel<TabResource> sm = new CheckBoxSelectionModel<TabResource>(
				identity);

		List<ColumnConfig<TabResource, ?>> columns = Arrays
				.<ColumnConfig<TabResource, ?>> asList(nameColumn,
						agencyColumn, dateColumn);

		ColumnModel<TabResource> cm = new ColumnModel<TabResource>(columns);

		final ListStore<TabResource> store = new ListStore<TabResource>(
				properties.id());

		searchField.addKeyUpHandler(new KeyUpHandler() {

			public void onKeyUp(KeyUpEvent event) {
				Log.trace("searchTerm: " + searchField.getCurrentValue());
				filter=searchField.getCurrentValue();
				if(filter!=null&& !filter.isEmpty()){
					loader.load(0, liveGridView.getCacheSize());
				}
			}
		});

		RpcProxy<PagingLoadConfig, PagingLoadResult<TabResource>> proxy = new RpcProxy<PagingLoadConfig, PagingLoadResult<TabResource>>() {

			public void load(PagingLoadConfig loadConfig,
					final AsyncCallback<PagingLoadResult<TabResource>> callback) {
				loadData(loadConfig, callback);
				
			}
		};
		loader = new PagingLoader<PagingLoadConfig, PagingLoadResult<TabResource>>(
				proxy);

		loader.setRemoteSort(true);

		loader.addLoadHandler(new LoadResultListStoreBinding<PagingLoadConfig, TabResource, PagingLoadResult<TabResource>>(
				store));

		liveGridView = new ExtendedLiveGridView();
		liveGridView.setForceFit(true);
		liveGridView.setEmptyText("No Matching Results.");
		liveGridView.setCacheSize(CACHE_SIZE);

		grid = new Grid<TabResource>(store, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load(0, liveGridView.getCacheSize());
					}
				});
			}
		};

		sm.setSelectionMode(SelectionMode.SINGLE);
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		grid.setView(liveGridView);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);

		SelectHandler sh = new SelectHandler() {
			public void onSelect(SelectEvent event) {
				loader.load();
			}
		};

		btnReload.addSelectHandler(sh);

		ToolBar baseToolBar = new ToolBar();
		baseToolBar.add(new LiveToolItem(grid));
		baseToolBar.addStyleName(ThemeStyles.getStyle().borderTop());
		baseToolBar.getElement().getStyle().setProperty("borderBottom", "none");

		v.add(toolBar, new VerticalLayoutData(-1, -1));
		v.add(grid, new VerticalLayoutData(1, 1));
		v.add(baseToolBar, new VerticalLayoutData(1, 25));

		panel.add(v);
		panel.addButton(new TextButton("Select"));

		add(panel);

	}

	protected void loadData(PagingLoadConfig loadConfig,
			final AsyncCallback<PagingLoadResult<TabResource>> callback) {
		List<? extends SortInfo> sortInfo = loadConfig.getSortInfo();
		Iterator<? extends SortInfo> iterator = sortInfo.iterator();
		ArrayList<OrderInfo> listOrderInfo = new ArrayList<OrderInfo>();

		while (iterator.hasNext()) {
			SortInfo info = iterator.next();
			OrderInfo ord = new OrderInfo();
			SortDir sd = info.getSortDir();
			if (sd.compareTo(SortDir.ASC) == 0) {
				ord.setDirection(Direction.ASC);
			} else {
				ord.setDirection(Direction.DESC);
			}
			ord.setField(info.getSortField());
			listOrderInfo.add(ord);
		}

		CodelistPagingLoadConfig codelistPagingLoadConfig = new CodelistPagingLoadConfig(
				loadConfig.getOffset(), loadConfig.getLimit(), listOrderInfo,
				filter);

		TDGWTServiceAsync.INSTANCE.getCodelistsPagingLoader(
				codelistPagingLoadConfig,
				new AsyncCallback<CodelistPagingLoadResult>() {

					@Override
					public void onFailure(Throwable caught) {
						Log.debug("Error Retrieving Codelist",
								caught.getMessage());
						caught.printStackTrace();
						alert("Error Retrieving Codelist",
								"Error retrieving codelist on server");

					}

					@Override
					public void onSuccess(CodelistPagingLoadResult result) {
						callback.onSuccess(new PagingLoadResultBean<TabResource>(
								result.getLtr(), result.getTotalLenght(),
								result.getOffset()));

					}
				});

	
	}

	protected HandlerRegistration addSelectionHandler(
			SelectionHandler<TabResource> handler) {
		SelectionHandler<TabResource> hand = new SelectionHandler<TabResource>() {

			public void onSelection(SelectionEvent<TabResource> event) {
				// tabResourcesSelectionPanel.getSelectedItem();
				// getWizardWindow().setEnableNextButton(true);
			}

		};

		return grid.getSelectionModel().addSelectionHandler(hand);
	}

	public TabResource getSelectedItem() {
		return grid.getSelectionModel().getSelectedItem();
	}

	protected class ExtendedLiveGridView extends LiveGridView<TabResource> {

		@Override
		public void refresh(boolean headerToo) {
			preventScrollToTopOnRefresh = true;
			super.refresh(headerToo);
		}
	};

	private void alert(String title, String message) {
		final AlertMessageBox d = new AlertMessageBox(title, message);
		d.addHideHandler(new HideHandler() {

			public void onHide(HideEvent event) {

			}
		});
		d.show();

	}

}
