package org.gcube.portlets.user.td.expressionwidget.server;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionService;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionServiceException;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterMonitor;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterSession;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class ExpressionServiceImpl extends RemoteServiceServlet implements
		ExpressionService {

	private static final long serialVersionUID = 4632292751581364137L;

	protected static Logger logger = LoggerFactory
			.getLogger(ExpressionServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm");

	protected OperationExecution retrieveOperationExecution(
			TabularDataService service, ColumnFilterSession columnFilterSession)
			throws TDGWTServiceException {
		
		OperationExecution invocation = null;

		OperationDefinition operationDefinition;
		Map<String, Object> map = new HashMap<String, Object>();
		
		C_ExpressionParser parser=new C_ExpressionParser();
		Expression exp=parser.parse(columnFilterSession.getCexpression());
		logger.debug("Service Expression:"+exp);
		
		map.put(Constants.PARAMETER_EXPRESSION, exp);
		
		operationDefinition = OperationDefinitionMap.map(
				OperationsId.FilterByExpression.toString(), service);

		invocation = new OperationExecution(operationDefinition.getOperationId(), map);

		return invocation;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void submitColumnFilter(ColumnFilterSession columnFilterSession)
			throws ExpressionServiceException {

		try {
			logger.debug("ExprssionService submitColumnFilter");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: "+session);
			ASLSession aslSession = SessionUtil.getAslSession(session);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername()));
			
			logger.debug(columnFilterSession.toString());
			ExpressionSession.setColumnFilterSession(session, columnFilterSession);
			
			TabularDataService service = TabularDataServiceFactory.getService();
			OperationExecution invocation = retrieveOperationExecution(service,
					columnFilterSession);

			logger.debug("OperationInvocation: \n" + invocation.toString());
			TabularResourceId id=new TabularResourceId(Long.valueOf(columnFilterSession.getColumn().getTrId().getId()));
			Task trTask = service.execute(invocation,id);
			logger.debug("Start Task on service: TaskId " + trTask.getId());
			ExpressionSession.setColumnFilterTask(session, trTask);
			return;
		} catch (TDGWTSessionExpiredException e){
			throw new ExpressionServiceException(e.getLocalizedMessage());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new ExpressionServiceException(
					"Error in Client Library Request: "
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public ColumnFilterMonitor getColumnFilterMonitor()
			throws ExpressionServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ColumnFilterSession columnFilterSession = ExpressionSession
					.getColumnFilterSession(session);

			Task task = ExpressionSession.getColumnFilterTask(session);
			ColumnFilterMonitor columnFilterMonitor = new ColumnFilterMonitor();

			if (task == null) {
				logger.debug("Task null");
				throw new ExpressionServiceException(
						"Error in ColumnFilter task null");
			} else {
				TaskStatus status = task.getStatus();
				if (status == null) {
					logger.debug("Services TaskStatus : null");
					throw new ExpressionServiceException(
							"Error in ColumnFilter Status null");
				} else {
					logger.debug("Services TaskStatus: " + task.getStatus());

					columnFilterMonitor.setStatus(TaskStateMap.map(task
							.getStatus()));
					switch (columnFilterMonitor.getStatus()) {
					case FAILED:
						if (task.getResult() != null) {
							logger.debug("Task exception:"
									+ task.getErrorCause());
							columnFilterMonitor.setError(new Throwable(task
									.getErrorCause()));
						} else {
							logger.debug("Task exception: Error In Column Filter");
							columnFilterMonitor.setError(new Throwable(
									"Error In Column Filter"));
						}
						columnFilterMonitor.setProgress(task.getProgress());
						break;
					case SUCCEDED:
						logger.debug("Task Result:" + task.getResult());
						columnFilterMonitor.setProgress(task.getProgress());
						Table table = task.getResult().getPrimaryTable();
						logger.debug("Table retrived: " + table.toString());
						TRId trId = new TRId();
						logger.debug("ColumnFilterSession TRId: "+columnFilterSession.getColumn().getTrId());
						trId.setId(columnFilterSession.getColumn().getTrId()
								.getId());
						trId.setTableId(String
								.valueOf(table.getId().getValue()));
						trId.setTableType(table.getTableType().getName());
						columnFilterMonitor.setTrId(trId);
						TabResource tabResource = SessionUtil
								.getTabResource(session);
						tabResource.setTrId(trId);
						SessionUtil.setTabResource(session, tabResource);
						SessionUtil.setTRId(session, trId);
						break;
					case IN_PROGRESS:
						columnFilterMonitor.setProgress(task.getProgress());
						break;
					case VALIDATING_RULES:
						columnFilterMonitor.setProgress(task.getProgress());
						break;
					case GENERATING_VIEW:
						break;	
					case ABORTED:
						break;
					case STOPPED:
						columnFilterMonitor.setError(new Throwable(
								"Operation Stopped on service"));
						break;
					case INITIALIZING:
						break;
					default:
						break;
					}
				}
				ExpressionSession.setColumnFilterTask(session, task);
			}

			logger.info("ColumnFilterMonitor(): " + columnFilterMonitor);
			return columnFilterMonitor;
		} catch (TDGWTSessionExpiredException e){
			throw new ExpressionServiceException(e.getLocalizedMessage());
		} catch (Throwable e) {
			e.printStackTrace();
			throw new ExpressionServiceException(
					"Error applying column filter: " + e.getLocalizedMessage());

		}

	}

}