package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.BeforeShowEvent;
import com.sencha.gxt.widget.core.client.event.BeforeShowEvent.BeforeShowHandler;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class MultiColumnFilterPanel extends SimplePanel {
	protected String WIDTH = "648px";
	protected String HEIGHT = "444px";

	protected TRId trId;
	protected ArrayList<ColumnData> columns;
	
	protected EventBus eventBus;
	protected MultiColumnFilterDialog multiColumnFilterDialog;
	
	public MultiColumnFilterPanel(
			MultiColumnFilterDialog multiColumnFilterDialog,
			TRId trId, EventBus eventBus) {
		super();
		Log.debug("Create MultiColumnFilterPanel");
		setHeight(HEIGHT);
		setWidth(WIDTH);
		this.multiColumnFilterDialog=multiColumnFilterDialog;
		this.trId=trId;
		this.eventBus = eventBus;
		UtilsGXT3.mask(this.getElement());	
		load(trId);
	}
		
		
	protected void create(){
		UtilsGXT3.umask(this.getElement());
		
		VerticalLayoutContainer vl=new VerticalLayoutContainer();
		vl.setBorders(false);
	
		final MultiColumnFilterTabPanel mcfTabPanel=new MultiColumnFilterTabPanel(this,eventBus);
		vl.add(mcfTabPanel);
		
		mcfTabPanel.addBeforeShowHandler(new BeforeShowHandler() {
			
			public void onBeforeShow(BeforeShowEvent event) {
				mcfTabPanel.forceLayout();
				
			}
		});
		
		final SimplePanel bo=new SimplePanel();
		bo.add(new HTML("Expression"));
		vl.add(bo);
		
		add(vl);
	}
	
	
	
	
	protected void load(TRId trId) {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					@Override
					public void onFailure(Throwable caught) {
						Log.error("Error retrieving columns: "
								+ caught.getMessage());
						AlertMessageBox d = new AlertMessageBox(
								"Error retrieving columns", caught.getMessage());
						d.addHideHandler(new HideHandler() {
							public void onHide(HideEvent event) {
								multiColumnFilterDialog.hide();
							}
						});
						d.show();

					}

					@Override
					public void onSuccess(ArrayList<ColumnData> result) {
						Log.debug("Retrived column: " + result);
						columns = result;
						create();
					}
				});

	}

}
