/**
 * 
 */
package org.gcube.portlets.user.td.expressionwidget.server;

import javax.servlet.http.HttpSession;

import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterMonitor;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ExpressionSession {

	
	protected static final String COLUMN_FILTER_SESSION = "COLUMN_FILTER_SESSION";
	protected static final String COLUMN_FILTER_SESSION_TASK = "COLUMN_FILTER_SESSION_TASK";
	protected static final String COLUMN_FILTER_SESSION_MONITOR = "COLUMN_FILTER_SESSION_MONITOR";

	
	protected static Logger logger = LoggerFactory.getLogger(ExpressionSession.class);


	public static ColumnFilterSession getColumnFilterSession(
			HttpSession httpSession) {
		ColumnFilterSession columnFilterSession = (ColumnFilterSession) httpSession
				.getAttribute(COLUMN_FILTER_SESSION);
		if (columnFilterSession != null) {
			return columnFilterSession;
		} else {
			columnFilterSession = new ColumnFilterSession();
			httpSession.setAttribute(COLUMN_FILTER_SESSION,
					columnFilterSession);
			return columnFilterSession;
		}
	}

	public static void setColumnFilterSession(HttpSession httpSession,
			ColumnFilterSession columnFilterSession) {
		ColumnFilterSession cf = (ColumnFilterSession) httpSession
				.getAttribute(COLUMN_FILTER_SESSION);
		if (cf != null) {
			httpSession.removeAttribute(COLUMN_FILTER_SESSION);
		}
		httpSession.setAttribute(COLUMN_FILTER_SESSION,
				columnFilterSession);

	}

	public static ColumnFilterMonitor getColumnFilterMonitor(
			HttpSession httpSession) {
		ColumnFilterMonitor columnFilterMonitor = (ColumnFilterMonitor) httpSession
				.getAttribute(COLUMN_FILTER_SESSION_MONITOR);
		if (columnFilterMonitor != null) {
			return columnFilterMonitor;
		} else {
			columnFilterMonitor = new ColumnFilterMonitor();
			httpSession.setAttribute(COLUMN_FILTER_SESSION_MONITOR,
					columnFilterMonitor);
			return columnFilterMonitor;
		}
	}

	public static void setColumnFilterMonitor(HttpSession httpSession,
			ColumnFilterMonitor columnFilterMonitor) {
		ColumnFilterMonitor cf = (ColumnFilterMonitor) httpSession
				.getAttribute(COLUMN_FILTER_SESSION_MONITOR);
		if (cf != null) {
			httpSession.removeAttribute(COLUMN_FILTER_SESSION_MONITOR);
		}
		httpSession.setAttribute(COLUMN_FILTER_SESSION_MONITOR,
				columnFilterMonitor);

	}

	public static Task getColumnFilterTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(COLUMN_FILTER_SESSION_TASK);
		if (monitor == null) {
			logger.error("CHANGE_THE_COLUMN_LABEL_TASK was not acquired");
		}
		return monitor;
	}

	public static void setColumnFilterTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(COLUMN_FILTER_SESSION_TASK);
		if (monitor != null)
			httpSession.removeAttribute(COLUMN_FILTER_SESSION_TASK);
		httpSession.setAttribute(COLUMN_FILTER_SESSION_TASK, task);
	}
	
	

}
