package org.gcube.portlets.user.td.expressionwidget.server;

import java.text.SimpleDateFormat;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionService;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionParserException;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionServiceException;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.TDGWTServiceImpl;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class ExpressionServiceImpl extends RemoteServiceServlet implements
		ExpressionService {

	private static final long serialVersionUID = 4632292751581364137L;

	protected static Logger logger = LoggerFactory
			.getLogger(ExpressionServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm");

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startFilterColumn(FilterColumnSession filterColumnSession)
			throws TDGWTServiceException {

		try {
			logger.debug("ExpressionService submitColumnFilter");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: " + session);

			if (filterColumnSession == null) {
				logger.error("FilterColumnSession is null");
				new ExpressionServiceException("FilterColumnSession is null");
			}
			ExpressionSession.setColumnFilterSession(session,
					filterColumnSession);

			C_ExpressionParser parser = new C_ExpressionParser();
			Expression expression;
			try {
				expression = parser.parse(filterColumnSession.getCexpression());
			} catch (ExpressionParserException e) {
				logger.debug(e.getLocalizedMessage());
				throw new TDGWTServiceException(e.getLocalizedMessage());
			}
			logger.debug("Service Expression:" + expression);

			TDGWTServiceImpl gwtService = new TDGWTServiceImpl();

			String taskId = gwtService.startFilterColumn(filterColumnSession,
					expression, session);

			return taskId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startReplaceColumnByExpression(
			ReplaceColumnByExpressionSession replaceColumnByExpressionSession)
			throws TDGWTServiceException {

		try {
			logger.debug("ExpressionService submitReplaceColumnByExpression");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: " + session);

			if (replaceColumnByExpressionSession == null) {
				logger.error("ReplaceColumnByExpressionSession is null");
				new ExpressionServiceException(
						"ReplaceColumnByExpressionSession is null");
			}
			ExpressionSession.setReplaceColumnByExpressionSession(session,
					replaceColumnByExpressionSession);

			C_ExpressionParser parser = new C_ExpressionParser();
			Expression conditionExpression;
			try {
				conditionExpression = parser
						.parse(replaceColumnByExpressionSession
								.getcConditionExpression());
			} catch (ExpressionParserException e) {
				logger.debug(e.getLocalizedMessage());
				throw new TDGWTServiceException(e.getLocalizedMessage());
			}

			logger.debug("Service Condition Expression:" + conditionExpression);

			Expression replaceExpression = null;
			if (!replaceColumnByExpressionSession.isReplaceByValue()) {
				replaceExpression = parser
						.parse(replaceColumnByExpressionSession
								.getcReplaceExpression());
				logger.debug("Service Replace Expression:"
						+ conditionExpression);
			}

			TDGWTServiceImpl gwtService = new TDGWTServiceImpl();

			String taskId = gwtService.startReplaceColumnByExpression(
					replaceColumnByExpressionSession, conditionExpression,
					replaceExpression, session);
			return taskId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in startReplaceColumnByExpression:"
							+ e.getLocalizedMessage());
		}
	}

	/**
	 * Retrieve and set Tabular Resource Type
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	protected TRId retrieveTabularResourceBasicData(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			Table table = service.getLastTable(tabularResourceId);

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TRId newTRId;
			if (viewTable == null) {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(table.getId()
								.getValue()), table.getTableType().getName());

			} else {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(viewTable.getId()
								.getValue()), viewTable.getTableType()
								.getName(), String.valueOf(table.getId()
								.getValue()), true);

			}

			logger.debug("Retrieved TRId basic info:" + newTRId.toString());
			return newTRId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

}