package org.gcube.portlets.user.td.expressionwidget.client;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class MultiColumnFilterDialog extends Window {
	protected String WIDTH = "660px";
	protected String HEIGHT = "480px";
	protected C_Expression exp = null;
	protected TRId trId;
	protected EventBus eventBus;
	
	public MultiColumnFilterDialog(TRId trId, EventBus eventBus) {
		this.eventBus = eventBus;
		this.trId = trId;
		initWindow();
		create();

	}

	protected void create(){	
		final MultiColumnFilterPanel mcfPanel=new MultiColumnFilterPanel(this, trId,eventBus);
		add(mcfPanel);
		
	}
	
	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Filter");
		setClosable(true);
		getHeader().setIcon(ExpressionResources.INSTANCE.filter());

	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			
			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}
	
	protected void close() {
		hide();
	}

}
