package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.Date;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.OperatorTypeMapException;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ReplaceTypeMapException;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.TD_Value;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.monitorwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeMap;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.core.client.util.ToggleGroup;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.Radio;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceColumnByExpressionPanel extends FramedPanel {
	private static final String GEOMETRY_REGEXPR = "(\\s*POINT\\s*\\(\\s*(-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*\\)\\s*$)"
			+ "|(\\s*LINESTRING\\s*\\((\\s*(-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*,)+\\s*((-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*)\\)\\s*$)";

	protected static final String WIDTH = "868px";
	protected static final String HEIGHT = "454px";
	protected static final String HEIGHT_REDUCE = "368px";

	protected static final String CONDITIONWIDTH = "832px";
	protected static final String CONDITIONHEIGHT = "120px";
	protected static final String CONDITION_LAYOUT_WIDTH = "832px";
	protected static final String REPLACEWIDTH = "832px";
	protected static final String REPLACEHEIGHT = "120px";
	protected static final String ALL_ROWS_FIELD_WIDTH = "832px";

	protected static final String RADIO_LABEL_BY_CONDITION = "By Condition";
	protected static final String RADIO_LABEL_ALL_ROWS = "All Rows";

	protected EventBus eventBus;

	protected ReplaceColumnByExpressionDialog parent;

	protected ColumnData column;

	private DateTimeFormat sdf = DateTimeFormat.getFormat("yyyy-MM-dd");

	private TextButton btnApply;
	private TextButton btnClose;

	private FieldSet conditionsFieldSet;
	private ConditionWidget conditionWidget;

	private ReplaceWidget replaceWidget;
	private TextField replaceValue;
	private DateField replaceValueDate;

	private VerticalLayoutContainer conditionsVerticalLayout;
	private FieldLabel allRowsField;
	private boolean allRows;

	public ReplaceColumnByExpressionPanel(
			ReplaceColumnByExpressionDialog parent, ColumnData column,
			EventBus eventBus) {
		super();
		this.parent = parent;
		this.column = column;
		this.eventBus = eventBus;
		Log.debug(column.toString());
		init();
		create();
	}

	protected void init() {
		setWidth(WIDTH);
		if (column != null
				&& column.getDataTypeName().compareTo(
						ColumnDataType.Text.toString()) == 0) {
			setHeight(HEIGHT);
		} else {
			setHeight(HEIGHT_REDUCE);
		}
		setBodyBorder(false);
		setHeaderVisible(false);
		// Important: fixed rendering of widgets
		forceLayoutOnResize = true;

	}

	protected void create() {
		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);
		basicLayout.setScrollMode(ScrollMode.AUTO);

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		// Properties
		FieldSet properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		VerticalLayoutContainer propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		TextField columnName = new TextField();
		columnName.setToolTip("Column");
		columnName.setReadOnly(true);
		columnName.setValue(column.getLabel());
		propertiesLayout.add(new FieldLabel(columnName, "Column"),
				new VerticalLayoutData(1, -1));

		// Conditions
		conditionsFieldSet = new FieldSet();
		conditionsFieldSet.setHeadingText("Conditions");
		conditionsFieldSet.setCollapsible(false);

		conditionsVerticalLayout = new VerticalLayoutContainer();
		conditionsVerticalLayout.setWidth(CONDITION_LAYOUT_WIDTH);

		Radio radioAllRowsTrue = new Radio();
		radioAllRowsTrue.setBoxLabel(RADIO_LABEL_ALL_ROWS);

		Radio radioAllRowsFalse = new Radio();
		radioAllRowsFalse.setBoxLabel(RADIO_LABEL_BY_CONDITION);

		radioAllRowsTrue.setValue(true);
		allRows = true;

		ToggleGroup toggleGroup = new ToggleGroup();
		toggleGroup.add(radioAllRowsTrue);
		toggleGroup.add(radioAllRowsFalse);

		toggleGroup
				.addValueChangeHandler(new ValueChangeHandler<HasValue<Boolean>>() {

					@Override
					public void onValueChange(
							ValueChangeEvent<HasValue<Boolean>> event) {
						callAllRowChange(event);

					}
				});

		HorizontalPanel hp = new HorizontalPanel();
		hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		hp.add(radioAllRowsTrue);
		hp.add(radioAllRowsFalse);
		hp.setWidth("140px");

		allRowsField = new FieldLabel(hp, "Select");
		allRowsField.setWidth(ALL_ROWS_FIELD_WIDTH);

		conditionWidget = new ConditionWidget(column, CONDITIONWIDTH,
				CONDITIONHEIGHT);
		conditionWidget.setEnabled(false);
		Log.debug("ConditionWidget" + conditionWidget);

		conditionsVerticalLayout.add(allRowsField, new VerticalLayoutData(100,
				-1, new Margins(0)));
		conditionsVerticalLayout.add(conditionWidget, new VerticalLayoutData(
				-1, -1, new Margins(0)));

		conditionsFieldSet.add(conditionsVerticalLayout);

		// Value
		FieldSet replaceValueFieldSet = new FieldSet();
		replaceValueFieldSet.setHeadingText("Replace Value");
		replaceValueFieldSet.setCollapsible(false);

		VerticalLayoutContainer replaceValueFieldSetLayout = new VerticalLayoutContainer();
		replaceValueFieldSet.add(replaceValueFieldSetLayout);

		if (column.getDataTypeName().compareTo(ColumnDataType.Date.toString()) == 0) {
			replaceValueDate = new DateField();
			replaceValueDate.setToolTip("Replace Value");
			replaceValueFieldSetLayout.add(new FieldLabel(replaceValueDate,
					"Replace Value"), new VerticalLayoutData(1, -1));
		} else {
			if (column.getDataTypeName().compareTo(
					ColumnDataType.Text.toString()) == 0) {
				replaceWidget = new ReplaceWidget(column, REPLACEWIDTH,
						REPLACEHEIGHT, eventBus);
				replaceValueFieldSetLayout.add(replaceWidget,
						new VerticalLayoutData(1, -1));
			} else {
				replaceValue = new TextField();
				replaceValue.setToolTip("Replace Value");
				replaceValue.setValue("");
				replaceValueFieldSetLayout.add(new FieldLabel(replaceValue,
						"Replace Value"), new VerticalLayoutData(1, -1));
			}
		}

		//
		btnApply = new TextButton("Apply");
		btnApply.setIcon(ExpressionResources.INSTANCE
				.columnReplaceByExpression());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setTitle("Apply replace by expression");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Apply");
				applyReplaceColumnByExpression();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ExpressionResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});
		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		// Add to basic layout
		basicLayout.add(properties, new VerticalLayoutData(-1, -1, new Margins(
				1)));
		basicLayout.add(conditionsFieldSet, new VerticalLayoutData(-1, -1,
				new Margins(1)));
		basicLayout.add(replaceValueFieldSet, new VerticalLayoutData(-1, -1,
				new Margins(1)));

		basicLayout.add(flowButton, new VerticalLayoutData(-1, 36, new Margins(
				5, 2, 5, 2)));
		add(basicLayout);

	}

	protected void callAllRowChange(ValueChangeEvent<HasValue<Boolean>> event) {
		ToggleGroup group = (ToggleGroup) event.getSource();
		Radio radio = (Radio) group.getValue();
		if (radio.getBoxLabel().compareTo(RADIO_LABEL_ALL_ROWS) == 0) {
			conditionWidget.setEnabled(false);
			allRows = true;
		} else {
			conditionWidget.setEnabled(true);
			allRows = false;
		}

	}

	protected void applyReplaceColumnByExpression() {
		C_Expression cConditionExpression;
		if (allRows) {
			cConditionExpression = new TD_Value(ColumnDataType.Boolean, "true");
		} else {
			
			try {
				cConditionExpression = conditionWidget.getExpression();
			} catch (OperatorTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
		
		}
		String value = null;
		if (column.getDataTypeName().compareTo(ColumnDataType.Date.toString()) == 0) {
			Date valueDate = replaceValueDate.getCurrentValue();
			if (valueDate == null) {
				UtilsGXT3.alert("Error replace value",
						"Select a valid date as replace value!");
				return;
			} else {
				try {
					value = sdf.format(valueDate);
				} catch (Throwable e) {
					UtilsGXT3.alert("Error replace value",
							"Select a valid date as replace value!");
					return;
				}
				parent.applyReplaceColumnByExpression(cConditionExpression,
						value);

			}

		} else {
			if (column.getDataTypeName().compareTo(
					ColumnDataType.Text.toString()) == 0) {
				C_Expression cReplaceExpression = null;
				try {
					cReplaceExpression = replaceWidget.getExpression();
					if (cReplaceExpression == null) {
						UtilsGXT3.alert("Attention",
								"Replace expression is not valid!");
						return;
					}
				} catch (ReplaceTypeMapException e) {
					UtilsGXT3.alert("Attention",
							e.getLocalizedMessage());
					return;
				}
				parent.applyReplaceColumnByExpression(cConditionExpression,
						cReplaceExpression);
			} else {
				value = replaceValue.getCurrentValue();
				if (checkValue(value)) {
					parent.applyReplaceColumnByExpression(cConditionExpression,
							value);
				} else {
					return;
				}
			}
		}

	}

	private boolean checkValue(String value) {
		try {
			boolean ok = false;
			ColumnDataType columnDataType = ColumnTypeMap
					.getColumnDataType(column.getDataTypeName());
			switch (columnDataType) {
			case Boolean:
				Boolean.valueOf(value);
				ok = true;
				break;
			case Date:
				ok = true;
				break;
			case Geometry:
				try {
					RegExp regExp = RegExp.compile(GEOMETRY_REGEXPR);
					MatchResult matcher = regExp.exec(value);
					boolean matchFound = matcher != null;
					if (matchFound) {
						ok = true;
					} else {
						ok = false;
					}

				} catch (Throwable e) {
					UtilsGXT3.alert("Error replace value",
							"Insert a valid replace value for Geometry type! ");
					e.printStackTrace();
					return false;
				}
				break;
			case Integer:
				try {
					Integer.parseInt(value);
				} catch(Throwable e){
					e.printStackTrace();
					UtilsGXT3.alert("Error replace value",
							"Insert a valid replace value for Integer type! ");
					return false;
				}
				ok=true;
				break;
			case Numeric:
				try {
					Double.parseDouble(value);
				} catch(Throwable e){
					e.printStackTrace();
					UtilsGXT3.alert("Error replace value",
							"Insert a valid replace value for Numeric type! ");
					return false;
				}
				ok=true;
				break;
			case Text:
				ok = true;
				break;
			default:
				break;
			}
			return ok;

		} catch (Throwable e) {
			e.printStackTrace();
			UtilsGXT3.alert("Error replace value",
					"Insert a valid replace value! "+e.getLocalizedMessage());
			
			return false;
		}
	}

	protected void close() {
		parent.close();
	}

}
