package org.gcube.portlets.user.td.expressionwidget.shared.replace;

import org.gcube.portlets.user.td.expressionwidget.shared.exception.ReplaceTypeMapException;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.functions.C_Cast;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_Concat;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_SubstringByIndex;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_SubstringByRegex;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_SubstringPosition;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_TextReplaceMatchingRegex;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_ColumnReferencePlaceholder;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_ColumnReference;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.TD_Value;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeMap;

import com.allen_sauer.gwt.log.client.Log;

/**
 * OperatorTypeMap creates a C_Expression usable client-side
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceTypeMap {
	private String readableExpression;

	public ReplaceTypeMap() {

	}
	
	public C_Expression map(ColumnData column, ReplaceType replaceType,
			String firstArg, String secondArg,boolean template) throws ReplaceTypeMapException {
		return map(column, replaceType,firstArg,  secondArg, template, null, null, null, null);
	}

	public C_Expression map(ColumnData column, ReplaceType replaceType,
			String firstArg, String secondArg, boolean template, C_Expression firstE,
			C_Expression secondE, String readableFirstE, String readableSecondE) throws ReplaceTypeMapException {
		Log.debug("ReplaceTypeMap Map");
		C_Expression exp = null;
		readableExpression = new String();
		if (template) {
			exp = mapPlaceHolder(column, replaceType, firstArg, secondArg,
					firstE, secondE, readableFirstE,readableSecondE);
		} else {
			exp = mapColumnReference(column, replaceType, firstArg,
					secondArg, firstE, secondE,readableFirstE,readableSecondE);
		}
		return exp;
	}

	public C_Expression mapPlaceHolder(ColumnData column,
			ReplaceType replaceType, String firstArg, String secondArg,
			C_Expression firstE, C_Expression secondE,String readableFirstE, String readableSecondE) throws ReplaceTypeMapException {
		Log.debug("OperatorTypeMap Map Place Holder");
		C_Expression exp = null;
		
		if(column==null){
			switch (replaceType) {
			case Null:
				exp = new TD_Value(ColumnDataType.Text, "");
				readableExpression = "Null()";
				break;
			case Value:
				checkTypeArgument(ColumnDataType.Text,firstArg);
				exp = new TD_Value(ColumnDataType.Text, firstArg);
				readableExpression = "Value(" + firstArg + ")";
				break;
			case Concat:
				exp = new C_Concat(firstE, secondE);
				readableExpression = "Concat(" + readableFirstE
						+ ", " + readableSecondE + ")";
				break;	
			default:
				throw new ReplaceTypeMapException("No valid column selected"); 
			}
			return exp;
		}
		
		
		Log.debug("Column Data Type Name:" + column.getDataTypeName());
		ColumnDataType dataType = ColumnTypeMap.getColumnDataType(column
				.getDataTypeName());
		Log.debug("Data Type:" + dataType);
		C_ColumnReferencePlaceholder placeH = new C_ColumnReferencePlaceholder(
				dataType, column.getColumnId());
		C_Expression placeHolder;
		String readablePlaceHolder; 
		if(dataType!=ColumnDataType.Text){
			placeHolder=new C_Cast(placeH,ColumnDataType.Text);
			readablePlaceHolder= "Cast("+column.getColumnId()+")";
		} else {
			placeHolder=placeH;
			readablePlaceHolder= column.getColumnId();

		}
		Log.debug("placeHolder:" + placeHolder);
		
		TD_Value fArg, sArg;
		C_Expression posFrom, posTo;

		switch (replaceType) {
		case Null:
			exp = new TD_Value(ColumnDataType.Text, "");
			readableExpression = "Null()";
			break;
		case Value:
			checkTypeArgument(ColumnDataType.Text,firstArg);
			exp = new TD_Value(ColumnDataType.Text, firstArg);
			readableExpression = "Value(" + firstArg + ")";
			break;
		case ColumnValue:
			exp = placeHolder;
			readableExpression = "ColumnValue(" + readablePlaceHolder + ")";
			break;
		case Concat:
			exp = new C_Concat(firstE, secondE);
			readableExpression = "Concat(" + readableFirstE
					+ ", " + readableSecondE + ")";
			break;
		case SubstringByRegex:
			checkTypeArgument(ColumnDataType.Text,firstArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			exp = new C_SubstringByRegex(placeHolder, fArg);
			readableExpression = "SubStringByRegex(" + readablePlaceHolder
					+ ", " + firstArg + ")";
			break;
		case SubstringByIndex:
			checkTypeArgument(ColumnDataType.Integer,firstArg);
			checkTypeArgument(ColumnDataType.Integer,secondArg);
			fArg = new TD_Value(ColumnDataType.Integer, firstArg);
			sArg = new TD_Value(ColumnDataType.Integer, secondArg);
			exp = new C_SubstringByIndex(placeHolder, fArg, sArg);
			readableExpression = "SubstringByIndex(" + readablePlaceHolder
					+ ", " + firstArg + ", " + secondArg + ")";
			break;
		case SubstringByCharSeq:
			checkTypeArgument(ColumnDataType.Text,firstArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			posFrom = new C_SubstringPosition(placeHolder, fArg);
			checkTypeArgument(ColumnDataType.Text,secondArg);
			sArg = new TD_Value(ColumnDataType.Text, secondArg);
			posTo = new C_SubstringPosition(placeHolder, fArg);
			exp = new C_SubstringByIndex(placeHolder, posFrom, posTo);
			readableExpression = "SubstringByCharSeq(" + readablePlaceHolder
					+ ", " + firstArg + ", " + secondArg + ")";
			break;
		case TextReplaceMatchingRegex:
			checkTypeArgument(ColumnDataType.Text,firstArg);
			checkTypeArgument(ColumnDataType.Text,secondArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			sArg = new TD_Value(ColumnDataType.Text, secondArg);
			exp = new C_TextReplaceMatchingRegex(placeHolder, fArg, sArg);
			readableExpression = "TextReplaceMatchingRegex(" + readablePlaceHolder
					+ ", " + firstArg + ", " + secondArg + ")";
			break;
		default:
			break;
		}
		return exp;
	}

	public C_Expression mapColumnReference(ColumnData column,
			ReplaceType replaceType, String firstArg, String secondArg,
			C_Expression firstE, C_Expression secondE, String readableFirstE, String readableSecondE) throws ReplaceTypeMapException {
		Log.debug("OperatorTypeMap Map Typed Column Reference");
		C_Expression exp = null;
		
		if(column==null){
			switch (replaceType) {
			case Null:
				exp = new TD_Value(ColumnDataType.Text, "");
				readableExpression = "Null()";
				break;
			case Value:
				checkTypeArgument(ColumnDataType.Text,firstArg);
				exp = new TD_Value(ColumnDataType.Text, firstArg);
				readableExpression = "Value(" + firstArg + ")";
				break;
			case Concat:
				exp = new C_Concat(firstE, secondE);
				readableExpression = "Concat(" + readableFirstE
						+ ", " + readableSecondE + ")";
				break;	
			default:
				throw new ReplaceTypeMapException("No valid column selected"); 
			}
			return exp;
		}
		
		
		Log.debug("Column Data Type Name:" + column.getDataTypeName());
		ColumnDataType dataType = ColumnTypeMap.getColumnDataType(column
				.getDataTypeName());
		Log.debug("Data Type:" + dataType);
		
		C_ColumnReference columnRef = new C_ColumnReference(
				column.getTrId(), dataType, column.getColumnId());
		
		C_Expression columnReference;
		String readableColumnReference; 
		if(dataType!=ColumnDataType.Text){
			columnReference=new C_Cast(columnRef,ColumnDataType.Text);
			readableColumnReference= "Cast("+column.getColumnId()+")";
		} else {
			columnReference=columnRef;
			readableColumnReference= column.getColumnId();

		}
		Log.debug("Typed Column Reference:" + columnReference);
		
		TD_Value fArg, sArg;
		C_Expression posFrom, posTo;

		switch (replaceType) {
		case Null:
			exp = new TD_Value(ColumnDataType.Text, "");
			readableExpression = "Null()";
			break;
		case Value:
			checkTypeArgument(ColumnDataType.Text, firstArg);
			exp = new TD_Value(ColumnDataType.Text, firstArg);
			readableExpression = "Value(" + firstArg + ")";
			break;
		case ColumnValue:
			exp = columnReference;
			readableExpression = "ColumnValue(" + readableColumnReference + ")";
			break;
		case Concat:
			exp = new C_Concat(firstE, secondE);
			readableExpression = "Concat(" + readableFirstE
					+ ", " + readableSecondE + ")";
			break;
		case SubstringByRegex:
			checkTypeArgument(ColumnDataType.Text, firstArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			exp = new C_SubstringByRegex(columnReference, fArg);
			readableExpression = "SubStringByRegex(" + readableColumnReference
					+ ", " + firstArg + ")";
			break;
		case SubstringByIndex:
			checkTypeArgument(ColumnDataType.Integer, firstArg);
			checkTypeArgument(ColumnDataType.Integer, secondArg);		
			fArg = new TD_Value(ColumnDataType.Integer, firstArg);
			sArg = new TD_Value(ColumnDataType.Integer, secondArg);
			exp = new C_SubstringByIndex(columnReference, fArg, sArg);
			readableExpression = "SubstringByIndex(" + readableColumnReference
					+ ", " + firstArg + ", " + secondArg + ")";
			break;
		case SubstringByCharSeq:
			checkTypeArgument(ColumnDataType.Text, firstArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			posFrom = new C_SubstringPosition(columnReference, fArg);
			checkTypeArgument(ColumnDataType.Text, secondArg);
			sArg = new TD_Value(ColumnDataType.Text, secondArg);
			posTo = new C_SubstringPosition(columnReference, fArg);
			exp = new C_SubstringByIndex(columnReference, posFrom, posTo);
			readableExpression = "SubstringByCharSeq("
					+ readableColumnReference + ", " + firstArg + ", "
					+ secondArg + ")";
			break;
		case TextReplaceMatchingRegex:
			checkTypeArgument(ColumnDataType.Text, firstArg);
			checkTypeArgument(ColumnDataType.Text, secondArg);
			fArg = new TD_Value(ColumnDataType.Text, firstArg);
			sArg = new TD_Value(ColumnDataType.Text, secondArg);
			exp = new C_TextReplaceMatchingRegex(columnReference, fArg, sArg);
			readableExpression = "TextReplaceMatchingRegex(" + readableColumnReference
					+ ", " + firstArg + ", " + secondArg + ")";
			break;
		default:
			break;
		}

		return exp;
	}

	public String getReadableExpression() {
		return readableExpression;
	}
	
	protected void checkTypeArgument(ColumnDataType columnDataType, String arg)
			throws ReplaceTypeMapException {
		if (columnDataType==ColumnDataType.Text) {
			if (arg == null) {
				arg = "";
			}
		} else {
			if (columnDataType==ColumnDataType.Boolean) {
				if(arg==null){
					throw new ReplaceTypeMapException(
							"Insert a valid Boolean(ex: true, false)!");
				}
			} else {
				if (columnDataType==ColumnDataType.Date) {

				} else {
					if (columnDataType==ColumnDataType.Geometry) {

					} else {
						if (columnDataType==ColumnDataType.Integer) {
							if(arg==null){
								throw new ReplaceTypeMapException(
										"Insert a valid Integer(ex: -1, 0, 1, 2)!");
							}
						
							try {
								Integer.parseInt(arg);
							} catch (NumberFormatException e) {
								throw new ReplaceTypeMapException(arg
										+ " is not valid Integer(ex: -1, 0, 1, 2)!");
							}
						} else {
							if (columnDataType==ColumnDataType.Numeric) {
								if(arg==null){
									throw new ReplaceTypeMapException(
											"Insert a valid Numeric(ex: -1.2, 0, 1, 2.4)!");
								}
								try {
									Float.parseFloat(arg);
								} catch (NumberFormatException e) {
									throw new ReplaceTypeMapException(arg
											+ " is not valid Numeric(ex: -1.2, 0, 1, 2.4)!");
								}
							} else {
								
							}
						}
					}
				}
			}

		}
	}
	
}
