package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.td.expressionwidget.client.properties.ColumnDataTypeProperties;
import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.client.store.ColumnDataTypeElement;
import org.gcube.portlets.user.td.expressionwidget.client.store.ColumnDataTypeStore;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ConditionTypeMapException;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_Not;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleScopeType;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.type.TDBaseColumnRuleType;
import org.gcube.portlets.user.td.monitorwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionWrapperEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.expression.C_ExpressionContainer;
import org.gcube.portlets.user.td.widgetcommonevent.client.expression.ExpressionWrapper;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnMockUp;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ColumnExpressionPanel extends FramedPanel {
	private static final String RULE_PLACE_HOLDER_ID = "RulePlaceHolderId";

	private enum ColumnExpressionPanelType {
		MultiColumnFilter, ColumnFilter, RowDeleteByExpression, Template, Rule;
	}

	private static final String WIDTH_MULTI = "642px";
	private static final String HEIGHT_MULTI = "290px";
	private static final String WIDTH = "648px";
	private static final String HEIGHT = "364px";
	private static final String RULE_HEIGHT = "388px";

	private ColumnExpressionPanelType type;
	private EventBus eventBus;

	private ColumnExpressionDialog parentTemplateDialog;
	private ColumnFilterDialog parentFilterDialog;
	private RowsDeleteByExpressionDialog parentRowsDeleteByExpressionDialog;
	private MultiColumnFilterTabPanel parentMultiColumnFilterTabPanel;

	private ColumnData column;
	private ArrayList<ColumnData> columns;

	private TextButton btnApply;
	private TextButton btnClose;

	private FieldSet conditionsField;
	private ConditionWidget conditionWidget;
	private ComboBox<ColumnData> comboCols;
	private RuleDialog parentRuleDialog;

	private TextField ruleName;
	private TextField ruleDescription;

	// private ComboBox<ColumnTypeCodeElement> comboColumnTypeCode;
	// private ComboBox<ColumnDataTypeElement> comboMeasureType;
	private ComboBox<ColumnDataTypeElement> comboAttributeType;

	// private FieldLabel comboColumnTypeCodeLabel;
	private FieldLabel comboAttributeTypeLabel;

	// private FieldLabel comboMeasureTypeLabel;

	/**
	 * 
	 * @param parentMultiColumnFilterTabPanel
	 * @param column
	 * @param eventBus
	 */
	public ColumnExpressionPanel(
			MultiColumnFilterTabPanel parentMultiColumnFilterTabPanel,
			ColumnData column, EventBus eventBus) {
		super();
		setWidth(WIDTH_MULTI);
		setHeight(HEIGHT_MULTI);
		type = ColumnExpressionPanelType.MultiColumnFilter;
		this.parentMultiColumnFilterTabPanel = parentMultiColumnFilterTabPanel;
		this.column = column;
		this.columns = null;
		this.eventBus = eventBus;
		Log.debug("Column:" + column);

		createOnMultiColumnFilter();
	}

	/**
	 * 
	 * @param parentFilterDialog
	 * @param column
	 * @param columns
	 * @param eventBus
	 */
	public ColumnExpressionPanel(ColumnFilterDialog parentFilterDialog,
			ColumnData column, ArrayList<ColumnData> columns, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(HEIGHT);
		type = ColumnExpressionPanelType.ColumnFilter;
		this.parentFilterDialog = parentFilterDialog;
		this.column = column;
		this.columns = columns;
		this.eventBus = eventBus;
		Log.debug("Column:" + column);
		createOnFilter();
	}

	/**
	 * 
	 * @param parentRowsDeleteByExpressionDialog
	 * @param column
	 * @param columns
	 * @param eventBus
	 */
	public ColumnExpressionPanel(
			RowsDeleteByExpressionDialog parentRowsDeleteByExpressionDialog,
			ColumnData column, ArrayList<ColumnData> columns, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(RULE_HEIGHT);
		type = ColumnExpressionPanelType.RowDeleteByExpression;
		this.parentRowsDeleteByExpressionDialog = parentRowsDeleteByExpressionDialog;
		this.column = column;
		this.columns = columns;
		this.eventBus = eventBus;
		Log.debug("Column:" + column);
		createOnRowsDeleteByExpression();
	}

	/**
	 * 
	 * @param parentColumnExpressionDialog
	 * @param column
	 * @param eventBus
	 */
	public ColumnExpressionPanel(
			ColumnExpressionDialog parentColumnExpressionDialog,
			ColumnData column, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(HEIGHT);
		type = ColumnExpressionPanelType.Template;
		this.parentTemplateDialog = parentColumnExpressionDialog;
		this.column = column;
		this.columns = null;
		this.eventBus = eventBus;
		Log.debug("Column:" + column);

		createOnTemplate();
	}

	/**
	 * 
	 * @param parentRuleDialog
	 * @param eventBus
	 */
	public ColumnExpressionPanel(RuleDialog parentRuleDialog, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(HEIGHT);
		type = ColumnExpressionPanelType.Rule;
		this.parentRuleDialog = parentRuleDialog;
		this.column = null;
		this.columns = null;
		this.eventBus = eventBus;
		Log.debug("Column:" + column);

		createOnRule();
	}

	protected void createOnRule() {
		forceLayoutOnResize = true;

		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		createColumnMockUp(propertiesLayout);

		conditionsField = new FieldSet();
		conditionsField.setHeadingText("Conditions");
		conditionsField.setCollapsible(false);

		conditionWidget = new ConditionWidget(column);
		Log.debug("ConditionWidget" + conditionWidget);
		conditionsField.add(conditionWidget);

		btnApply = new TextButton("Save");
		btnApply.setIcon(ExpressionResources.INSTANCE.rule());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setToolTip("Save rule");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Save");
				applySeleceted();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ExpressionResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setToolTip("Cancel rule");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		basicLayout.add(properties, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));
		add(basicLayout);
		
		conditionWidget.disable();

	}

	// TODO
	private void createColumnMockUp(VerticalLayoutContainer propertiesLayout) {
		ruleName = new TextField();
		ruleName.setToolTip("Rule Name");
		FieldLabel ruleNameLabel = new FieldLabel(ruleName, "Rule Name");

		ruleDescription = new TextField();
		ruleDescription.setToolTip("Rule Description");
		FieldLabel ruleDescriptionLabel = new FieldLabel(ruleDescription,
				"Rule Description");

		/*
		 * combo TypeCode ColumnTypeCodeProperties propsColumnTypeCode = GWT
		 * .create(ColumnTypeCodeProperties.class);
		 * ListStore<ColumnTypeCodeElement> storeComboTypeCode = new
		 * ListStore<ColumnTypeCodeElement>( propsColumnTypeCode.id());
		 * storeComboTypeCode.addAll(ColumnTypeCodeStore
		 * .getColumnTypeCodesForRule());
		 * 
		 * comboColumnTypeCode = new ComboBox<ColumnTypeCodeElement>(
		 * storeComboTypeCode, propsColumnTypeCode.label());
		 * Log.trace("ComboColumnTypeCode created");
		 * 
		 * addHandlersForComboColumnTypeCode(propsColumnTypeCode.label());
		 * 
		 * comboColumnTypeCode.setEmptyText("Select a column type...");
		 * comboColumnTypeCode.setWidth(191);
		 * comboColumnTypeCode.setTypeAhead(true);
		 * comboColumnTypeCode.setTriggerAction(TriggerAction.ALL);
		 * 
		 * comboColumnTypeCodeLabel = new FieldLabel(comboColumnTypeCode,
		 * "Column Type");
		 * 
		 * // comboMeasureType ColumnDataTypeProperties propsMeasureType = GWT
		 * .create(ColumnDataTypeProperties.class);
		 * ListStore<ColumnDataTypeElement> storeComboMeasureType = new
		 * ListStore<ColumnDataTypeElement>( propsMeasureType.id());
		 * storeComboMeasureType.addAll(ColumnDataTypeStore.getMeasureType());
		 * 
		 * comboMeasureType = new ComboBox<ColumnDataTypeElement>(
		 * storeComboMeasureType, propsMeasureType.label());
		 * Log.trace("ComboMeasureType created");
		 * 
		 * addHandlersForComboMeasureType(propsMeasureType.label());
		 * 
		 * comboMeasureType.setEmptyText("Select a measure type...");
		 * comboMeasureType.setWidth(191); comboMeasureType.setTypeAhead(true);
		 * comboMeasureType.setTriggerAction(TriggerAction.ALL);
		 * 
		 * comboMeasureTypeLabel = new FieldLabel(comboMeasureType,
		 * "Measure Type");
		 */
		// comboAttributeType
		ColumnDataTypeProperties propsAttributeType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboAttributeType = new ListStore<ColumnDataTypeElement>(
				propsAttributeType.id());
		storeComboAttributeType.addAll(ColumnDataTypeStore.getAttributeType());

		comboAttributeType = new ComboBox<ColumnDataTypeElement>(
				storeComboAttributeType, propsAttributeType.label());
		Log.trace("ComboAttributeType created");

		addHandlersForComboAttributeType(propsAttributeType.label());

		comboAttributeType.setEmptyText("Select a column type...");
		comboAttributeType.setWidth(191);
		comboAttributeType.setTypeAhead(true);
		comboAttributeType.setTriggerAction(TriggerAction.ALL);

		comboAttributeTypeLabel = new FieldLabel(comboAttributeType,
				"Data Type");

		propertiesLayout.add(ruleNameLabel, new VerticalLayoutData(1, -1,
				new Margins(0)));
		propertiesLayout.add(ruleDescriptionLabel, new VerticalLayoutData(1,
				-1, new Margins(0)));
		/*
		 * propertiesLayout.add(comboColumnTypeCodeLabel, new
		 * VerticalLayoutData( 1, -1, new Margins(0)));
		 * propertiesLayout.add(comboMeasureTypeLabel, new VerticalLayoutData(1,
		 * -1, new Margins(0)));
		 */
		propertiesLayout.add(comboAttributeTypeLabel, new VerticalLayoutData(1,
				-1, new Margins(0)));

		// comboMeasureTypeLabel.setVisible(false);
		// comboAttributeTypeLabel.setVisible(false);

	}

	/*
	 * protected void addHandlersForComboColumnTypeCode( final
	 * LabelProvider<ColumnTypeCodeElement> labelProvider) { comboColumnTypeCode
	 * .addSelectionHandler(new SelectionHandler<ColumnTypeCodeElement>() {
	 * public void onSelection( SelectionEvent<ColumnTypeCodeElement> event) {
	 * Info.display( "Column Type Selected", "You selected " +
	 * (event.getSelectedItem() == null ? "nothing" :
	 * labelProvider.getLabel(event .getSelectedItem()) + "!"));
	 * Log.debug("ComboColumnTypeCode selected: " + event.getSelectedItem());
	 * ColumnTypeCodeElement columnType = event .getSelectedItem();
	 * updateColumnType(columnType.getCode()); }
	 * 
	 * }); }
	 * 
	 * protected void addHandlersForComboMeasureType( final
	 * LabelProvider<ColumnDataTypeElement> labelProvider) { comboMeasureType
	 * .addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
	 * public void onSelection( SelectionEvent<ColumnDataTypeElement> event) {
	 * Info.display( "Measure Type Selected", "You selected " +
	 * (event.getSelectedItem() == null ? "nothing" :
	 * labelProvider.getLabel(event .getSelectedItem()) + "!"));
	 * Log.debug("ComboMeasureType selected: " + event.getSelectedItem());
	 * ColumnDataTypeElement measureType = event .getSelectedItem();
	 * updateMeasureType(measureType.getType()); }
	 * 
	 * }); }
	 */
	protected void addHandlersForComboAttributeType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboAttributeType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Attribute Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboAttributeType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement attributeType = event
								.getSelectedItem();
						updateAttributeType(attributeType.getType());
					}

				});
	}

	/*
	 * protected void updateColumnType(ColumnTypeCode type) {
	 * Log.debug("Update ColumnTypeCode " + type.toString()); switch (type) {
	 * case ATTRIBUTE: comboMeasureTypeLabel.setVisible(false);
	 * comboAttributeTypeLabel.setVisible(true); comboAttributeType.reset();
	 * break; case MEASURE: comboMeasureTypeLabel.setVisible(true);
	 * comboAttributeTypeLabel.setVisible(false); comboMeasureType.reset();
	 * break; default: comboMeasureTypeLabel.setVisible(false);
	 * comboAttributeTypeLabel.setVisible(false); break; }
	 * 
	 * updateCondition(); forceLayout(); }
	 */

	protected void updateCondition() {
		ColumnMockUp columnMockUp = retrieveColumnMockUp();
		if (columnMockUp != null) {
			column = new ColumnData();
			column.setId(columnMockUp.getId());
			column.setColumnId(columnMockUp.getColumnId());
			column.setLabel(columnMockUp.getLabel());
			column.setDataTypeName(columnMockUp.getColumnDataType().toString());
			// column.setTypeCode(columnMockUp.getColumnType().toString());
			conditionWidget.update(column);
			conditionWidget.enable();
		} else {
			conditionWidget.disable();
		}
		forceLayout();
	}

	/*
	 * protected ColumnMockUp retrieveColumnMockUp() { ColumnMockUp columnMockUp
	 * = null;
	 * 
	 * ColumnTypeCodeElement columnTypeCodeElement = comboColumnTypeCode
	 * .getCurrentValue(); if (columnTypeCodeElement != null) { ColumnTypeCode
	 * type = columnTypeCodeElement.getCode(); ColumnDataTypeElement
	 * columnDataTypeElement; switch (type) { case MEASURE:
	 * columnDataTypeElement = comboMeasureType.getCurrentValue(); if
	 * (columnDataTypeElement != null) { ColumnDataType dataType =
	 * columnDataTypeElement.getType(); if (dataType != null) { columnMockUp =
	 * new ColumnMockUp(null, RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type,
	 * dataType, ""); } else {
	 * 
	 * }
	 * 
	 * } else {
	 * 
	 * } break; case ATTRIBUTE: columnDataTypeElement =
	 * comboAttributeType.getCurrentValue(); if (columnDataTypeElement != null)
	 * { ColumnDataType dataType = columnDataTypeElement.getType(); if (dataType
	 * != null) { columnMockUp = new ColumnMockUp(null, RULE_PLACE_HOLDER_ID,
	 * RULE_PLACE_HOLDER_ID, type, dataType, "");
	 * 
	 * } else { } } else {
	 * 
	 * } break; case CODE: case CODEDESCRIPTION: case ANNOTATION: columnMockUp =
	 * new ColumnMockUp(null, RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type,
	 * ""); break;
	 * 
	 * case CODENAME: // LocaleTypeElement locale =
	 * comboLocaleType.getCurrentValue(); columnMockUp = new ColumnMockUp(null,
	 * RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type, "", "");
	 * 
	 * break; default: break; } } else {
	 * 
	 * } return columnMockUp;
	 * 
	 * }
	 * 
	 * 
	 * protected ColumnMockUp checkEnterData() { ColumnMockUp columnMockUp =
	 * null;
	 * 
	 * String ruleNameS = ruleName.getCurrentValue();
	 * 
	 * if (ruleNameS != null && !ruleNameS.isEmpty()) {
	 * 
	 * String ruleDescriptionS = ruleDescription.getCurrentValue();
	 * 
	 * if (ruleDescriptionS != null && !ruleDescriptionS.isEmpty()) {
	 * ColumnTypeCodeElement columnTypeCodeElement = comboColumnTypeCode
	 * .getCurrentValue(); if (columnTypeCodeElement != null) { ColumnTypeCode
	 * type = columnTypeCodeElement.getCode(); ColumnDataTypeElement
	 * columnDataTypeElement; switch (type) { case MEASURE:
	 * columnDataTypeElement = comboMeasureType .getCurrentValue(); if
	 * (columnDataTypeElement != null) { ColumnDataType dataType =
	 * columnDataTypeElement .getType(); if (dataType != null) { columnMockUp =
	 * new ColumnMockUp(null, RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type,
	 * dataType, ""); } else { UtilsGXT3.alert("Attention",
	 * "Column data type not selected!"); }
	 * 
	 * } else { UtilsGXT3.alert("Attention", "Column data type not selected!");
	 * } break; case ATTRIBUTE: columnDataTypeElement = comboAttributeType
	 * .getCurrentValue(); if (columnDataTypeElement != null) { ColumnDataType
	 * dataType = columnDataTypeElement .getType(); if (dataType != null) {
	 * columnMockUp = new ColumnMockUp(null, RULE_PLACE_HOLDER_ID,
	 * RULE_PLACE_HOLDER_ID, type, dataType, "");
	 * 
	 * } else { UtilsGXT3.alert("Attention", "Column data type not selected!");
	 * } } else { UtilsGXT3.alert("Attention",
	 * "Column data type not selected!"); } break; case CODE: case
	 * CODEDESCRIPTION: case ANNOTATION: columnMockUp = new ColumnMockUp(null,
	 * RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type, ""); break;
	 * 
	 * case CODENAME: // LocaleTypeElement locale = comboLocaleType //
	 * .getCurrentValue(); columnMockUp = new ColumnMockUp(null,
	 * RULE_PLACE_HOLDER_ID, RULE_PLACE_HOLDER_ID, type, "", "");
	 * 
	 * break;
	 * 
	 * default: UtilsGXT3.alert("Attention",
	 * "This column type is not supported now!"); break; } } else {
	 * UtilsGXT3.alert("Attention", "Select a column type!"); } } else {
	 * UtilsGXT3.alert("Attention", "Enter a valid description for the rule!");
	 * } } else { UtilsGXT3.alert("Attention",
	 * "Enter a valid name for the rule!"); } return columnMockUp;
	 * 
	 * }
	 */

	protected ColumnMockUp retrieveColumnMockUp() {
		ColumnMockUp columnMockUp = null;

		ColumnDataTypeElement columnDataTypeElement = comboAttributeType
				.getCurrentValue();
		if (columnDataTypeElement != null) {
			ColumnDataType dataType = columnDataTypeElement.getType();
			if (dataType != null) {
				columnMockUp = new ColumnMockUp(null, RULE_PLACE_HOLDER_ID,
						dataType, RULE_PLACE_HOLDER_ID);

			} else {

			}
		} else {

		}

		return columnMockUp;
	}

	protected ColumnMockUp checkEnterData() {
		ColumnMockUp columnMockUp = null;

		String ruleNameS = ruleName.getCurrentValue();

		if (ruleNameS != null && !ruleNameS.isEmpty()) {

			String ruleDescriptionS = ruleDescription.getCurrentValue();

			if (ruleDescriptionS != null && !ruleDescriptionS.isEmpty()) {
				ColumnDataTypeElement columnDataTypeElement = comboAttributeType
						.getCurrentValue();
				if (columnDataTypeElement != null) {
					ColumnDataType dataType = columnDataTypeElement.getType();
					if (dataType != null) {
						columnMockUp = new ColumnMockUp(null,
								RULE_PLACE_HOLDER_ID, dataType,
								RULE_PLACE_HOLDER_ID);

					} else {
						UtilsGXT3.alert("Attention",
								"Column data type not selected!");
					}
				} else {
					UtilsGXT3.alert("Attention",
							"Column data type not selected!");
				}

			} else {
				UtilsGXT3.alert("Attention",
						"Enter a valid description for the rule!");
			}
		} else {
			UtilsGXT3.alert("Attention", "Enter a valid name for the rule!");
		}
		return columnMockUp;

	}

	protected RuleDescriptionData retrieveRuleDescriptionData(C_Expression exp) {
		ColumnMockUp columnMockUp = checkEnterData();
		if (columnMockUp != null) {
			if (exp != null) {
				String ruleNameS = ruleName.getCurrentValue();
				String ruleDescriptionS = ruleDescription.getCurrentValue();
				TDBaseColumnRuleType tdBaseColumnRule = new TDBaseColumnRuleType(
						columnMockUp.getColumnDataType());

				RuleDescriptionData ruleDescriptionData = new RuleDescriptionData(
						0, ruleNameS, ruleDescriptionS, RuleScopeType.COLUMN,
						tdBaseColumnRule, exp);
				return ruleDescriptionData;
			} else {
				UtilsGXT3.alert("Attention", "Enter a valid condition!");
				return null;
			}
		} else {
			return null;
		}
	}

	/*
	 * protected void updateMeasureType(ColumnDataType type) {
	 * Log.debug("Update ColumnTypeCode " + type); updateCondition();
	 * 
	 * }
	 */

	protected void updateAttributeType(ColumnDataType type) {
		Log.debug("Update ColumnTypeCode " + type);
		updateCondition();

	}

	protected void createOnTemplate() {
		// Important: fixed rendering of widgets
		forceLayoutOnResize = true;

		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);
		// basicLayout.setScrollMode(ScrollMode.AUTO); Set In GXT 3.0.1

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		TextField columnType = new TextField();
		columnType.setToolTip("The type of column");
		columnType.setReadOnly(true);
		columnType.setValue(column.getTypeCode());
		propertiesLayout.add(new FieldLabel(columnType, "Column Type"),
				new VerticalLayoutData(1, -1));

		TextField dataType = new TextField();
		dataType.setToolTip("The data type");
		dataType.setReadOnly(true);
		dataType.setValue(column.getDataTypeName());
		propertiesLayout.add(new FieldLabel(dataType, "Data Type"),
				new VerticalLayoutData(1, -1));

		conditionsField = new FieldSet();
		conditionsField.setHeadingText("Conditions");
		conditionsField.setCollapsible(false);

		conditionWidget = new ConditionWidget(column);
		Log.debug("ConditionWidget" + conditionWidget);
		conditionsField.add(conditionWidget);

		btnApply = new TextButton("Apply");
		btnApply.setIcon(ExpressionResources.INSTANCE.apply());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setToolTip("Apply rule");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Apply");
				applySeleceted();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ExpressionResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setToolTip("Cancel rule");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		basicLayout.add(properties, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));
		add(basicLayout);

	}

	protected void createOnFilter() {
		forceLayoutOnResize = true;

		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		// Combo Column
		ColumnDataPropertiesCombo propsCols = GWT
				.create(ColumnDataPropertiesCombo.class);
		Log.debug("Props: " + propsCols);
		final ListStore<ColumnData> storeCols = new ListStore<ColumnData>(
				propsCols.id());
		Log.debug("Store Col: " + storeCols);
		storeCols.addAll(columns);

		Log.debug("StoreCol created");
		comboCols = new ComboBox<ColumnData>(storeCols, propsCols.label());

		Log.debug("Combo Threshold created");

		comboCols.addSelectionHandler(comboColsSelection());

		comboCols.setEmptyText("Select a column...");
		comboCols.setEditable(false);
		comboCols.setTriggerAction(TriggerAction.ALL);

		setSelectedColumn();

		propertiesLayout.add(new FieldLabel(comboCols, "Column"),
				new VerticalLayoutData(1, -1));

		//
		conditionsField = new FieldSet();
		conditionsField.setHeadingText("Conditions");
		conditionsField.setCollapsible(false);

		conditionWidget = new ConditionWidget(column);
		Log.debug("ConditionWidget" + conditionWidget);
		conditionsField.add(conditionWidget);

		btnApply = new TextButton("Apply");
		btnApply.setIcon(ExpressionResources.INSTANCE.applyFilter());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setToolTip("Apply Filter");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Apply");
				applySeleceted();

			}
		});
		if (column == null) {
			btnApply.disable();
		}

		btnClose = new TextButton("Close");
		btnClose.setIcon(ExpressionResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setToolTip("Cancel filter");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});
		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		basicLayout.add(properties, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));

		add(basicLayout);

	}

	protected void createOnRowsDeleteByExpression() {
		forceLayoutOnResize = true;

		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		// Combo Column
		ColumnDataPropertiesCombo propsCols = GWT
				.create(ColumnDataPropertiesCombo.class);
		Log.debug("Props: " + propsCols);
		final ListStore<ColumnData> storeCols = new ListStore<ColumnData>(
				propsCols.id());
		Log.debug("Store Col: " + storeCols);
		storeCols.addAll(columns);

		Log.debug("StoreCol created");
		comboCols = new ComboBox<ColumnData>(storeCols, propsCols.label());

		Log.debug("Combo Threshold created");

		comboCols.addSelectionHandler(comboColsSelection());

		comboCols.setEmptyText("Select a column...");
		comboCols.setEditable(false);
		comboCols.setTriggerAction(TriggerAction.ALL);

		setSelectedColumn();

		propertiesLayout.add(new FieldLabel(comboCols, "Column"),
				new VerticalLayoutData(1, -1));

		//
		conditionsField = new FieldSet();
		conditionsField.setHeadingText("Conditions");
		conditionsField.setCollapsible(false);

		conditionWidget = new ConditionWidget(column);
		Log.debug("ConditionWidget" + conditionWidget);
		conditionsField.add(conditionWidget);

		btnApply = new TextButton("Delete");
		btnApply.setIcon(ExpressionResources.INSTANCE
				.tableRowDeleteByExpression());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setToolTip("Delete rows");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Delete");
				applySeleceted();

			}
		});
		if (column == null) {
			btnApply.disable();
		}

		btnClose = new TextButton("Close");
		btnClose.setIcon(ExpressionResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setToolTip("Cancel filter");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});
		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		basicLayout.add(properties, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));

		add(basicLayout);

	}

	protected void setSelectedColumn() {
		if (column == null) {

		} else {
			ColumnTypeCode typeCode = ColumnTypeCode
					.getColumnTypeCodeFromId(column.getTypeCode());
			HTML errorMessage;
			if (typeCode == null) {
				errorMessage = new HTML(
						"This column has column data type null!");
				UtilsGXT3.alert("Error",
						"This column has column data type null!!");
				return;
			}

			switch (typeCode) {
			case ANNOTATION:
			case ATTRIBUTE:
			case CODE:
			case CODEDESCRIPTION:
			case CODENAME:
			case MEASURE:
				comboCols.setValue(column);
				break;
			case DIMENSION:
			case TIMEDIMENSION:
				errorMessage = new HTML(
						"This type of column is not supported for now!");
				add(errorMessage);
				UtilsGXT3.alert("Error",
						"This type of column is not supported for now!");
				break;
			default:
				errorMessage = new HTML(
						"This type of column is not supported for now!");
				add(errorMessage);
				UtilsGXT3.alert("Error",
						"This type of column is not supported for now!");
				break;

			}
		}
	}

	protected SelectionHandler<ColumnData> comboColsSelection() {
		SelectionHandler<ColumnData> selectionHandler = new SelectionHandler<ColumnData>() {

			@Override
			public void onSelection(SelectionEvent<ColumnData> event) {
				if (event.getSelectedItem() != null) {
					ColumnData col = event.getSelectedItem();
					Log.debug("Col selected:" + col.toString());
					column = col;
					btnApply.enable();
					conditionWidget.update(col);
				} else {
					column = null;
					btnApply.disable();
					conditionWidget.update(null);
				}
			}
		};

		return selectionHandler;
	}

	protected void createOnMultiColumnFilter() {
		// Important: fixed rendering of widgets
		forceLayoutOnResize = true;

		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);
		// basicLayout.setScrollMode(ScrollMode.AUTO); Set In GXT 3.0.1

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;
		TextField columnName;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		properties = new FieldSet();
		properties.setHeadingText("Properties");
		properties.setCollapsible(false);

		propertiesLayout = new VerticalLayoutContainer();
		properties.add(propertiesLayout);

		columnName = new TextField();
		columnName.setToolTip("Column");
		columnName.setReadOnly(true);
		columnName.setValue(column.getLabel());
		propertiesLayout.add(new FieldLabel(columnName, "Column"),
				new VerticalLayoutData(1, -1));

		conditionsField = new FieldSet();
		conditionsField.setHeadingText("Conditions");
		conditionsField.setCollapsible(false);

		conditionWidget = new ConditionWidget(column, "612px", "110px");
		Log.debug("ConditionWidget" + conditionWidget);
		conditionsField.add(conditionWidget);

		btnApply = new TextButton("Add");
		btnApply.setIcon(ExpressionResources.INSTANCE.applyFilter());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setToolTip("Add Filter");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Add Filter");
				applySeleceted();

			}
		});

		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		basicLayout.add(properties, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));
		add(basicLayout);

	}

	protected void applySeleceted() {
		Log.debug("Apply: " + column);

		C_Expression exp;
		C_ExpressionContainer condContainer = null;
		ExpressionWrapper exWrapper = null;
		ExpressionWrapperEvent expressionEvent = null;

		switch (type) {
		case Template:
			try {
				exp = conditionWidget.getExpression();
			} catch (ConditionTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
			parentTemplateDialog.setExpression(exp);
			condContainer = new C_ExpressionContainer();
			condContainer.setId(C_ExpressionContainer.Contains.C_Expression);
			condContainer.setExp(exp);
			condContainer.setReadableExpression(conditionWidget
					.getReadableExpression());
			exWrapper = new ExpressionWrapper(column.getTrId(), column,
					condContainer);
			expressionEvent = new ExpressionWrapperEvent(exWrapper);
			Log.debug(expressionEvent.toString());
			parentTemplateDialog.hide();
			eventBus.fireEvent(expressionEvent);
			break;
		case Rule:
			if(!conditionWidget.isEnabled()){
				UtilsGXT3.alert("Attention", "Fill all field!");
				return;
			}
			try {
				exp = conditionWidget.getExpression();
			} catch (ConditionTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
			RuleDescriptionData ruleDescriptionData = retrieveRuleDescriptionData(exp);
			if (ruleDescriptionData != null) {
				parentRuleDialog.addRule(ruleDescriptionData);
			}
			break;
		case ColumnFilter:
			try {
				exp = conditionWidget.getExpression();
			} catch (ConditionTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
			parentFilterDialog.applyFilter(column, exp);
			break;
		case RowDeleteByExpression:
			try {
				exp = conditionWidget.getExpression();
			} catch (ConditionTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
			C_Expression notExp = new C_Not(exp);
			parentRowsDeleteByExpressionDialog.deleteRowsByExpression(column,
					notExp);

			break;
		case MultiColumnFilter:
			try {
				exp = conditionWidget.getExpression();
			} catch (ConditionTypeMapException e) {
				Log.debug(e.getLocalizedMessage());
				UtilsGXT3.alert("Attention", e.getLocalizedMessage());
				return;
			}
			parentMultiColumnFilterTabPanel.applyFilter(column, exp);
			break;
		default:
			break;
		}

	}

	protected void close() {
		switch (type) {
		case Template:
			ExpressionWrapper exWrapper = new ExpressionWrapper();
			ExpressionWrapperEvent expressionEvent = new ExpressionWrapperEvent(
					exWrapper);
			Log.debug(expressionEvent.toString());
			parentTemplateDialog.hide();
			eventBus.fireEvent(expressionEvent);
			break;
		case Rule:
			parentRuleDialog.close();
		case ColumnFilter:
			parentFilterDialog.close();
			break;
		case RowDeleteByExpression:
			parentRowsDeleteByExpressionDialog.close();
			break;

		case MultiColumnFilter:
			break;
		default:
			break;
		}

	}

}
