package org.gcube.portlets.user.td.expressionwidget.client;


import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionWrapperEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.expression.ExpressionWrapper;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnMockUp;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnExpressionDialog extends Window {
	private static final String WIDTH = "660px";
	private static final String HEIGHT = "426px";
	private ColumnExpressionPanel columnExpressionPanel;
	private C_Expression exp = null;
	private ColumnData column = null;
	private TRId trId;
	private String columnId = null;
	private EventBus eventBus;
	
	/**
	 * 
	 * @param columnMockUp
	 * @param eventBus
	 */
	public ColumnExpressionDialog(
			ColumnMockUp columnMockUp,
			EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		column = new ColumnData();
		column.setColumnId(columnMockUp.getColumnId());
		column.setLabel(columnMockUp.getLabel());
		column.setDataTypeName(columnMockUp.getColumnDataType().toString());
		column.setTypeCode(columnMockUp.getColumnType().toString());
		create();

	}

	/**
	 * 
	 * @param trId
	 * @param columnId
	 * @param eventBus
	 */
	public ColumnExpressionDialog(TRId trId, String columnId,
			EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		this.trId = trId;
		this.columnId = columnId;
		load();

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("New Rule");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ExpressionResources.INSTANCE.rule());

	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			
			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}
	
	protected void close (){
		ExpressionWrapper exWrapper=new ExpressionWrapper();
		ExpressionWrapperEvent expressionEvent = new ExpressionWrapperEvent(exWrapper);
		Log.debug(expressionEvent.toString());
		hide();
		eventBus.fireEvent(expressionEvent);
	}
	

	protected void create() {
		if (column.getTypeCode()
				.compareTo(ColumnTypeCode.ANNOTATION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.ATTRIBUTE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODEDESCRIPTION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODENAME.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.MEASURE.toString()) == 0) {
			columnExpressionPanel = new ColumnExpressionPanel(this, column,
					eventBus);
			add(columnExpressionPanel);
		} else {
			HTML errorMessage = new HTML(
					"This type of column is not supported for now!");
			add(errorMessage);
			AlertMessageBox d = new AlertMessageBox("Error",
					"This type of column is not supported for now!");
			d.addHideHandler(new HideHandler() {
				public void onHide(HideEvent event) {
					hide();
				}
			});
			d.show();
		}
	}

	public C_Expression getExpression() {
		return exp;
	}

	protected void setExpression(C_Expression exp) {
		Log.debug("New Expression set:" + exp.toString());
		this.exp = exp;

	}

	protected void load() {
		TDGWTServiceAsync.INSTANCE.getColumn(columnId,trId,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								Log.error("Error retrieving column: "
										+ caught.getMessage());
								UtilsGXT3.alert("Error","Error retrieving column: "
										+ caught.getMessage());
							}
							}

					}

					public void onSuccess(ColumnData result) {
						Log.debug("Retrived column: " + result);
						column = result;
						create();
					}

				});

	}

}
