package org.gcube.portlets.user.td.expressionwidget.client;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class RuleDialog extends Window {
	private static final String WIDTH = "660px";
	private static final String HEIGHT = "460px";
	private ColumnExpressionPanel columnExpressionPanel;
	private EventBus eventBus;

	/**
	 * 
	 * @param columnMockUp
	 * @param eventBus
	 */
	public RuleDialog(EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		create();

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("New Rule");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ExpressionResources.INSTANCE.rule());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		// ExpressionWrapper exWrapper=new ExpressionWrapper();
		// ExpressionWrapperEvent expressionEvent = new
		// ExpressionWrapperEvent(exWrapper);
		// Log.debug(expressionEvent.toString());
		hide();
		// eventBus.fireEvent(expressionEvent);
	}

	protected void create() {
		columnExpressionPanel = new ColumnExpressionPanel(this, eventBus);
		add(columnExpressionPanel);

	}

	public void addRule(RuleDescriptionData ruleDescriptionData) {
		Log.debug("RuleDescriptionData: " + ruleDescriptionData);
		saveColumnRuleRule(ruleDescriptionData);

	}

	public void saveColumnRuleRule(RuleDescriptionData ruleDescriptionData) {

		ExpressionServiceAsync.INSTANCE.saveColumnRule(ruleDescriptionData,
				new AsyncCallback<String>() {

					@Override
					public void onSuccess(String ruleId) {
						Log.debug("Saved Rule: " + ruleId);
						close();
						UtilsGXT3.info("Save Rule", "The rule is saved!");
						

					}

					@Override
					public void onFailure(Throwable caught) {
						close();
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Error saving column rule: "
									+ caught.getLocalizedMessage());
							caught.printStackTrace();
							UtilsGXT3.alert("Error saving column rule",
									caught.getLocalizedMessage());

						}

					}
				});

	}

}
