package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.TabItemConfig;
import com.sencha.gxt.widget.core.client.TabPanel;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class MultiColumnFilterTabPanel extends TabPanel {
	protected String WIDTH = "648px";
	protected String HEIGHT = "290px";

	protected EventBus eventBus;
	protected MultiColumnFilterPanel multiColumnFilterPanel;
	protected ArrayList<ColumnData> columns;
	protected HashMap<ColumnData, C_Expression> cexpressionList;

	public MultiColumnFilterTabPanel(
			MultiColumnFilterPanel multiColumnFilterPanel, EventBus eventBus) {
		super();
		Log.debug("Create MultiColumnFilterTabPanel");
		setHeight(HEIGHT);
		setWidth(WIDTH);
		this.multiColumnFilterPanel = multiColumnFilterPanel;
		this.eventBus = eventBus;
		this.columns = multiColumnFilterPanel.columns;
		setBodyBorder(false);
		setBorders(false);
		setAnimScroll(true);
		setTabScroll(true);
		setCloseContextMenu(false);
		startTabs();
		
	}

	public void startTabs() {
		Log.debug("Start MultiColumnFilterTabPanel Tabs");
		addFilterColumnsPanel();
		setActiveWidget(getWidget(0));
		
	}

	protected void addFilterColumnsPanel() {
		cexpressionList = new HashMap<ColumnData, C_Expression>();

		TabItemConfig columnFilterItemConf;
		ColumnExpressionPanel columnExpressionPanel;
		for (ColumnData col : columns) {
			columnFilterItemConf = new TabItemConfig(col.getLabel(), false);

			if (col.getTypeCode().compareTo(
					ColumnTypeCode.ANNOTATION.toString()) == 0
					|| col.getTypeCode().compareTo(
							ColumnTypeCode.ATTRIBUTE.toString()) == 0
					|| col.getTypeCode().compareTo(
							ColumnTypeCode.CODE.toString()) == 0
					|| col.getTypeCode().compareTo(
							ColumnTypeCode.CODEDESCRIPTION.toString()) == 0
					|| col.getTypeCode().compareTo(
							ColumnTypeCode.CODENAME.toString()) == 0
					|| col.getTypeCode().compareTo(
							ColumnTypeCode.MEASURE.toString()) == 0) {
				columnExpressionPanel = new ColumnExpressionPanel(this, col,
						eventBus);
				add(columnExpressionPanel, columnFilterItemConf);

			} else {

			}

		}

	};

	protected void applyFilter(ColumnData column, C_Expression exp) {
		cexpressionList.put(column, exp);
	}

}
