/**
 * 
 */
package org.gcube.portlets.user.td.expressionwidget.client.rpc;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleScopeType;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */

public interface ExpressionServiceAsync {

	public static ExpressionServiceAsync INSTANCE = (ExpressionServiceAsync) GWT
			.create(ExpressionService.class);

	void startFilterColumn(FilterColumnSession filterColumnSession,
			AsyncCallback<String> callback);

	void startReplaceColumnByExpression(
			ReplaceColumnByExpressionSession replaceColumnByExpressionSession,
			AsyncCallback<String> callback);

	void startAddColumn(AddColumnSession addColumnSession,
			AsyncCallback<String> callback);

	void getRules(AsyncCallback<ArrayList<RuleDescriptionData>> callback);

	void getRules(RuleScopeType scope,
			AsyncCallback<ArrayList<RuleDescriptionData>> callback);

	void saveColumnRule(RuleDescriptionData ruleDescriptionData,
			AsyncCallback<String> callback);

}
