package org.gcube.portlets.user.td.expressionwidget.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.rules.RuleId;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionService;
import org.gcube.portlets.user.td.expressionwidget.server.service.rule.RuleColumnTypeMap;
import org.gcube.portlets.user.td.expressionwidget.server.service.rule.RuleScopeMap;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionParserException;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionServiceException;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleScopeType;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.TDGWTServiceImpl;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnMockUp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

//import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class ExpressionServiceImpl extends TDGWTServiceImpl implements
		ExpressionService {

	private static final long serialVersionUID = 4632292751581364137L;

	protected static Logger logger = LoggerFactory
			.getLogger(ExpressionServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm");

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startFilterColumn(FilterColumnSession filterColumnSession)
			throws TDGWTServiceException {

		try {
			logger.debug("ExpressionService submitColumnFilter");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: " + session);

			if (filterColumnSession == null) {
				logger.error("FilterColumnSession is null");
				new ExpressionServiceException("FilterColumnSession is null");
			}
			ExpressionSession.setColumnFilterSession(session,
					filterColumnSession);

			C_ExpressionParser parser = new C_ExpressionParser();
			Expression expression = null;
			try {
				expression = parser.parse(filterColumnSession.getCexpression());
			} catch (ExpressionParserException e) {
				logger.debug(e.getLocalizedMessage());
				throw new TDGWTServiceException(e.getLocalizedMessage());
			}
			logger.debug("Service Expression:" + expression);

			// TDGWTServiceImpl gwtService = new TDGWTServiceImpl();

			String taskId = startFilterColumn(filterColumnSession, expression,
					session);

			return taskId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */

	public String startAddColumn(AddColumnSession addColumnSession)
			throws TDGWTServiceException {

		try {
			logger.debug("AddColumn");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: " + session);

			if (addColumnSession == null) {
				logger.error("AddColumnSession is null");
				new ExpressionServiceException("AddColumnSession is null");
			}

			ColumnMockUp columnMockUp = addColumnSession.getColumnMockUp();

			Expression expression = null;
			if (columnMockUp.hasExpression()) {

				C_ExpressionParser parser = new C_ExpressionParser();

				try {
					expression = parser.parse(columnMockUp.getExpression());
				} catch (ExpressionParserException e) {
					logger.debug(e.getLocalizedMessage());
					throw new TDGWTServiceException(e.getLocalizedMessage());
				}
				logger.debug("Service Expression:" + expression);

			}

			// TDGWTServiceImpl gwtService = new TDGWTServiceImpl();

			String taskId = startAddColumn(addColumnSession, expression,
					session);

			return taskId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startReplaceColumnByExpression(
			ReplaceColumnByExpressionSession replaceColumnByExpressionSession)
			throws TDGWTServiceException {

		try {
			logger.debug("ExpressionService submitReplaceColumnByExpression");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: " + session);

			if (replaceColumnByExpressionSession == null) {
				logger.error("ReplaceColumnByExpressionSession is null");
				new ExpressionServiceException(
						"ReplaceColumnByExpressionSession is null");
			}
			ExpressionSession.setReplaceColumnByExpressionSession(session,
					replaceColumnByExpressionSession);

			C_ExpressionParser parser = new C_ExpressionParser();

			Expression conditionExpression = null;
			if (!replaceColumnByExpressionSession.isAllRows()) {
				try {
					conditionExpression = parser
							.parse(replaceColumnByExpressionSession
									.getcConditionExpression());
				} catch (ExpressionParserException e) {
					logger.debug(e.getLocalizedMessage());
					throw new TDGWTServiceException(e.getLocalizedMessage());
				}

				logger.debug("Service Condition Expression:"
						+ conditionExpression);
			}

			Expression replaceExpression = null;
			if (!replaceColumnByExpressionSession.isReplaceByValue()) {
				replaceExpression = parser
						.parse(replaceColumnByExpressionSession
								.getcReplaceExpression());
				logger.debug("Service Replace Expression:" + replaceExpression);
			}

			// TDGWTServiceImpl gwtService = new TDGWTServiceImpl();

			String taskId = startReplaceColumnByExpression(
					replaceColumnByExpressionSession, conditionExpression,
					replaceExpression, session);
			return taskId;

		} catch (TDGWTServiceException e) {
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(e.getLocalizedMessage());
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<RuleDescriptionData> getRules(RuleScopeType scope)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetRule()");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<RuleDescription> rules = service.getRulesByScope(RuleScopeMap
					.map(scope));

			ArrayList<RuleDescriptionData> rulesDes = new ArrayList<RuleDescriptionData>();

			C_ExpressionParser parser = new C_ExpressionParser();

			for (RuleDescription ruleDescription : rules) {
				Expression serviceExpression = ruleDescription.getRule();
				C_Expression cexp = parser.parse(serviceExpression);
				RuleDescriptionData ruleData = new RuleDescriptionData(
						ruleDescription.getId(), ruleDescription.getName(),
						ruleDescription.getDescription(),ruleDescription.getOwner(),
						RuleScopeMap.map(ruleDescription.getScope()), cexp);
				rulesDes.add(ruleData);

			}

			return rulesDes;

		} catch (TDGWTServiceException e) {
			logger.error(e.getLocalizedMessage());
			throw e;
		} catch (SecurityException e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();
			throw e;
		} catch (Throwable e) {
			logger.error("Error in getRule(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving the rules: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public ArrayList<RuleDescriptionData> getRules()
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("GetRule()");
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			List<RuleDescription> rules = service.getRules();

			ArrayList<RuleDescriptionData> rulesDes = new ArrayList<RuleDescriptionData>();

			C_ExpressionParser parser = new C_ExpressionParser();

			for (RuleDescription ruleDescription : rules) {
				Expression serviceExpression = ruleDescription.getRule();
				C_Expression cexp = parser.parse(serviceExpression);
				RuleDescriptionData ruleData = new RuleDescriptionData(
						ruleDescription.getId(), ruleDescription.getName(),
						ruleDescription.getDescription(),ruleDescription.getOwner(),
						RuleScopeMap.map(ruleDescription.getScope()), cexp);
				rulesDes.add(ruleData);

			}

			return rulesDes;

		} catch (TDGWTServiceException e) {
			logger.error(e.getLocalizedMessage());
			throw e;
		} catch (SecurityException e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();
			throw e;
		} catch (Throwable e) {
			logger.error("Error in getRule(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving the rules: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String saveColumnRule(
			RuleDescriptionData ruleDescriptionData)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			logger.debug("SaveColumnRule() :" + ruleDescriptionData);
			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();

			C_ExpressionParser parser = new C_ExpressionParser();

			Expression conditionExpression = null;
			try {
				conditionExpression = parser.parse(ruleDescriptionData
						.getExpression());
			} catch (ExpressionParserException e) {
				logger.debug(e.getLocalizedMessage());
				throw new TDGWTServiceException(e.getLocalizedMessage());
			}

			logger.debug("Service Condition Expression:" + conditionExpression);

			RuleColumnType ruleColumnType = RuleColumnTypeMap
					.map(ruleDescriptionData.getTdRuleColumnType());

			RuleId ruleId=service.saveColumnRule(ruleDescriptionData.getName(),
					ruleDescriptionData.getDescription(), conditionExpression,
					ruleColumnType);

			logger.debug("RuleId: "+ruleId);
			
			String ruleIdent=null;
			if(ruleId!=null){
				ruleIdent=String.valueOf(ruleId.getId());
			}

			return ruleIdent;

		} catch (TDGWTServiceException e) {
			logger.error(e.getLocalizedMessage());
			throw e;
		} catch (SecurityException e) {
			logger.error(e.getLocalizedMessage());
			e.printStackTrace();
			throw e;
		} catch (Throwable e) {
			logger.error("Error in getRule(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error retrieving the rules: "
					+ e.getLocalizedMessage());
		}

	}

	/**
	 * Retrieve and set Tabular Resource Type
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	/*
	 * protected TRId retrieveTabularResourceBasicData(TRId trId) throws
	 * TDGWTServiceException { try { HttpSession session =
	 * this.getThreadLocalRequest().getSession(); ASLSession aslSession =
	 * SessionUtil.getAslSession(session);
	 * 
	 * AuthorizationProvider.instance.set(new AuthorizationToken(
	 * aslSession.getUsername(), aslSession.getScope())); TabularDataService
	 * service = TabularDataServiceFactory.getService(); TabularResourceId
	 * tabularResourceId = new TabularResourceId( new Long(trId.getId()));
	 * 
	 * TabularResource tr = service.getTabularResource(tabularResourceId); Table
	 * table = service.getLastTable(tabularResourceId);
	 * 
	 * Table viewTable = null;
	 * 
	 * if (table.contains(DatasetViewTableMetadata.class)) {
	 * DatasetViewTableMetadata dwm = table
	 * .getMetadata(DatasetViewTableMetadata.class); try { viewTable =
	 * service.getTable(dwm .getTargetDatasetViewTableId()); } catch (Exception
	 * e) { logger.error("view table not found"); } }
	 * 
	 * TRId newTRId; if (viewTable == null) { newTRId = new TRId(
	 * String.valueOf(tr.getId().getValue()),
	 * TabularResourceTypeMap.map(tr.getTabularResourceType()),
	 * tr.getTableType(), String.valueOf(table.getId() .getValue()),
	 * table.getTableType().getName());
	 * 
	 * } else { newTRId = new TRId( String.valueOf(tr.getId().getValue()),
	 * TabularResourceTypeMap.map(tr.getTabularResourceType()),
	 * tr.getTableType(), String.valueOf(viewTable.getId() .getValue()),
	 * viewTable.getTableType() .getName(), String.valueOf(table.getId()
	 * .getValue()), true);
	 * 
	 * }
	 * 
	 * logger.debug("Retrieved TRId basic info:" + newTRId.toString()); return
	 * newTRId;
	 * 
	 * } catch (TDGWTServiceException e) { throw e; } catch (SecurityException
	 * e) { e.printStackTrace(); throw new TDGWTServiceException(
	 * "Security exception, you haven't rights!"); } catch (Throwable e) {
	 * e.printStackTrace(); throw new TDGWTServiceException("Error on Service: "
	 * + e.getLocalizedMessage()); } }
	 */

}