package org.gcube.portlets.user.td.expressionwidget.server.service.rule;

import org.gcube.data.analysis.tabulardata.commons.rules.types.BaseColumnRuleType;
import org.gcube.data.analysis.tabulardata.commons.rules.types.DimensionColumnRuleType;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.type.TDBaseColumnRuleType;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.type.TDDimensionColumnRuleType;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.type.TDRuleColumnType;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.DimensionReferenceData;

/**
 * 
 * @author giancarlo
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class RuleColumnTypeMap {
	
	public static RuleColumnType map(TDRuleColumnType tdRuleColumnType) {
		if (tdRuleColumnType == null) {
			return null;
		}

		if (tdRuleColumnType instanceof TDBaseColumnRuleType) {
			TDBaseColumnRuleType tdBaseColumnRuleType = (TDBaseColumnRuleType) tdRuleColumnType;
			BaseColumnRuleType baseColumnRuleType = new BaseColumnRuleType(
					ColumnDataTypeMap.map(tdBaseColumnRuleType
							.getColumnDataType()));
			return baseColumnRuleType;

		}

		if (tdRuleColumnType instanceof TDDimensionColumnRuleType) {
			TDDimensionColumnRuleType tdDimensionColumnRuleType = (TDDimensionColumnRuleType) tdRuleColumnType;

			TableId tableId = new TableId(
					Long.valueOf(tdDimensionColumnRuleType
							.getDimensionReferenceData().getTableId()));
			ColumnLocalId columnId = new ColumnLocalId(
					tdDimensionColumnRuleType.getDimensionReferenceData()
							.getColumnId());

			DimensionReference dimensionReference = new DimensionReference(
					tableId, columnId);

			DimensionColumnRuleType dimensionColumnRuleType = new DimensionColumnRuleType(
					dimensionReference);

			return dimensionColumnRuleType;

		}

		return null;

	}
	
	public static TDRuleColumnType map(RuleColumnType ruleColumnType) {
		if (ruleColumnType == null) {
			return null;
		}

		if (ruleColumnType instanceof BaseColumnRuleType) {
			BaseColumnRuleType baseColumnRuleType = (BaseColumnRuleType) ruleColumnType;
			TDBaseColumnRuleType tdBaseColumnRuleType = new TDBaseColumnRuleType(
					ColumnDataTypeMap.map(baseColumnRuleType
							.getInternalType()));
			return tdBaseColumnRuleType;

		}

		if (ruleColumnType instanceof DimensionColumnRuleType) {
			DimensionColumnRuleType dimensionColumnRuleType = (DimensionColumnRuleType) ruleColumnType;

			DimensionReference dimensionReference=(DimensionReference)dimensionColumnRuleType.getInternalType();
			
			DimensionReferenceData dimensionReferenceData = new DimensionReferenceData(
					String.valueOf(dimensionReference.getTableId().getValue()), dimensionReference.getColumnId().getValue());

			TDDimensionColumnRuleType tdDimensionColumnRuleType = new TDDimensionColumnRuleType(
					dimensionReferenceData);

			return tdDimensionColumnRuleType;

		}

		return null;

	}
	
	
}
