/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TRTasksManager;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSessionMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplyMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SessionUtil {
	
	protected static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

	public static ASLSession getAslSession(HttpSession httpSession) throws TDGWTSessionExpiredException {
		String username = (String) httpSession
				.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		ASLSession session;
		if (username == null) {
			logger.warn("no user found in session, using test one");
			throw new TDGWTSessionExpiredException("Session Expired!");
			/*
			username = Constants.DEFAULT_USER;
			String scope = Constants.DEFAULT_SCOPE;

			httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE, username);
			session = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);
			session.setScope(scope);*/
			
		} else {
			session = SessionManager.getInstance().getASLSession(
					httpSession.getId(), username);

		}

		logger.info("SessionUtil: aslSession " + session.getUsername() + " "
				+ session.getScope());

		return session;

	}

	public static void setTDOpenSession(HttpSession httpSession, TDOpenSession s) throws TDGWTSessionExpiredException {

		TDOpenSession session = (TDOpenSession) httpSession
				.getAttribute(SessionConstants.TDOPEN_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.TDOPEN_SESSION);
		httpSession.setAttribute(SessionConstants.TDOPEN_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());

	}

	public static void retrieveResources(HttpSession httpSession)
			throws Exception {

		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return;
	}

	public static void setTabularResources(HttpSession httpSession,
			List<TabularResource> trs) throws TDGWTSessionExpiredException {

		@SuppressWarnings("unchecked")
		List<TabularResource> tabularResources = (List<TabularResource>) httpSession
				.getAttribute(SessionConstants.TABULAR_RESOURCE_LIST);
		if (tabularResources != null)
			httpSession.removeAttribute(SessionConstants.TABULAR_RESOURCE_LIST);
		httpSession.setAttribute(SessionConstants.TABULAR_RESOURCE_LIST, trs);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TRId getTRId(HttpSession httpSession) {
		TRId id = (TRId) httpSession.getAttribute(SessionConstants.CURRENT_TR_ID);
		if (id == null) {
			logger.error("TR_ID was not acquired");
		}
		return id;
	}

	public static void setTRId(HttpSession httpSession, TRId trId) throws TDGWTSessionExpiredException {
		TRId id = (TRId) httpSession.getAttribute(SessionConstants.CURRENT_TR_ID);
		if (id != null)
			httpSession.removeAttribute(SessionConstants.CURRENT_TR_ID);
		httpSession.setAttribute(SessionConstants.CURRENT_TR_ID, trId);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(SessionConstants.CURRENT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CURRENT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setTabResource(HttpSession httpSession,
			TabResource tabResource) throws TDGWTSessionExpiredException {
		TabResource t = (TabResource) httpSession
				.getAttribute(SessionConstants.CURRENT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(SessionConstants.CURRENT_TABULAR_RESOURCE);
		httpSession.setAttribute(SessionConstants.CURRENT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static TabResource getSDMXImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(SessionConstants.SDMX_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("SDMX_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setSDMXImportTabResource(HttpSession httpSession,
			TabResource tabResource) throws TDGWTSessionExpiredException {
		TabResource t = (TabResource) httpSession
				.getAttribute(SessionConstants.SDMX_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(SessionConstants.SDMX_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(SessionConstants.SDMX_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	// //
	public static TabResource getCSVImportTabResource(HttpSession httpSession) {
		TabResource tabResource = (TabResource) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_TABULAR_RESOURCE);
		if (tabResource == null) {
			logger.error("CSV_IMPORT_TABULAR_RESOURCE was not acquired");
		}
		return tabResource;
	}

	public static void setCSVImportTabResource(HttpSession httpSession,
			TabResource tabResource) throws TDGWTSessionExpiredException {
		TabResource t = (TabResource) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_TABULAR_RESOURCE);
		if (t != null)
			httpSession.removeAttribute(SessionConstants.CSV_IMPORT_TABULAR_RESOURCE);
		httpSession.setAttribute(SessionConstants.CSV_IMPORT_TABULAR_RESOURCE, tabResource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	// //

	public static void setSDMXImportSession(HttpSession httpSession,
			SDMXImportSession s) throws TDGWTSessionExpiredException {

		SDMXImportSession session = (SDMXImportSession) httpSession
				.getAttribute(SessionConstants.SDMX_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.SDMX_IMPORT_SESSION);
		httpSession.setAttribute(SessionConstants.SDMX_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXImportSession getSDMXImportSession(HttpSession httpSession) {
		SDMXImportSession importSession = (SDMXImportSession) httpSession
				.getAttribute(SessionConstants.SDMX_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("SDMXImportSession was not acquired");
		}
		return importSession;
	}

	public static void setCSVImportSession(HttpSession httpSession,
			CSVImportSession s) throws TDGWTSessionExpiredException {

		CSVImportSession session = (CSVImportSession) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.CSV_IMPORT_SESSION);
		httpSession.setAttribute(SessionConstants.CSV_IMPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static CSVImportSession getCSVImportSession(HttpSession httpSession) {
		CSVImportSession importSession = (CSVImportSession) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_SESSION);
		if (importSession == null) {
			logger.error("CSVImportSession was not acquired");
		}
		return importSession;
	}

	public static void setCSVExportSession(HttpSession httpSession,
			CSVExportSession s) throws TDGWTSessionExpiredException {

		CSVExportSession session = (CSVExportSession) httpSession
				.getAttribute(SessionConstants.CSV_EXPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.CSV_EXPORT_SESSION);
		httpSession.setAttribute(SessionConstants.CSV_EXPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static CSVExportSession getCSVExportSession(HttpSession httpSession) {
		CSVExportSession exportSession = (CSVExportSession) httpSession
				.getAttribute(SessionConstants.CSV_EXPORT_SESSION);
		if (exportSession == null) {
			logger.error("CSVExportSession was not acquired");
		}
		return exportSession;
	}

	public static void setSDMXExportSession(HttpSession httpSession,
			SDMXExportSession s) throws TDGWTSessionExpiredException {

		SDMXExportSession session = (SDMXExportSession) httpSession
				.getAttribute(SessionConstants.SDMX_EXPORT_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.SDMX_EXPORT_SESSION);
		httpSession.setAttribute(SessionConstants.SDMX_EXPORT_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXExportSession getSDMXExportSession(HttpSession httpSession) {
		SDMXExportSession exportSession = (SDMXExportSession) httpSession
				.getAttribute(SessionConstants.SDMX_EXPORT_SESSION);
		if (exportSession == null) {
			logger.error("SDMXExportSession was not acquired");
		}
		return exportSession;
	}

	public static void setFileUploadSession(HttpSession httpSession,
			FileUploadSession s) throws TDGWTSessionExpiredException {

		FileUploadSession session = (FileUploadSession) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (session != null)
			httpSession.removeAttribute(SessionConstants.CSV_IMPORT_FILE_UPLOAD_SESSION);
		httpSession.setAttribute(SessionConstants.CSV_IMPORT_FILE_UPLOAD_SESSION, s);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static FileUploadSession getFileUploadSession(HttpSession httpSession) {
		FileUploadSession fileUploadSession = (FileUploadSession) httpSession
				.getAttribute(SessionConstants.CSV_IMPORT_FILE_UPLOAD_SESSION);
		if (fileUploadSession == null) {
			logger.error("FileUploadSession was not acquired");
		}
		return fileUploadSession;
	}

	public static ArrayList<Codelist> retrieveCodelists(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveCodelists");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllCodelists();
	}

	public static ArrayList<Dataset> retrieveDatasets(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveDatasets");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllDatasets();
	}

	public static ArrayList<Agencies> retrieveAgencies(HttpSession httpSession)
			throws Exception {
		logger.info("SessionUtil retriveAgencies");
		SDMXClient client = getSdmxClient(httpSession);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
		return client.getAllAgencies();
	}

	public static void setSDMXRegistrySource(HttpSession httpSession,
			SDMXRegistrySource sdmxRegistrySource) throws TDGWTSessionExpiredException {

		SDMXRegistrySource source = (SDMXRegistrySource) httpSession
				.getAttribute(SessionConstants.SDMX_REGISTRY_SOURCE);
		if (source != null)
			httpSession.removeAttribute(SessionConstants.SDMX_REGISTRY_SOURCE);
		httpSession.setAttribute(SessionConstants.SDMX_REGISTRY_SOURCE, sdmxRegistrySource);
		ASLSession aslSession = getAslSession(httpSession);
		ScopeProvider.instance.set(aslSession.getScope().toString());
	}

	public static SDMXRegistrySource getSDMXRegistrySource(
			HttpSession httpSession) {
		SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource) httpSession
				.getAttribute(SessionConstants.SDMX_REGISTRY_SOURCE);
		if (sdmxRegistrySource == null) {
			logger.error("SDMXRegistrySource was not acquired");
		}
		return sdmxRegistrySource;
	}

	public static SDMXClient getSdmxClient(HttpSession httpSession) {
		SDMXClient sdmxClient = (SDMXClient) httpSession
				.getAttribute(SessionConstants.SDMX_CLIENT_ATTRIBUTE);
		SDMXRegistrySource sdmxRegistrySource = (SDMXRegistrySource) httpSession
				.getAttribute(SessionConstants.SDMX_REGISTRY_SOURCE);
		if (sdmxRegistrySource == null) {
			logger.error("SDMXRegistrySource was not acquired");
		} else {
			String url = sdmxRegistrySource.getUrl();
			if (url == null || url.isEmpty()) {
				if (sdmxClient == null) {
					sdmxClient = new SDMXClient();
				} else {
					if (sdmxClient.type.compareTo(SDMXClient.TYPE.ANOTHER) == 0) {
						sdmxClient = new SDMXClient();
					}
				}
			} else {
				if (sdmxClient == null) {
					sdmxClient = new SDMXClient(url);
				} else {
					if (sdmxClient.type.compareTo(SDMXClient.TYPE.INTERNAL) == 0) {
						sdmxClient = new SDMXClient(url);
					} else {
						if (sdmxClient.url.compareTo(url) != 0) {
							sdmxClient = new SDMXClient(url);
						}
					}
				}
			}
			httpSession.setAttribute(SessionConstants.SDMX_CLIENT_ATTRIBUTE, sdmxClient);

		}

		return sdmxClient;
	}

	public static Task getSDMXImportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.SDMX_IMPORT_TASK);
		if (monitor == null) {
			logger.error("SDMX_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setSDMXImportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.SDMX_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.SDMX_IMPORT_TASK);
		httpSession.setAttribute(SessionConstants.SDMX_IMPORT_TASK, task);
	}

	public static Task getCSVImportFileTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CSV_IMPORT_TASK);
		if (monitor == null) {
			logger.error("CSV_IMPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setCSVImportFileTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CSV_IMPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.CSV_IMPORT_TASK);
		httpSession.setAttribute(SessionConstants.CSV_IMPORT_TASK, task);
	}

	public static Task getCSVExportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CSV_EXPORT_TASK);
		if (monitor == null) {
			logger.error("CSV_EXPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setCSVExportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CSV_EXPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.CSV_EXPORT_TASK);
		httpSession.setAttribute(SessionConstants.CSV_EXPORT_TASK, task);
	}

	public static void setCSVExportEnd(HttpSession httpSession, Boolean end) {
		Boolean fin = (Boolean) httpSession.getAttribute(SessionConstants.CSV_EXPORT_END);
		if (fin != null)
			httpSession.removeAttribute(SessionConstants.CSV_EXPORT_END);
		httpSession.setAttribute(SessionConstants.CSV_EXPORT_END, end);
	}

	public static Boolean getCSVExportEnd(HttpSession httpSession) {
		Boolean end = (Boolean) httpSession.getAttribute(SessionConstants.CSV_EXPORT_END);
		logger.debug("getCSVExportEnd(): " + end);
		if (end == null) {
			logger.error("CSV_EXPORT_END was not acquired");
			end = false;
		}
		return end;
	}

	public static Task getSDMXExportTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.SDMX_EXPORT_TASK);
		if (monitor == null) {
			logger.error("SDMX_EXPORT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setSDMXExportTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.SDMX_EXPORT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.SDMX_EXPORT_TASK);
		httpSession.setAttribute(SessionConstants.SDMX_EXPORT_TASK, task);
	}

	public static TRTasksManager getTRTasksManager(HttpSession httpSession) {
		TRTasksManager tasksManager = (TRTasksManager) httpSession
				.getAttribute(SessionConstants.TR_TASK_MANAGER);
		if (tasksManager != null) {
			return tasksManager;
		} else {
			tasksManager = new TRTasksManager();
			httpSession.setAttribute(SessionConstants.TR_TASK_MANAGER, tasksManager);
			return tasksManager;
		}
	}

	public static void setTRTasksManager(HttpSession httpSession,
			TRTasksManager trTasksManager) {
		TRTasksManager tm = (TRTasksManager) httpSession
				.getAttribute(SessionConstants.TR_TASK_MANAGER);
		if (tm != null) {
			httpSession.removeAttribute(SessionConstants.TR_TASK_MANAGER);
		}
		httpSession.setAttribute(SessionConstants.TR_TASK_MANAGER, trTasksManager);

	}

	//
	public static ChangeColumnTypeSession getChangeColumnTypeSession(
			HttpSession httpSession) {
		ChangeColumnTypeSession changeColumnTypeSession = (ChangeColumnTypeSession) httpSession
				.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_SESSION);
		if (changeColumnTypeSession != null) {
			return changeColumnTypeSession;
		} else {
			changeColumnTypeSession = new ChangeColumnTypeSession();
			httpSession.setAttribute(SessionConstants.CHANGE_COLUMN_TYPE_SESSION,
					changeColumnTypeSession);
			return changeColumnTypeSession;
		}
	}

	public static void setChangeColumnTypeSession(HttpSession httpSession,
			ChangeColumnTypeSession changeColumnTypeSession) {
		ChangeColumnTypeSession ct = (ChangeColumnTypeSession) httpSession
				.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_SESSION);
		if (ct != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_COLUMN_TYPE_SESSION);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_COLUMN_TYPE_SESSION,
				changeColumnTypeSession);

	}

	public static ChangeColumnTypeMonitor getChangeColumnTypeMonitor(
			HttpSession httpSession) {
		ChangeColumnTypeMonitor changeColumnTypeMonitor = (ChangeColumnTypeMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_MONITOR);
		if (changeColumnTypeMonitor != null) {
			return changeColumnTypeMonitor;
		} else {
			changeColumnTypeMonitor = new ChangeColumnTypeMonitor();
			httpSession.setAttribute(SessionConstants.CHANGE_COLUMN_TYPE_MONITOR,
					changeColumnTypeMonitor);
			return changeColumnTypeMonitor;
		}
	}

	public static void setChangeColumnTypeMonitor(HttpSession httpSession,
			ChangeColumnTypeMonitor changeColumnTypeMonitor) {
		ChangeColumnTypeMonitor cm = (ChangeColumnTypeMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_MONITOR);
		if (cm != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_COLUMN_TYPE_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_COLUMN_TYPE_MONITOR,
				changeColumnTypeMonitor);

	}

	public static Task getChangeColumnTypeTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_TASK);
		if (monitor == null) {
			logger.error("CHANGE_COLUMN_TYPE_TASK was not acquired");
		}
		return monitor;
	}

	public static void setChangeColumnTypeTask(HttpSession httpSession,
			Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CHANGE_COLUMN_TYPE_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.CHANGE_COLUMN_TYPE_TASK);
		httpSession.setAttribute(SessionConstants.CHANGE_COLUMN_TYPE_TASK, task);
	}

	// /

	public static LabelColumnSession getLabelColumnSession(
			HttpSession httpSession) {
		LabelColumnSession labelColumnSession = (LabelColumnSession) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_SESSION);
		if (labelColumnSession != null) {
			return labelColumnSession;
		} else {
			labelColumnSession = new LabelColumnSession();
			httpSession.setAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_SESSION,
					labelColumnSession);
			return labelColumnSession;
		}
	}

	public static void setLabelColumnSession(HttpSession httpSession,
			LabelColumnSession labelColumnSession) {
		LabelColumnSession lc = (LabelColumnSession) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_SESSION);
		if (lc != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_SESSION);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_SESSION,
				labelColumnSession);

	}

	public static LabelColumnMonitor getLabelColumnMonitor(
			HttpSession httpSession) {
		LabelColumnMonitor labelColumnMonitor = (LabelColumnMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_MONITOR);
		if (labelColumnMonitor != null) {
			return labelColumnMonitor;
		} else {
			labelColumnMonitor = new LabelColumnMonitor();
			httpSession.setAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_MONITOR,
					labelColumnMonitor);
			return labelColumnMonitor;
		}
	}

	public static void setLabelColumnMonitor(HttpSession httpSession,
			LabelColumnMonitor labelColumnMonitor) {
		LabelColumnMonitor lc = (LabelColumnMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_MONITOR);
		if (lc != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_MONITOR,
				labelColumnMonitor);

	}

	public static Task getLabelColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_TASK);
		if (monitor == null) {
			logger.error("CHANGE_THE_COLUMN_LABEL_TASK was not acquired");
		}
		return monitor;
	}

	public static void setLabelColumnTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession
				.getAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_TASK);
		httpSession.setAttribute(SessionConstants.CHANGE_THE_COLUMN_LABEL_TASK, task);
	}

	//

	public static DeleteColumnSession getDeleteColumnSession(
			HttpSession httpSession) {
		DeleteColumnSession deleteColumnSession = (DeleteColumnSession) httpSession
				.getAttribute(SessionConstants.DELETE_COLUMN_SESSION);
		if (deleteColumnSession != null) {
			return deleteColumnSession;
		} else {
			deleteColumnSession = new DeleteColumnSession();
			httpSession
					.setAttribute(SessionConstants.DELETE_COLUMN_SESSION, deleteColumnSession);
			return deleteColumnSession;
		}
	}

	public static void setDeleteColumnSession(HttpSession httpSession,
			DeleteColumnSession deleteColumnSession) {
		DeleteColumnSession dc = (DeleteColumnSession) httpSession
				.getAttribute(SessionConstants.DELETE_COLUMN_SESSION);
		if (dc != null) {
			httpSession.removeAttribute(SessionConstants.DELETE_COLUMN_SESSION);
		}
		httpSession.setAttribute(SessionConstants.DELETE_COLUMN_SESSION, deleteColumnSession);

	}

	public static DeleteColumnMonitor getDeleteColumnMonitor(
			HttpSession httpSession) {
		DeleteColumnMonitor deleteColumnMonitor = (DeleteColumnMonitor) httpSession
				.getAttribute(SessionConstants.DELETE_COLUMN_MONITOR);
		if (deleteColumnMonitor != null) {
			return deleteColumnMonitor;
		} else {
			deleteColumnMonitor = new DeleteColumnMonitor();
			httpSession
					.setAttribute(SessionConstants.DELETE_COLUMN_MONITOR, deleteColumnMonitor);
			return deleteColumnMonitor;
		}
	}

	public static void setDeleteColumnMonitor(HttpSession httpSession,
			DeleteColumnMonitor deleteColumnMonitor) {
		DeleteColumnMonitor cm = (DeleteColumnMonitor) httpSession
				.getAttribute(SessionConstants.DELETE_COLUMN_MONITOR);
		if (cm != null) {
			httpSession.removeAttribute(SessionConstants.DELETE_COLUMN_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.DELETE_COLUMN_MONITOR, deleteColumnMonitor);

	}

	public static Task getDeleteColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DELETE_COLUMN_TASK);
		if (monitor == null) {
			logger.error("DELETE_COLUMN_TASK was not acquired");
		}
		return monitor;
	}

	public static void setDeleteColumnTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DELETE_COLUMN_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.DELETE_COLUMN_TASK);
		httpSession.setAttribute(SessionConstants.DELETE_COLUMN_TASK, task);
	}
	
	//
	public static TaskResubmitSession getTaskResubmitSession(
			HttpSession httpSession) {
		TaskResubmitSession taskResubmitSession = (TaskResubmitSession) httpSession
				.getAttribute(SessionConstants.TASK_RESUBMIT_SESSION);
		if (taskResubmitSession != null) {
			return taskResubmitSession;
		} else {
			taskResubmitSession = new TaskResubmitSession();
			httpSession.setAttribute(SessionConstants.TASK_RESUBMIT_SESSION,
					taskResubmitSession);
			return taskResubmitSession;
		}
	}

	public static void setTaskResubmitSession(HttpSession httpSession,
			TaskResubmitSession taskResubmitSession) {
		TaskResubmitSession tr = (TaskResubmitSession) httpSession
				.getAttribute(SessionConstants.TASK_RESUBMIT_SESSION);
		if (tr != null) {
			httpSession.removeAttribute(SessionConstants.TASK_RESUBMIT_SESSION);
		}
		httpSession.setAttribute(SessionConstants.TASK_RESUBMIT_SESSION, taskResubmitSession);

	}

	public static TaskResubmitMonitor getTaskResubmitMonitor(
			HttpSession httpSession) {
		TaskResubmitMonitor taskResubmitMonitor = (TaskResubmitMonitor) httpSession
				.getAttribute(SessionConstants.TASK_RESUBMIT_MONITOR);
		if (taskResubmitMonitor != null) {
			return taskResubmitMonitor;
		} else {
			taskResubmitMonitor = new TaskResubmitMonitor();
			httpSession.setAttribute(SessionConstants.TASK_RESUBMIT_MONITOR,
					taskResubmitMonitor);
			return taskResubmitMonitor;
		}
	}

	public static void setTaskResubmitMonitor(HttpSession httpSession,
			TaskResubmitMonitor TaskResubmitMonitor) {
		TaskResubmitMonitor trm = (TaskResubmitMonitor) httpSession
				.getAttribute(SessionConstants.TASK_RESUBMIT_MONITOR);
		if (trm != null) {
			httpSession.removeAttribute(SessionConstants.TASK_RESUBMIT_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.TASK_RESUBMIT_MONITOR, TaskResubmitMonitor);

	}

	public static Task getTaskResubmitTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TASK_RESUBMIT_TASK);
		if (monitor == null) {
			logger.error("TASK_RESUBMIT_TASK was not acquired");
		}
		return monitor;
	}

	public static void setTaskResubmitTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TASK_RESUBMIT_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.TASK_RESUBMIT_TASK);
		httpSession.setAttribute(SessionConstants.TASK_RESUBMIT_TASK, task);
	}

	//
	public static TaskResumeSession getTaskResumeSession(
			HttpSession httpSession) {
		TaskResumeSession taskResumeSession = (TaskResumeSession) httpSession
				.getAttribute(SessionConstants.TASK_RESUME_SESSION);
		if (taskResumeSession != null) {
			return taskResumeSession;
		} else {
			taskResumeSession = new TaskResumeSession();
			httpSession.setAttribute(SessionConstants.TASK_RESUME_SESSION,
					taskResumeSession);
			return taskResumeSession;
		}
	}

	public static void setTaskResumeSession(HttpSession httpSession,
			TaskResumeSession taskResumeSession) {
		TaskResumeSession tr = (TaskResumeSession) httpSession
				.getAttribute(SessionConstants.TASK_RESUME_SESSION);
		if (tr != null) {
			httpSession.removeAttribute(SessionConstants.TASK_RESUME_SESSION);
		}
		httpSession.setAttribute(SessionConstants.TASK_RESUME_SESSION, taskResumeSession);

	}

	public static TaskResumeMonitor getTaskResumeMonitor(
			HttpSession httpSession) {
		TaskResumeMonitor taskResumeMonitor = (TaskResumeMonitor) httpSession
				.getAttribute(SessionConstants.TASK_RESUME_MONITOR);
		if (taskResumeMonitor != null) {
			return taskResumeMonitor;
		} else {
			taskResumeMonitor = new TaskResumeMonitor();
			httpSession.setAttribute(SessionConstants.TASK_RESUME_MONITOR,
					taskResumeMonitor);
			return taskResumeMonitor;
		}
	}

	public static void setTaskResumeMonitor(HttpSession httpSession,
			TaskResumeMonitor taskResumeMonitor) {
		TaskResumeMonitor trm = (TaskResumeMonitor) httpSession
				.getAttribute(SessionConstants.TASK_RESUME_MONITOR);
		if (trm != null) {
			httpSession.removeAttribute(SessionConstants.TASK_RESUME_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.TASK_RESUME_MONITOR, taskResumeMonitor);

	}

	public static Task getTaskResumeTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TASK_RESUME_TASK);
		if (monitor == null) {
			logger.error("TASK_RESUME_TASK was not acquired");
		}
		return monitor;
	}

	public static void setTaskResumeTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TASK_RESUME_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.TASK_RESUME_TASK);
		httpSession.setAttribute(SessionConstants.TASK_RESUME_TASK, task);
	}

	
	
	
	//
	public static EditRowSession getEditRowSession(
			HttpSession httpSession) {
		EditRowSession editRowSession = (EditRowSession) httpSession
				.getAttribute(SessionConstants.EDIT_ROW_SESSION);
		if (editRowSession != null) {
			return editRowSession;
		} else {
			editRowSession = new EditRowSession();
			httpSession.setAttribute(SessionConstants.EDIT_ROW_SESSION,
					editRowSession);
			return editRowSession;
		}
	}

	public static void setEditRowSession(HttpSession httpSession,
			EditRowSession editRowSession) {
		EditRowSession er = (EditRowSession) httpSession
				.getAttribute(SessionConstants.EDIT_ROW_SESSION);
		if (er != null) {
			httpSession.removeAttribute(SessionConstants.EDIT_ROW_SESSION);
		}
		httpSession.setAttribute(SessionConstants.EDIT_ROW_SESSION, editRowSession);

	}

	public static EditRowMonitor getEditRowMonitor(
			HttpSession httpSession) {
		EditRowMonitor editRowMonitor = (EditRowMonitor) httpSession
				.getAttribute(SessionConstants.EDIT_ROW_MONITOR);
		if (editRowMonitor != null) {
			return editRowMonitor;
		} else {
			editRowMonitor = new EditRowMonitor();
			httpSession.setAttribute(SessionConstants.EDIT_ROW_MONITOR,
					editRowMonitor);
			return editRowMonitor;
		}
	}

	public static void setEditRowMonitor(HttpSession httpSession,
			EditRowMonitor editRowMonitor) {
		EditRowMonitor er = (EditRowMonitor) httpSession
				.getAttribute(SessionConstants.EDIT_ROW_MONITOR);
		if (er != null) {
			httpSession.removeAttribute(SessionConstants.EDIT_ROW_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.EDIT_ROW_MONITOR, editRowMonitor);

	}

	public static Task getEditRowTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.EDIT_ROW_TASK);
		if (monitor == null) {
			logger.error("EDIT_ROW_TASK was not acquired");
		}
		return monitor;
	}

	public static void setEditRowTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.EDIT_ROW_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.EDIT_ROW_TASK);
		httpSession.setAttribute(SessionConstants.EDIT_ROW_TASK, task);
	}

	
	
	//

	public static ReplaceColumnSession getReplaceColumnSession(
			HttpSession httpSession) {
		ReplaceColumnSession replaceColumnSession = (ReplaceColumnSession) httpSession
				.getAttribute(SessionConstants.REPLACE_COLUMN_SESSION);
		if (replaceColumnSession != null) {
			return replaceColumnSession;
		} else {
			replaceColumnSession = new ReplaceColumnSession();
			httpSession.setAttribute(SessionConstants.REPLACE_COLUMN_SESSION,
					replaceColumnSession);
			return replaceColumnSession;
		}
	}

	public static void setReplaceColumnSession(HttpSession httpSession,
			ReplaceColumnSession replaceColumnSession) {
		ReplaceColumnSession rc = (ReplaceColumnSession) httpSession
				.getAttribute(SessionConstants.REPLACE_COLUMN_SESSION);
		if (rc != null) {
			httpSession.removeAttribute(SessionConstants.REPLACE_COLUMN_SESSION);
		}
		httpSession.setAttribute(SessionConstants.REPLACE_COLUMN_SESSION, replaceColumnSession);

	}

	public static ReplaceColumnMonitor getReplaceColumnMonitor(
			HttpSession httpSession) {
		ReplaceColumnMonitor replaceColumnMonitor = (ReplaceColumnMonitor) httpSession
				.getAttribute(SessionConstants.REPLACE_COLUMN_MONITOR);
		if (replaceColumnMonitor != null) {
			return replaceColumnMonitor;
		} else {
			replaceColumnMonitor = new ReplaceColumnMonitor();
			httpSession.setAttribute(SessionConstants.REPLACE_COLUMN_MONITOR,
					replaceColumnMonitor);
			return replaceColumnMonitor;
		}
	}

	public static void setReplaceColumnMonitor(HttpSession httpSession,
			ReplaceColumnMonitor replaceColumnMonitor) {
		ReplaceColumnMonitor rc = (ReplaceColumnMonitor) httpSession
				.getAttribute(SessionConstants.REPLACE_COLUMN_MONITOR);
		if (rc != null) {
			httpSession.removeAttribute(SessionConstants.REPLACE_COLUMN_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.REPLACE_COLUMN_MONITOR, replaceColumnMonitor);

	}

	public static Task getReplaceColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.REPLACE_COLUMN_TASK);
		if (monitor == null) {
			logger.error("REPLACE_COLUMN_TASK was not acquired");
		}
		return monitor;
	}

	public static void setReplaceColumnTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.REPLACE_COLUMN_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.REPLACE_COLUMN_TASK);
		httpSession.setAttribute(SessionConstants.REPLACE_COLUMN_TASK, task);
	}

	
	//
	public static ReplaceBatchColumnSession getReplaceBatchColumnSession(
			HttpSession httpSession) {
		ReplaceBatchColumnSession replaceBatchColumnSession = (ReplaceBatchColumnSession) httpSession
				.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_SESSION);
		if (replaceBatchColumnSession != null) {
			return replaceBatchColumnSession;
		} else {
			replaceBatchColumnSession = new ReplaceBatchColumnSession();
			httpSession.setAttribute(SessionConstants.REPLACE_BATCH_COLUMN_SESSION,
					replaceBatchColumnSession);
			return replaceBatchColumnSession;
		}
	}

	public static void setReplaceBatchColumnSession(HttpSession httpSession,
			ReplaceBatchColumnSession replaceBatchColumnSession) {
		ReplaceBatchColumnSession rbc = (ReplaceBatchColumnSession) httpSession
				.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_SESSION);
		if (rbc != null) {
			httpSession.removeAttribute(SessionConstants.REPLACE_BATCH_COLUMN_SESSION);
		}
		httpSession.setAttribute(SessionConstants.REPLACE_BATCH_COLUMN_SESSION, replaceBatchColumnSession);

	}

	public static ReplaceBatchColumnMonitor getReplaceBatchColumnMonitor(
			HttpSession httpSession) {
		ReplaceBatchColumnMonitor replaceBatchColumnMonitor = (ReplaceBatchColumnMonitor) httpSession
				.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_MONITOR);
		if (replaceBatchColumnMonitor != null) {
			return replaceBatchColumnMonitor;
		} else {
			replaceBatchColumnMonitor = new ReplaceBatchColumnMonitor();
			httpSession.setAttribute(SessionConstants.REPLACE_BATCH_COLUMN_MONITOR,
					replaceBatchColumnMonitor);
			return replaceBatchColumnMonitor;
		}
	}

	public static void setReplaceBatchColumnMonitor(HttpSession httpSession,
			ReplaceBatchColumnMonitor replaceBatchColumnMonitor) {
		ReplaceBatchColumnMonitor rbc = (ReplaceBatchColumnMonitor) httpSession
				.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_MONITOR);
		if (rbc != null) {
			httpSession.removeAttribute(SessionConstants.REPLACE_BATCH_COLUMN_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.REPLACE_BATCH_COLUMN_MONITOR, replaceBatchColumnMonitor);

	}

	public static Task getReplaceBatchColumnTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_TASK);
		if (monitor == null) {
			logger.error("REPLACE_BATCH_COLUMN_TASK was not acquired");
		}
		return monitor;
	}

	public static void setReplaceBatchColumnTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.REPLACE_BATCH_COLUMN_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.REPLACE_BATCH_COLUMN_TASK);
		httpSession.setAttribute(SessionConstants.REPLACE_BATCH_COLUMN_TASK, task);
	}

	
	//

	public static ChangeTableTypeSession getChangeTableTypeSession(
			HttpSession httpSession) {
		ChangeTableTypeSession changeTableTypeSession = (ChangeTableTypeSession) httpSession
				.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_SESSION);
		if (changeTableTypeSession != null) {
			return changeTableTypeSession;
		} else {
			changeTableTypeSession = new ChangeTableTypeSession();
			httpSession.setAttribute(SessionConstants.CHANGE_TABLE_TYPE_SESSION,
					changeTableTypeSession);
			return changeTableTypeSession;
		}
	}

	public static void setChangeTableTypeSession(HttpSession httpSession,
			ChangeTableTypeSession changeTableTypeSession) {
		ChangeTableTypeSession ctts = (ChangeTableTypeSession) httpSession
				.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_SESSION);
		if (ctts != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_TABLE_TYPE_SESSION);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_TABLE_TYPE_SESSION,
				changeTableTypeSession);

	}

	public static ChangeTableTypeMonitor getChangeTableTypeMonitor(
			HttpSession httpSession) {
		ChangeTableTypeMonitor changeTableTypeMonitor = (ChangeTableTypeMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_MONITOR);
		if (changeTableTypeMonitor != null) {
			return changeTableTypeMonitor;
		} else {
			changeTableTypeMonitor = new ChangeTableTypeMonitor();
			httpSession.setAttribute(SessionConstants.CHANGE_TABLE_TYPE_MONITOR,
					changeTableTypeMonitor);
			return changeTableTypeMonitor;
		}
	}

	public static void setChangeTableTypeMonitor(HttpSession httpSession,
			ChangeTableTypeMonitor changeTableTypeMonitor) {
		ChangeTableTypeMonitor ctt = (ChangeTableTypeMonitor) httpSession
				.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_MONITOR);
		if (ctt != null) {
			httpSession.removeAttribute(SessionConstants.CHANGE_TABLE_TYPE_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.CHANGE_TABLE_TYPE_MONITOR,
				changeTableTypeMonitor);

	}

	public static Task getChangeTableTypeTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_TASK);
		if (monitor == null) {
			logger.error("CHANGE_TABLE_TYPE_TASK was not acquired");
		}
		return monitor;
	}

	public static void setChangeTableTypeTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.CHANGE_TABLE_TYPE_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.CHANGE_TABLE_TYPE_TASK);
		httpSession.setAttribute(SessionConstants.CHANGE_TABLE_TYPE_TASK, task);
	}

	// /

	public static CloneTabularResourceSession getCloneTabularResourceSession(
			HttpSession httpSession) {
		CloneTabularResourceSession cloneTabularResourceSession = (CloneTabularResourceSession) httpSession
				.getAttribute(SessionConstants.CLONE_TABULAR_RESOURCE_SESSION);
		if (cloneTabularResourceSession != null) {
			return cloneTabularResourceSession;
		} else {
			cloneTabularResourceSession = new CloneTabularResourceSession();
			httpSession.setAttribute(SessionConstants.CLONE_TABULAR_RESOURCE_SESSION,
					cloneTabularResourceSession);
			return cloneTabularResourceSession;
		}
	}

	public static void setCloneTabularResourceSession(HttpSession httpSession,
			CloneTabularResourceSession cloneTabularResourceSession) {
		CloneTabularResourceSession c = (CloneTabularResourceSession) httpSession
				.getAttribute(SessionConstants.CLONE_TABULAR_RESOURCE_SESSION);
		if (c != null) {
			httpSession.removeAttribute(SessionConstants.CLONE_TABULAR_RESOURCE_SESSION);
		}
		httpSession.setAttribute(SessionConstants.CLONE_TABULAR_RESOURCE_SESSION,
				cloneTabularResourceSession);

	}

	// /

	public static DeleteRowsSession getDeleteRowsSession(HttpSession httpSession) {
		DeleteRowsSession deleteRowsSession = (DeleteRowsSession) httpSession
				.getAttribute(SessionConstants.DELETE_ROWS_SESSION);
		if (deleteRowsSession != null) {
			return deleteRowsSession;
		} else {
			deleteRowsSession = new DeleteRowsSession();
			httpSession.setAttribute(SessionConstants.DELETE_ROWS_SESSION, deleteRowsSession);
			return deleteRowsSession;
		}
	}

	public static void setDeleteRowsSession(HttpSession httpSession,
			DeleteRowsSession deleteRowsSession) {
		DeleteRowsSession dr = (DeleteRowsSession) httpSession
				.getAttribute(SessionConstants.DELETE_ROWS_SESSION);
		if (dr != null) {
			httpSession.removeAttribute(SessionConstants.DELETE_ROWS_SESSION);
		}
		httpSession.setAttribute(SessionConstants.DELETE_ROWS_SESSION, deleteRowsSession);

	}

	public static DeleteRowsMonitor getDeleteRowsMonitor(HttpSession httpSession) {
		DeleteRowsMonitor deleteRowsMonitor = (DeleteRowsMonitor) httpSession
				.getAttribute(SessionConstants.DELETE_ROWS_MONITOR);
		if (deleteRowsMonitor != null) {
			return deleteRowsMonitor;
		} else {
			deleteRowsMonitor = new DeleteRowsMonitor();
			httpSession.setAttribute(SessionConstants.DELETE_ROWS_MONITOR, deleteRowsMonitor);
			return deleteRowsMonitor;
		}
	}

	public static void setDeleteRowsMonitor(HttpSession httpSession,
			DeleteRowsMonitor deleteRowsMonitor) {
		DeleteRowsMonitor ctt = (DeleteRowsMonitor) httpSession
				.getAttribute(SessionConstants.DELETE_ROWS_MONITOR);
		if (ctt != null) {
			httpSession.removeAttribute(SessionConstants.DELETE_ROWS_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.DELETE_ROWS_MONITOR, deleteRowsMonitor);

	}

	public static Task getDeleteRowsTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DELETE_ROWS_TASK);
		if (monitor == null) {
			logger.error("DELETE_ROWS_TASK was not acquired");
		}
		return monitor;
	}

	public static void setDeleteRowsTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DELETE_ROWS_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.DELETE_ROWS_TASK);
		httpSession.setAttribute(SessionConstants.DELETE_ROWS_TASK, task);
	}

	//

	public static TemplateApplySession getTemplateApplySession(
			HttpSession httpSession) {
		TemplateApplySession templateApplySession = (TemplateApplySession) httpSession
				.getAttribute(SessionConstants.TEMPLATE_APPLY_SESSION);
		if (templateApplySession != null) {
			return templateApplySession;
		} else {
			templateApplySession = new TemplateApplySession();
			httpSession.setAttribute(SessionConstants.TEMPLATE_APPLY_SESSION,
					templateApplySession);
			return templateApplySession;
		}
	}

	public static void setTemplateApplySession(HttpSession httpSession,
			TemplateApplySession templateApplySession) {
		TemplateApplySession dr = (TemplateApplySession) httpSession
				.getAttribute(SessionConstants.TEMPLATE_APPLY_SESSION);
		if (dr != null) {
			httpSession.removeAttribute(SessionConstants.TEMPLATE_APPLY_SESSION);
		}
		httpSession.setAttribute(SessionConstants.TEMPLATE_APPLY_SESSION, templateApplySession);

	}

	public static TemplateApplyMonitor getTemplateApplyMonitor(
			HttpSession httpSession) {
		TemplateApplyMonitor templateApplyMonitor = (TemplateApplyMonitor) httpSession
				.getAttribute(SessionConstants.TEMPLATE_APPLY_MONITOR);
		if (templateApplyMonitor != null) {
			return templateApplyMonitor;
		} else {
			templateApplyMonitor = new TemplateApplyMonitor();
			httpSession.setAttribute(SessionConstants.TEMPLATE_APPLY_MONITOR,
					templateApplyMonitor);
			return templateApplyMonitor;
		}
	}

	public static void setTemplateApplyMonitor(HttpSession httpSession,
			TemplateApplyMonitor templateApplyMonitor) {
		TemplateApplyMonitor d = (TemplateApplyMonitor) httpSession
				.getAttribute(SessionConstants.TEMPLATE_APPLY_MONITOR);
		if (d != null) {
			httpSession.removeAttribute(SessionConstants.TEMPLATE_APPLY_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.TEMPLATE_APPLY_MONITOR, templateApplyMonitor);

	}

	public static Task getTemplateApplyTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TEMPLATE_APPLY_TASK);
		if (monitor == null) {
			logger.error("TEMPLATE_APPLY_TASK was not acquired");
		}
		return monitor;
	}

	public static void setTemplateApplyTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.TEMPLATE_APPLY_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.TEMPLATE_APPLY_TASK);
		httpSession.setAttribute(SessionConstants.TEMPLATE_APPLY_TASK, task);
	}

	//

	public static DuplicatesSession getDuplicatesSession(HttpSession httpSession) {
		DuplicatesSession duplicatesSession = (DuplicatesSession) httpSession
				.getAttribute(SessionConstants.DUPLICATES_ROWS_SESSION);
		if (duplicatesSession != null) {
			return duplicatesSession;
		} else {
			duplicatesSession = new DuplicatesSession();
			httpSession
					.setAttribute(SessionConstants.DUPLICATES_ROWS_SESSION, duplicatesSession);
			return duplicatesSession;
		}
	}

	public static void setDuplicatesSession(HttpSession httpSession,
			DuplicatesSession duplicatesSession) {
		DuplicatesSession dr = (DuplicatesSession) httpSession
				.getAttribute(SessionConstants.DUPLICATES_ROWS_SESSION);
		if (dr != null) {
			httpSession.removeAttribute(SessionConstants.DUPLICATES_ROWS_SESSION);
		}
		httpSession.setAttribute(SessionConstants.DUPLICATES_ROWS_SESSION, duplicatesSession);

	}

	public static DuplicatesMonitor getDuplicatesMonitor(HttpSession httpSession) {
		DuplicatesMonitor duplicatesMonitor = (DuplicatesMonitor) httpSession
				.getAttribute(SessionConstants.DUPLICATES_ROWS_MONITOR);
		if (duplicatesMonitor != null) {
			return duplicatesMonitor;
		} else {
			duplicatesMonitor = new DuplicatesMonitor();
			httpSession
					.setAttribute(SessionConstants.DUPLICATES_ROWS_MONITOR, duplicatesMonitor);
			return duplicatesMonitor;
		}
	}

	public static void setDuplicatesMonitor(HttpSession httpSession,
			DuplicatesMonitor duplicateMonitor) {
		DuplicatesMonitor d = (DuplicatesMonitor) httpSession
				.getAttribute(SessionConstants.DUPLICATES_ROWS_MONITOR);
		if (d != null) {
			httpSession.removeAttribute(SessionConstants.DUPLICATES_ROWS_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.DUPLICATES_ROWS_MONITOR, duplicateMonitor);

	}

	public static Task getDuplicatesTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DUPLICATES_ROWS_TASK);
		if (monitor == null) {
			logger.error("DUPLICATES_ROWS_TASK was not acquired");
		}
		return monitor;
	}

	public static void setDuplicatesTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.DUPLICATES_ROWS_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.DUPLICATES_ROWS_TASK);
		httpSession.setAttribute(SessionConstants.DUPLICATES_ROWS_TASK, task);
	}

	//

	public static ArrayList<TabResource> getCodelistsPagingLoaded(
			HttpSession httpSession) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltr = ((ArrayList<TabResource>) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED));
		if (ltr == null) {
			logger.error("CODELISTS_PAGING_LOADED was not acquired");
		}
		return ltr;
	}

	public static void setCodelistsPagingLoaded(HttpSession httpSession,
			ArrayList<TabResource> listCodelists) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltr = ((ArrayList<TabResource>) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED));
		if (ltr != null)
			httpSession.removeAttribute(SessionConstants.CODELISTS_PAGING_LOADED);
		httpSession.setAttribute(SessionConstants.CODELISTS_PAGING_LOADED, listCodelists);
	}

	public static ArrayList<TabResource> getCodelistsPagingLoadedFilteredCopy(
			HttpSession httpSession) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltrFilteredCopy = ((ArrayList<TabResource>) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTERED_COPY));
		if (ltrFilteredCopy == null) {
			logger.error("CODELISTS_PAGING_LOADED_FILTERED_COPY was not acquired");
		}
		return ltrFilteredCopy;
	}

	public static void setCodelistsPagingLoadedFilteredCopy(
			HttpSession httpSession,
			ArrayList<TabResource> listCodelistsFilteredCopy) {
		@SuppressWarnings("unchecked")
		ArrayList<TabResource> ltrFilteredCopy = ((ArrayList<TabResource>) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTERED_COPY));
		if (ltrFilteredCopy != null)
			httpSession.removeAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTERED_COPY);
		httpSession.setAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTERED_COPY,
				listCodelistsFilteredCopy);
	}

	public static String getCodelistsPagingLoadedFilter(HttpSession httpSession) {
		String filter = (String) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTER);
		if (filter == null) {
			logger.error("CODELISTS_PAGING_LOADED_FILTER was not acquired");
		}
		return filter;
	}

	public static void setCodelistsPagingLoadedFilter(HttpSession httpSession,
			String filter) {

		String fil = ((String) httpSession
				.getAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTER));
		if (fil != null)
			httpSession.removeAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTER);
		httpSession.setAttribute(SessionConstants.CODELISTS_PAGING_LOADED_FILTER, filter);
	}
	
	//

	public static RollBackSession getRollBackSession(
			HttpSession httpSession) {
		RollBackSession rollBackSession = (RollBackSession) httpSession
				.getAttribute(SessionConstants.ROLLBACK_SESSION);
		if (rollBackSession != null) {
			return rollBackSession;
		} else {
			rollBackSession = new RollBackSession();
			httpSession
					.setAttribute(SessionConstants.ROLLBACK_SESSION, rollBackSession);
			return rollBackSession;
		}
	}

	public static void setRollBackSession(HttpSession httpSession,
			RollBackSession rollBackSession) {
		RollBackSession rb = (RollBackSession) httpSession
				.getAttribute(SessionConstants.ROLLBACK_SESSION);
		if (rb != null) {
			httpSession.removeAttribute(SessionConstants.ROLLBACK_SESSION);
		}
		httpSession.setAttribute(SessionConstants.ROLLBACK_SESSION, rollBackSession);

	}

	public static RollBackSessionMonitor getRollBackSessionMonitor(
			HttpSession httpSession) {
		RollBackSessionMonitor rollBackMonitor = (RollBackSessionMonitor) httpSession
				.getAttribute(SessionConstants.ROLLBACK_MONITOR);
		if (rollBackMonitor != null) {
			return rollBackMonitor;
		} else {
			rollBackMonitor = new RollBackSessionMonitor();
			httpSession
					.setAttribute(SessionConstants.ROLLBACK_MONITOR, rollBackMonitor);
			return rollBackMonitor;
		}
	}

	public static void setRollBackSessionMonitor(HttpSession httpSession,
			RollBackSessionMonitor rollBackMonitor) {
		RollBackSessionMonitor rb = (RollBackSessionMonitor) httpSession
				.getAttribute(SessionConstants.ROLLBACK_MONITOR);
		if (rb != null) {
			httpSession.removeAttribute(SessionConstants.ROLLBACK_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.ROLLBACK_MONITOR, rollBackMonitor);

	}

	public static Task getRollBackSessionTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.ROLLBACK_TASK);
		if (monitor == null) {
			logger.error("ROLLBACK_TASK was not acquired");
		}
		return monitor;
	}

	public static void setRollBackSessionTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.ROLLBACK_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.ROLLBACK_TASK);
		httpSession.setAttribute(SessionConstants.ROLLBACK_TASK, task);
	}

	//
	public static ExtractCodelistSession getExtractCodelistSession(
			HttpSession httpSession) {
		ExtractCodelistSession extractCodelistSession = (ExtractCodelistSession) httpSession
				.getAttribute(SessionConstants.EXTRACT_CODELIST_SESSION);
		if (extractCodelistSession != null) {
			return extractCodelistSession;
		} else {
			extractCodelistSession = new ExtractCodelistSession();
			httpSession.setAttribute(SessionConstants.EXTRACT_CODELIST_SESSION,
					extractCodelistSession);
			return extractCodelistSession;
		}
	}

	public static void setExtractCodelistSession(HttpSession httpSession,
			ExtractCodelistSession extractCodelistSession) {
		ExtractCodelistSession ec = (ExtractCodelistSession) httpSession
				.getAttribute(SessionConstants.EXTRACT_CODELIST_SESSION);
		if (ec != null) {
			httpSession.removeAttribute(SessionConstants.EXTRACT_CODELIST_SESSION);
		}
		httpSession.setAttribute(SessionConstants.EXTRACT_CODELIST_SESSION, extractCodelistSession);

	}

	public static ExtractCodelistMonitor getExtractCodelistMonitor(
			HttpSession httpSession) {
		ExtractCodelistMonitor extractCodelistMonitor = (ExtractCodelistMonitor) httpSession
				.getAttribute(SessionConstants.EXTRACT_CODELIST_MONITOR);
		if (extractCodelistMonitor != null) {
			return extractCodelistMonitor;
		} else {
			extractCodelistMonitor = new ExtractCodelistMonitor();
			httpSession.setAttribute(SessionConstants.EXTRACT_CODELIST_MONITOR,
					extractCodelistMonitor);
			return extractCodelistMonitor;
		}
	}

	public static void setExtractCodelistMonitor(HttpSession httpSession,
			ExtractCodelistMonitor extractCodelistMonitor) {
		ExtractCodelistMonitor ecm = (ExtractCodelistMonitor) httpSession
				.getAttribute(SessionConstants.EXTRACT_CODELIST_MONITOR);
		if (ecm != null) {
			httpSession.removeAttribute(SessionConstants.EXTRACT_CODELIST_MONITOR);
		}
		httpSession.setAttribute(SessionConstants.EXTRACT_CODELIST_MONITOR, extractCodelistMonitor);

	}

	public static Task getExtractCodelistTask(HttpSession httpSession) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.EXTRACT_CODELIST_TASK);
		if (monitor == null) {
			logger.error("EXTRACT_CODELIST_TASK was not acquired");
		}
		return monitor;
	}

	public static void setExtractCodelistTask(HttpSession httpSession, Task task) {
		Task monitor = (Task) httpSession.getAttribute(SessionConstants.EXTRACT_CODELIST_TASK);
		if (monitor != null)
			httpSession.removeAttribute(SessionConstants.EXTRACT_CODELIST_TASK);
		httpSession.setAttribute(SessionConstants.EXTRACT_CODELIST_TASK, task);
	}

	
	
	
}
