/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.shared.extract;

import java.io.Serializable;
import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ExtractCodelistSession implements Serializable {

	private static final long serialVersionUID = -2537172740573310646L;
	
	protected TRId trId;
	protected TabResource tabResource;
	protected ArrayList<ColumnData> sourceColumns;
	protected ArrayList<ExtractCodelistTargetColumn> targetColumns;

	public ExtractCodelistSession() {
	}

	public ExtractCodelistSession(TRId trId, TabResource tabResource,ArrayList<ColumnData> sourceColumns,
			ArrayList<ExtractCodelistTargetColumn> targetColumns) {
		this.trId=trId;
		this.tabResource= tabResource;
		this.sourceColumns = sourceColumns;
		this.targetColumns = targetColumns;
	}

	public ArrayList<ColumnData> getSourceColumns() {
		return sourceColumns;
	}

	public void setSourceColumns(ArrayList<ColumnData> sourceColumns) {
		this.sourceColumns = sourceColumns;
	}

	public ArrayList<ExtractCodelistTargetColumn> getTargetColumns() {
		return targetColumns;
	}

	public void setTargetColumns(
			ArrayList<ExtractCodelistTargetColumn> targetColumns) {
		this.targetColumns = targetColumns;
	}

	public TabResource getTabResource() {
		return tabResource;
	}

	public void setTabResource(TabResource tabResource) {
		this.tabResource = tabResource;
	}
	
	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}

	@Override
	public String toString() {
		return "ExtractCodelistSession [trId=" + trId + ", tabResource="
				+ tabResource + ", sourceColumns=" + sourceColumns
				+ ", targetColumns=" + targetColumns + "]";
	}

	
    

	
}
