package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.util.Date;

import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TDTypeValueMap {
	protected static Logger logger = LoggerFactory
			.getLogger(TDTypeValueMap.class);
	
	public static TDTypeValue map(String dataTypeName, String value)
			throws TDGWTServiceException {
		TDTypeValue tdTypeValue = null;
		try {
			switch (dataTypeName) {
			case "Boolean":
				Boolean b = new Boolean(value);
				tdTypeValue = new TDBoolean(b);
				break;
			case "Date":
				Long d = new Long(value);
				Date date = new Date(d);
				tdTypeValue = new TDDate(date);
				break;
			case "Geometry":
				tdTypeValue = new TDText(value);
				break;
			case "Integer":
				Integer in = new Integer(value);
				tdTypeValue = new TDInteger(in);
				break;
			case "Numeric":
				Float fl = new Float(value);
				tdTypeValue = new TDNumeric(fl);
				break;
			case "Text":
				tdTypeValue = new TDText(value);
				break;
			default:
				break;
			}

		} catch (Throwable e) {
			logger.debug("Error in TDTypeValueMap: "+e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException("Error in TDTypeValueMap: "
					+ e.getLocalizedMessage());
		}
		return tdTypeValue;
	}
}
