/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.history.OpHistory;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSessionMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareInfo;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplyMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */

public interface TDGWTServiceAsync {

	public static TDGWTServiceAsync INSTANCE = (TDGWTServiceAsync) GWT
			.create(TDGWTService.class);

	void hello(AsyncCallback<String> callback);	
	
	//TabularResource
	void getCurrentTRId(AsyncCallback<TRId> callback);
	void createTabularResource(TabResource tabResource,AsyncCallback<TabResource> callback);
	void removeTabularResource(TRId trId, AsyncCallback<Void> callback);   
	void isTabularResourceValid(TRId trId,AsyncCallback<Boolean> callback);
	void getTabResourceInformation(AsyncCallback<TabResource> callback);
	void getTabResourceInformation(TRId trId,AsyncCallback<TabResource> callback);	
	void setTabResourceInformation(TabResource tabResource, AsyncCallback<Void> callback);
	void getTRCreationDate(TRId trId,AsyncCallback<String> callback);
    void setTabResource(TabResource tabResource, AsyncCallback<Void> callback);
    void getTabularResources(AsyncCallback<ArrayList<TabResource>> callback);
    void getTabularResourcesAndLastTables(AsyncCallback<ArrayList<TabResource>> callback);
    void getLastTable(TRId trId, AsyncCallback<TableData> callback);
    void getTable(TRId trId, AsyncCallback<TableData> callback);
    void getTableMetadata(TRId trId, AsyncCallback<ArrayList<TabMetadata>> callback);
    void getTRMetadata(TRId trId, AsyncCallback<ArrayList<TRMetadata>> callback);
    void getColumns(AsyncCallback<ArrayList<ColumnData>> callback);
    void getColumns(TRId trId, AsyncCallback<ArrayList<ColumnData>> callback);
    void getColumnsForDimension(TRId trId, AsyncCallback<ArrayList<ColumnData>> callback);
    void getColumn(TRId trId, String columnName, AsyncCallback<ColumnData> callback);
    void getColumn(String columnLocalId,TRId trId, AsyncCallback<ColumnData> callback);
    void getConnection(RefColumn refColumn, AsyncCallback<ColumnData> callback);
    
    //Task
    void getTaskResubmitMonitor(AsyncCallback<TaskResubmitMonitor> callback);
	void startTaskResubmit(TaskResubmitSession taskResubmitSession,AsyncCallback<Void> callback);	
	void getTaskResumeMonitor(AsyncCallback<TaskResumeMonitor> callback);
	void startTaskResume(TaskResumeSession taskResumeSession,AsyncCallback<Void> callback);	
	

    //Validations
    void getValidationsTasksMetadata(TRId trId,AsyncCallback<ValidationsTasksMetadata> callback);
    void getTableValidationsMetadata(TRId trId,AsyncCallback<TabValidationsMetadata> callback);
    void getValidationColumns(TRId trId, String columnName, AsyncCallback<ArrayList<ColumnData>> callback);
    
    //RollBack
    void rollBack(RollBackSession rollBackSession,AsyncCallback<Void> callback);
    void getRollBackMonitor(AsyncCallback<RollBackSessionMonitor> callback);
    void discard(TRId trId,AsyncCallback<RollBackSession> callback);
    
    //Share
    void getShareInfo(TRId trId, AsyncCallback<ShareInfo> callback);
    
    void setShare(ShareInfo shareInfo, AsyncCallback<Void> callback);
    
    //CodelistPagingLoaded
	void setCodelistsPagingLoader(AsyncCallback<Void> callback);

	void getCodelistsPagingLoader(
			CodelistPagingLoadConfig codelistPagingLoadConfig,
			AsyncCallback<CodelistPagingLoadResult> callback);

    //Open
    void startTDOpen(TDOpenSession tdOpenSession, AsyncCallback<Void> callback);
	
    //Clone
	void startCloneTabularResource(CloneTabularResourceSession cloneTabularResourceSession,AsyncCallback<TRId> callback);	
	
    
    //SDMX
    void getCodelists(AsyncCallback<ArrayList<Codelist>> callback);

	void getDatasets(AsyncCallback<ArrayList<Dataset>> callback);
	
	void getAgencies(AsyncCallback<ArrayList<Agencies>> callback);
	
	void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource, AsyncCallback<Void> callback);
	
	//Import SDMX 
	void getSDMXImportMonitor(AsyncCallback<SDMXImportMonitor> callback);
	
	void startSDMXImport(SDMXImportSession sdmxImportSession,AsyncCallback<Void> callback);
    
	//Import CSV
	void getFileUploadMonitor(AsyncCallback<FileUploadMonitor> callback);
	
	void getCSVImportMonitor(AsyncCallback<CSVImportMonitor> callback);
	
	void setCSVSession(CSVImportSession csvImportSession, AsyncCallback<Void> callback);

	void getFileFromWorkspace(CSVImportSession csvImportSession, AsyncCallback<Void> callback);

	void getAvailableCharset(AsyncCallback<AvailableCharsetList> callback);
	
	void configureCSVParser(String encoding, HeaderPresence headerPresence, char delimiter, char comment, AsyncCallback<ArrayList<String>> callback);
	
	void checkCSV(long errorsLimit, AsyncCallback<ArrayList<CSVRowError>> callback);
	
	void startCSVImport(CSVImportSession csvImportSession, AsyncCallback<Void> callback);
	
	//Export CSV
	void getCSVExportMonitor(AsyncCallback<CSVExportMonitor> callback);
	
	void startCSVExport(CSVExportSession csvExportSession, AsyncCallback<Void> callback);
	
	//Export SDMX
	void getSDMXExportMonitor(AsyncCallback<SDMXExportMonitor> callback);

	void startSDMXExport(SDMXExportSession exportSession, AsyncCallback<Void> callback);
	
	
	//Table Operation
	void getChangeTableTypeMonitor(AsyncCallback<ChangeTableTypeMonitor> callback);
	void startChangeTableType(ChangeTableTypeSession changeTableTypeSession,AsyncCallback<Void> callback);	
	
	//Rows Operation
	void getEditRowMonitor(AsyncCallback<EditRowMonitor> callback);
	void startEditRow(EditRowSession editRowSession,AsyncCallback<Void> callback);	
	
	void getDeleteRowsMonitor(AsyncCallback<DeleteRowsMonitor> callback);
	void startDeleteRows(DeleteRowsSession deleteRowsSession,AsyncCallback<Void> callback);	
	
	void getDuplicatesMonitor(AsyncCallback<DuplicatesMonitor> callback);
	void startDuplicates(DuplicatesSession duplicatesSession,AsyncCallback<Void> callback);	
	

	//Column Operation 
	void getChangeColumnTypeMonitor(AsyncCallback<ChangeColumnTypeMonitor> callback);
	void startChangeColumnType(ChangeColumnTypeSession changeColumnTypeSession,AsyncCallback<Void> callback);
	void getDeleteColumnMonitor(AsyncCallback<DeleteColumnMonitor> callback);
	void startDeleteColumn(DeleteColumnSession deleteColumnSession,AsyncCallback<Void> callback);
	void getLabelColumnMonitor(AsyncCallback<LabelColumnMonitor> callback);
	void startLabelColumn(LabelColumnSession labelColumnSession,AsyncCallback<Void> callback);	

	//BatchReplace Operation
	void getOccurrencesForBatchReplace(OccurrencesForReplaceBatchColumnSession occurrencesForReplaceBatchColumnSession, AsyncCallback<ArrayList<Occurrences>> callback); 
	void getReplaceBatchColumnMonitor(AsyncCallback<ReplaceBatchColumnMonitor> callback);
	void startReplaceBatchColumn(ReplaceBatchColumnSession replaceBatchColumnSession,AsyncCallback<Void> callback);	
	
	//Replace Operation
	void getReplaceColumnMonitor(AsyncCallback<ReplaceColumnMonitor> callback);
	void startReplaceColumn(ReplaceColumnSession replaceColumnSession,AsyncCallback<Void> callback);	
	
	//Templates
	void getTemplates(AsyncCallback<ArrayList<TemplateData>> callback);
	void getTemplateApplyMonitor(AsyncCallback<TemplateApplyMonitor> callback);
	void startTemplateApply(TemplateApplySession templateDeleteSession,AsyncCallback<Void> callback);	
	void startTemplateDelete(TemplateDeleteSession templateDeleteSession,AsyncCallback<Void> callback);	
	
	//Locales
	void getLocales(AsyncCallback<ArrayList<String>> callback);
	
	//History
	void getHistory(AsyncCallback<ArrayList<OpHistory>> callback);
	void getHistory(TRId trId, AsyncCallback<ArrayList<OpHistory>> callback);
	void getLastOperationInfo(AsyncCallback<OpHistory> callback);
	void getLastOperationInfo(TRId trId, AsyncCallback<OpHistory> callback);
	
	//Extract Codelist
	void getExtractCodelistMonitor(AsyncCallback<ExtractCodelistMonitor> callback);
	void startExtractCodelist(ExtractCodelistSession extractCodelistSession, AsyncCallback<Void> callback);
		
}
