/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.util.ServiceCredentials;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVFileUtil;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Returns a representation of the csv file in JSON
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CSVImportFileServlet extends HttpServlet {

	private static Logger logger = LoggerFactory
			.getLogger(CSVImportFileServlet.class);

	/**
	 * 
	 */
	private static final long serialVersionUID = -4197748678713054285L;

	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		handleRequest(req, resp);
	}

	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		handleRequest(req, resp);
	}

	protected void handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		logger.info("CSVImportFileServlet");
		long startTime = System.currentTimeMillis();
		logger.debug("Request Headers: ");
		Enumeration<String> headers=request.getHeaderNames();
		while(headers.hasMoreElements()){
			String hName=headers.nextElement();
			logger.debug("Header: "+hName+" = "+request.getHeader(hName));
		}
		
		
		HttpSession session = request.getSession();

		if (session == null) {
			logger.error("Error getting the upload session, no session valid found: "
					+ session);
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
					"ERROR-Error getting the user session, no session found"
							+ session);
			return;
		}
		logger.info("CSVImportFileServlet import session id: "
				+ session.getId());

		ServiceCredentials serviceCredentials;

		String scopeGroupId = request.getHeader(Constants.CURR_GROUP_ID);
		if (scopeGroupId == null || scopeGroupId.isEmpty()) {
			scopeGroupId = request.getParameter(Constants.CURR_GROUP_ID);
			if (scopeGroupId == null || scopeGroupId.isEmpty()) {
				logger.error("CURR_GROUP_ID is null, it is a mandatory parameter in custom servlet: "
						+ scopeGroupId);
				throw new ServletException(
						"CURR_GROUP_ID is null, it is a mandatory parameter in custom servlet: "
								+ scopeGroupId);
			}
		}

		try {
			serviceCredentials = SessionUtil.getServiceCredentials(request,
					scopeGroupId);

		} catch (TDGWTServiceException e) {
			logger.error(
					"Error retrieving credentials:" + e.getLocalizedMessage(),
					e);
			throw new ServletException(e.getLocalizedMessage());
		}

		CSVFileUploadSession fileUploadSession = SessionUtil
				.getCSVFileUploadSession(request, serviceCredentials);

		if (fileUploadSession == null) {
			logger.error("Error getting the upload session, no fileUploadSession found: "
					+ fileUploadSession);
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
					"ERROR-Error getting the user session, no fileUploadSession found: "
							+ fileUploadSession);
			return;
		}

		response.setContentType("application/json; charset=utf-8");
		Charset outputCharset = Charset.forName("Utf-8");

		ByteArrayOutputStream os = new ByteArrayOutputStream();
		CSVFileUtil.toJson(new FileInputStream(fileUploadSession.getCsvFile()),
				os, outputCharset, fileUploadSession.getParserConfiguration(),
				100);

		logger.trace("json: " + os.toString());
		System.out.println("json: " + os.toString());
		response.getOutputStream().write(os.toByteArray());

		// CSVFileUtil.toJson(new FileInputStream(importSession.getCsvFile()),
		// response.getOutputStream(), outputCharset,
		// importSession.getParserConfiguration(), 100);

		response.setStatus(HttpServletResponse.SC_OK);
		logger.trace("Response in " + (System.currentTimeMillis() - startTime));
	}

}
