package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.util.ArrayList;
import java.util.Arrays;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrderDirection;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.query.parameters.group.QueryGroup;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QueryColumn;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QueryColumn.Function;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QuerySelect;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ShowOccurrencesType;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class QueryService {

	protected static Logger logger = LoggerFactory
			.getLogger(QueryService.class);

	public static ArrayList<Occurrences> queryOccurences(
			TabularDataService service,
			OccurrencesForReplaceBatchColumnSession occurrencesSession,
			Direction direction) throws TDGWTServiceException {
		logger.debug("QueryOccurences");
		ColumnData column = occurrencesSession.getColumnData();

		ArrayList<Occurrences> occurences = new ArrayList<Occurrences>();

		TableId tableId = new TableId(new Long(column.getTrId().getTableId()));
		ColumnLocalId columnId = new ColumnLocalId(column.getColumnId());
		QuerySelect querySelect;
		QueryGroup queryGroup;
		if (column.isViewColumn()) {
			ColumnLocalId sourceColumnId = new ColumnLocalId(column
					.getColumnViewData().getSourceTableDimensionColumnId());
			querySelect = new QuerySelect(Arrays.asList(new QueryColumn(
					columnId), new QueryColumn(sourceColumnId),
					new QueryColumn(columnId, Function.COUNT)));
			logger.debug("Occurences querySelect:" + querySelect.toString());
			queryGroup = new QueryGroup(Arrays.asList(columnId, sourceColumnId));
			logger.debug("Occurences queryGroup:" + queryGroup.toString());
		} else {
			querySelect = new QuerySelect(Arrays.asList(new QueryColumn(
					columnId), new QueryColumn(columnId, Function.COUNT)));
			logger.debug("Occurences querySelect:" + querySelect.toString());
			queryGroup = new QueryGroup(Arrays.asList(columnId));
			logger.debug("Occurences queryGroup:" + queryGroup.toString());
		}

		QueryOrder queryOrder = null;
		switch (direction) {
		case ASC:
			queryOrder = new QueryOrder(columnId, QueryOrderDirection.ASCENDING);
			break;
		case DESC:
			queryOrder = new QueryOrder(columnId,
					QueryOrderDirection.DESCENDING);
			break;
		default:
			break;

		}

		QueryPage queryPage = null;// All occurences
		logger.debug("Occurences queryPage all");

		QueryFilter queryFilter = null;
		if (occurrencesSession.getShowType().compareTo(
				ShowOccurrencesType.ONLYERRORS) == 0) {
			if (occurrencesSession.isHasValidationColumns()) {
				Expression exp=ExpressionGenerator
						.genReplaceBatchOccurrencesFilter(column);
				logger.debug("Expression: "+exp);
				if(exp!=null){
					queryFilter = new QueryFilter(
						exp);
				}
			} else {
				return occurences;
			}
		}
		
		logger.debug("Query on " + tableId.toString() + " queryPage:"
				+ queryPage + " queryFilter:" + queryFilter
				+ " querySelect:" + querySelect + " queryGroup:"
				+ queryGroup+" queryOrder:"+queryOrder);
		logger.debug("Query Select Columns:"+querySelect.getColumns());
		logger.debug("Query Group Columns: "+queryGroup.getColumns());
		String serviceJson = null;
		try {
			if (queryOrder == null) {
				if (queryFilter == null) {
					serviceJson = service.queryAsJson(tableId, queryPage,
							querySelect, queryGroup);
				} else {
					serviceJson = service.queryAsJson(tableId, queryPage,
							queryFilter, querySelect, queryGroup);
				}
			} else {
				if (queryFilter == null) {
					serviceJson = service.queryAsJson(tableId, queryPage,
							queryOrder, querySelect, queryGroup);
				} else {
					serviceJson = service.queryAsJson(tableId, queryPage,
							queryFilter, queryOrder, querySelect, queryGroup);

				}
			}
		} catch (Throwable e) {
			logger.debug("Error by running the query on the server:"
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new TDGWTServiceException(
					"An error occurred while running query on service", e);
		}

		logger.debug("Created serviceJson");
		// logger.debug(serviceJson);

		JSONArray currentRow = null;
		int i = -1;
		int j = -1;
		int totalRows = -1;

		try {
			org.json.JSONObject obj = new org.json.JSONObject(serviceJson);
			org.json.JSONArray rows = obj.getJSONArray("rows");

			totalRows = rows.length();
			logger.debug("Reading rows from json");
			Occurrences occurence = null;
			for (i = 0; i < totalRows; i++) {

				currentRow = rows.getJSONArray(i);
				if (column.isViewColumn()) {
					occurence = new Occurrences(currentRow.getString(0),
							currentRow.getString(1), currentRow.getInt(2));
				} else {
					occurence = new Occurrences(currentRow.getString(0),
							currentRow.getInt(1));
				}
				//logger.debug(occurence.toString());
				occurences.add(occurence);

			}

		} catch (JSONException e) {

			logger.error("An error occurred while parsing json document\n"
					+ "At Row " + i + ",Column " + j + "\nRow Content: "
					+ currentRow + "\nLenght rows " + totalRows, e);
			throw new TDGWTServiceException(
					"An error occurred,  while reading json of service", e);
		}
		logger.debug("Retieved occurences: size " + occurences.size());
		return occurences;

	}

	
	
}
