package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Operation Execution for change label column
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class OpExecution4LabelColumn extends OpExecutionBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(OpExecution4LabelColumn.class);

	private TabularDataService service;
	private LabelColumnSession labelColumnSession;

	public OpExecution4LabelColumn(TabularDataService service,
			LabelColumnSession labelColumnSession) {
		this.service = service;
		this.labelColumnSession = labelColumnSession;
	}

	@Override
	public void buildOpEx() throws TDGWTServiceException {
		logger.debug("LabelColumnSession :" + labelColumnSession);
		ArrayList<OperationExecution> invocations = new ArrayList<OperationExecution>();

		HashMap<ColumnData, String> columnsMaps = labelColumnSession.getMaps();

		for (ColumnData key : columnsMaps.keySet()) {
			OperationExecution invocation = null;

			OperationDefinition operationDefinition;
			Map<String, Object> map = new HashMap<String, Object>();

			ImmutableLocalizedText localizedText = new ImmutableLocalizedText(
					columnsMaps.get(key));

			map.put(Constants.NAME_PARAMETER_ID, localizedText);

			operationDefinition = OperationDefinitionMap.map(
					OperationsId.ColumnNameAdd.toString(), service);

			invocation = new OperationExecution(key.getColumnId(),
					operationDefinition.getOperationId(), map);

			invocations.add(invocation);

		}
		operationExecutionSpec.setOps(invocations);

	}

}
