package org.gcube.portlets.user.td.gwtservice.shared.tr;

import java.io.Serializable;
import java.util.ArrayList;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ColumnData implements Serializable {

	private static final long serialVersionUID = 7614033455605898209L;

	protected String id; // For insert in table only
	protected String columnId; // Id of column on server
	protected String name;
	protected String typeName;
	protected String typeCode;
	protected String dataTypeName;
	protected String label;
	protected String locale;
	
	protected TRId trId;
	protected boolean viewColumn;
	protected ColumnViewData columnViewData;
	
	// Relationship for Dimension and Timedimension columns
	protected RelationshipData relationship;
	
	// validation columns that validate this column
	protected ArrayList<String> validationColumnReferences;

	// true if this is a validation column
	protected boolean validationColumn;
	// if this is a validation column then contains the columns validated
	protected ArrayList<String> validatedColumns;
	
	
	public ColumnData(){
		
	}
	
	
	public String getColumnId() {
		return columnId;
	}

	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public String getTypeCode() {
		return typeCode;
	}

	public void setTypeCode(String typeCode) {
		this.typeCode = typeCode;
	}

	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getDataTypeName() {
		return dataTypeName;
	}

	public void setDataTypeName(String dataTypeName) {
		this.dataTypeName = dataTypeName;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public ColumnViewData getColumnViewData() {
		return columnViewData;
	}

	public void setColumnViewData(ColumnViewData columnViewData) {
		this.columnViewData = columnViewData;
	}

	public boolean isViewColumn() {
		return viewColumn;
	}

	public void setViewColumn(boolean viewColumn) {
		this.viewColumn = viewColumn;
	}

	public boolean isValidationColumn() {
		return validationColumn;
	}

	public void setValidationColumn(boolean validationColumn) {
		this.validationColumn = validationColumn;
	}

	public ArrayList<String> getValidatedColumns() {
		return validatedColumns;
	}

	public void setValidatedColumns(ArrayList<String> validatedColumns) {
		this.validatedColumns = validatedColumns;
	}

	public ArrayList<String> getValidationColumnReferences() {
		return validationColumnReferences;
	}
	
	public void setValidationColumnReferences(
			ArrayList<String> validationColumnReferences) {
		this.validationColumnReferences = validationColumnReferences;
	}
	
	public String getLocale() {
		return locale;
	}

	public void setLocale(String locale) {
		this.locale = locale;
	}

	public RelationshipData getRelationship() {
		return relationship;
	}

	public void setRelationship(RelationshipData relationship) {
		this.relationship = relationship;
	}

	@Override
	public String toString() {
		return "ColumnData [id=" + id + ", columnId=" + columnId + ", name="
				+ name + ", typeName=" + typeName + ", typeCode=" + typeCode
				+ ", dataTypeName=" + dataTypeName + ", label=" + label
				+ ", locale=" + locale + ", trId=" + trId + ", viewColumn="
				+ viewColumn + ", columnViewData=" + columnViewData
				+ ", relationship=" + relationship
				+ ", validationColumnReferences=" + validationColumnReferences
				+ ", validationColumn=" + validationColumn
				+ ", validatedColumns=" + validatedColumns + "]";
	}

	
	
}
