package org.gcube.portlets.user.td.mainboxwidget.client.tdx;

import org.gcube.portlets.user.td.mainboxwidget.client.resources.MainboxResources;
import org.gcube.portlets.user.td.resourceswidget.client.ResourcesListViewPanel;
import org.gcube.portlets.user.td.widgetcommonevent.shared.dataview.TabularResourceDataView;
import org.gcube.portlets.user.tdwx.client.TabularDataX;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.TabItemConfig;
import com.sencha.gxt.widget.core.client.TabPanel;

public class TDXTabPanel extends TabPanel {
	private static final int TAB_WIDTH = 96;

	private EventBus eventBus;
	private TDXGridPanel gridPanel;
	private ResourcesListViewPanel resourcesPanel;

	public TDXTabPanel(EventBus eventBus) {
		super();
		// GWT.<TabPanelAppearance> create(BlueTabPanelAppearance.class));
		Log.debug("Create TDXTabPanel");
		this.eventBus = eventBus;
		init();
		create();
		forceLayout();
	}

	protected void init() {
		setBodyBorder(false);
		setBorders(false);
		setAnimScroll(false);
		setTabScroll(false);
		setCloseContextMenu(false);
		setResizeTabs(true);
		setTabWidth(TAB_WIDTH);
		
		XElement barElement=getAppearance().getBar(getElement());
		XElement bodyElement=getAppearance().getBody(getElement());
		
		
		barElement.getStyle().setFloat(com.google.gwt.dom.client.Style.Float.RIGHT);
		bodyElement.getStyle().setFloat(com.google.gwt.dom.client.Style.Float.LEFT);
		
		
		/*
		addStyleName(ThemeStyles.get().style().);
		
		getElement().getStyle().setFloat(Float.R);setBackgroundColor("white");
		
		.x-tab {
		    position:initial !important;
		    float:right;
		}
		*/

	}

	protected void create() {
		TabItemConfig gridItemConf = new TabItemConfig("Grid", false);
		gridItemConf.setIcon(MainboxResources.INSTANCE
				.table());
		
		
		gridPanel = new TDXGridPanel(eventBus);

		add(gridPanel, gridItemConf);

		TabItemConfig resourcesItemConf = new TabItemConfig("Resources", false);
		resourcesItemConf.setIcon(MainboxResources.INSTANCE
				.resources());
		
		
		resourcesPanel = new ResourcesListViewPanel(eventBus);

		add(resourcesPanel, resourcesItemConf);

		setActiveWidget(gridPanel);
	}

	public void open(TabularResourceDataView dataView) {
		gridPanel.open(dataView);
		resourcesPanel.open(dataView.getTrId());
		forceLayout();

	}

	public void update(TabularResourceDataView dataView) {
		gridPanel.update(dataView);
		resourcesPanel.open(dataView.getTrId());
		forceLayout();

	}

	public boolean isValidDataViewRequest(
			TabularResourceDataView dataViewRequest) {
		return gridPanel.isValidDataViewRequest(dataViewRequest);
	}

	public TabularDataX getTabularData() {
		return gridPanel.getTabularData();
	}

	public TabularResourceDataView getTabularResourceDataView() {
		return gridPanel.getTabularResourceDataView();
	}

}
