/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.Viewport;

public class PortalViewport
extends SimpleContainer {
    protected int rightScrollBarSize = 17;
    protected boolean enableScroll;

    public PortalViewport() {
        this((Viewport.ViewportAppearance)GWT.create(Viewport.ViewportAppearance.class));
    }

    public PortalViewport(Viewport.ViewportAppearance appearance) {
        super(true);
        try {
            SafeHtmlBuilder sb = new SafeHtmlBuilder();
            appearance.render(sb);
            this.setElement((Element)XDOM.create((SafeHtml)sb.toSafeHtml()));
            this.monitorWindowResize = true;
            this.forceLayoutOnResize = true;
            this.getFocusSupport().setIgnore(false);
            this.resize();
        }
        catch (Exception e) {
            Log.error((String)("PortalViewport: constructor error " + e.getLocalizedMessage()));
        }
    }

    public boolean isEnableScroll() {
        return this.enableScroll;
    }

    public void setEnableScroll(boolean enableScroll) {
        this.enableScroll = enableScroll;
        Window.enableScrolling((boolean)enableScroll);
    }

    public int getRightScrollBarSize() {
        return this.rightScrollBarSize;
    }

    public void setRightScrollBarSize(int rightScrollBarSize) {
        this.rightScrollBarSize = rightScrollBarSize;
    }

    protected void onAttach() {
        super.onAttach();
        this.setEnableScroll(this.enableScroll);
        this.resize();
    }

    protected void resize() {
        int viewWidth = this.enableScroll ? this.calculateWidth() - this.rightScrollBarSize : this.calculateWidth();
        int viewHeight = this.calculateHeight();
        Log.info((String)("TDM resize viewWidth: " + viewWidth + " viewHeight: " + viewHeight + " clientWidth: " + Window.getClientWidth() + " clientHeight: " + Window.getClientHeight()));
        try {
            this.setPixelSize(viewWidth, viewHeight);
        }
        catch (Exception e) {
            Log.error((String)("PortalViewport: error in resize() at setPixelSize " + e.getLocalizedMessage()));
        }
    }

    protected void onWindowResize(int width, int height) {
        int viewWidth = this.calculateWidth();
        int viewHeight = this.calculateHeight();
        Log.trace((String)("TDM onWindowResize viewWidth: " + viewWidth + " viewHeight: " + viewHeight + " clientWidth: " + Window.getClientWidth() + " clientHeight: " + Window.getClientHeight()));
        this.setPixelSize(viewWidth, viewHeight);
    }

    protected int calculateWidth() {
        int leftBorder = this.getAbsoluteLeft();
        Log.info((String)("TDM width: " + String.valueOf(Window.getClientWidth() - 2 * leftBorder)));
        return Window.getClientWidth() - 2 * leftBorder;
    }

    protected int calculateHeight() {
        int topBorder = this.getAbsoluteTop();
        Log.info((String)("TDM height: " + String.valueOf(Window.getClientHeight() - topBorder - 34)));
        return Window.getClientHeight() - topBorder - 34;
    }
}

