/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client.general;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.tr.TRId;
import org.gcube.portlets.user.td.openwidget.client.util.ErrorMessageBox;



import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.CardLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.FillToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class WizardWindow extends Window {
	
	protected final String WIZARDWIDTH="640px";
	protected final String WIZARDHEIGHT="480px";
	protected final boolean WIZARRESIZABLE=false;
	protected final boolean WIZARDCOLLAPSIBLE = true;
	protected final String BUTTONBACKLABEL="Back";
	protected final String BUTTONNEXTLABEL="Open";
	protected final String BUTTONFINISHLABEL="Finish";
	
	
	protected ArrayList<WizardCard> cardStack = new ArrayList<WizardCard>();

	protected TextButton backButton;

	protected TextButton nextButton;

	protected String originalTitle;

	protected boolean checkBeforeClose = true;

	protected boolean nextCardFinish = false;

	protected Command nextButtonAction = null;

	protected Command previousButtonAction = null;
	
	protected Command finishCommand = new Command() {

		public void execute() {
			close(false);
		}
	};
	

	protected CardLayoutContainer cardContainer;

	protected ArrayList<WizardListener> listeners;
	
	protected SimpleEventBus eventBus;

	protected boolean finish=true;
	/**
	 * Create a new Wizard Window with the specified title.
	 * @param title the wizard window title.height
	 */
	public WizardWindow(String title)
	{
		super();
		Log.info("Window "+title);
		this.eventBus= new SimpleEventBus();
		Log.info(title);
		//setModal(true);
		setResizable(WIZARRESIZABLE);
		setCollapsible(WIZARDCOLLAPSIBLE);
		setWidth(WIZARDWIDTH);
		setHeight(WIZARDHEIGHT);

		listeners = new ArrayList<WizardListener>();

		setHeadingText(title);
		this.originalTitle = title;
		
		VerticalLayoutContainer container = new VerticalLayoutContainer();

		cardContainer = new CardLayoutContainer();
		container.add(cardContainer, new VerticalLayoutData(1, 1));

		ToolBar toolbar = new ToolBar();  
		toolbar.addStyleName(ThemeStyles.getStyle().borderTop());

		backButton = new TextButton(BUTTONBACKLABEL);  
		backButton.setEnabled(false);
		backButton.setVisible(false);
		backButton.setTabIndex(1001);
		toolbar.add(backButton);  
		toolbar.add(new FillToolItem());  

		nextButton = new TextButton(BUTTONNEXTLABEL); 
		nextButton.setEnabled(false);
		nextButton.setTabIndex(1000);
		toolbar.add(nextButton);  

		toolbar.setLayoutData(new VerticalLayoutData(1, -1));
		container.add(toolbar);

		SelectHandler selectionHandler = new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				TextButton button = (TextButton)event.getSource();
				String btnID = button.getId();  

				if (btnID.equals(backButton.getId())) {  
					
					if(previousButtonAction!=null) {
						previousButtonAction.execute(); 
					}
					else {
						previousCard();
					}
				} else {  

					if (nextButtonAction!=null) {
						nextButtonAction.execute();
					} else {
						nextCard();
					}
				}

			}  
		};  

		backButton.addSelectHandler(selectionHandler);
		nextButton.addSelectHandler(selectionHandler);	
		
		
		setWidget(container);
	}


	

	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();
		
		closeBtn.addSelectHandler(new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				fireAborted();
				hide();
			}
		});

	}

	public void addListener(WizardListener listener)
	{
		listeners.add(listener);
	}
	
	public void removeListener(WizardListener listener)
	{
		listeners.remove(listener);
	}

	/**
	 * Shows the next available card.
	 */
	public void nextCard()
	{

		if (finish) {
			callCardSetup();
			finishCommand.execute();
		} else {
			Widget activeItem = cardContainer.getActiveWidget();

			if (activeItem instanceof WizardCard)
				((WizardCard) activeItem).dispose();
			
			int cardPos = cardStack.indexOf(activeItem);

			// NEXT ->

			nextButton.setEnabled(true);
			backButton.setEnabled(true);

			int newPos = cardPos + 1;

			if (newPos == 0) {
				// we are moving forward from the first card
				backButton.setEnabled(false);
			}
			nextButtonAction = null;
			previousButtonAction = null;
			Log.info("cardStack size:" + cardStack.size());
			if (newPos < cardStack.size()) {
				WizardCard card = cardStack.get(newPos);
				cardContainer.setActiveWidget(card);
				doLayout();
				card.setup();
			} else {
				close(false);
			}
		}
	}
	
	private void callCardSetup(){
		cardStack.get(cardStack.indexOf(cardContainer.getActiveWidget())).setup();
	}

	/**
	 * Shows the previous available card.
	 */
	public void previousCard()
	{
		Widget activeItem = cardContainer.getActiveWidget();

		if (activeItem instanceof WizardCard) ((WizardCard)activeItem).dispose();

		int cardPos = cardStack.indexOf(activeItem);

		//BACK <-

		nextButton.setEnabled(true);
		backButton.setEnabled(true);

		int newPos=cardPos-1;			
		
		
		if (newPos == 0) {  
			backButton.setEnabled(false);
		}  

		nextButtonAction=null;
		previousButtonAction=null;
		
		WizardCard card = cardStack.get(newPos);
		cardContainer.setActiveWidget(card);
		doLayout();
		
		card.setup();
	}

	/**
	 * Returns the number of available cards.
	 * @return
	 */
	public int getCardStackSize()
	{
		return cardStack.size();
	}

	/**
	 * Returns the current active card.
	 * @return
	 */
	public int getCurrentCard()
	{
		return cardStack.indexOf(cardContainer.getActiveWidget());
	}

	public boolean checkBeforeClose()
	{
		return true;
	}

	public void close(boolean check) {
		checkBeforeClose = check;
		hide();
	}

	/**
	 * Sets the label of next button to "Finish" value and add a close command to it.
	 */
	public void setNextButtonToFinish()
	{
		finish=true;
		nextButton.setText(BUTTONFINISHLABEL);
		
	}
	
	/**
	 * 
	 * @param finishCommand
	 */
	public void setFinishCommand(Command finishCommand) {
		this.finishCommand = finishCommand;
	}
	
	/**
	 * Set the command for the next button.
	 * @param command the command to execute.
	 */
	public void setNextButtonCommand(Command command)
	{
		nextButtonAction = command;
	}
	
	
	/**
	 * Set the command for the previous button.
	 * @param command the command to execute.
	 */
	public void setPreviousButtonCommand(Command command)
	{
		previousButtonAction = command;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void show() {
		super.show();

		Widget activeItem = cardContainer.getActiveWidget();

		if (activeItem instanceof WizardCard) ((WizardCard)activeItem).setup();
		
	}



	/**
	 * Set the card list.
	 * @param cards
	 */
	public void setCards(ArrayList<WizardCard> cards)
	{
		for (WizardCard card:cards) {
			addCard(card);
		}
	}

	/**
	 * Adds a card to this wizard.
	 * @param card the card to add.
	 */
	public void addCard(WizardCard card)
	{
		card.setWizardWindow(this);
		cardContainer.add(card);
		cardStack.add(card);
	}

	/**
	 * Remove a card to this wizard.
	 * @param card the card to add.
	 */
	public void removeCard(WizardCard card)
	{
		cardContainer.remove(card);
		cardStack.remove(card);
	}


	/**
	 * Enables the next button on the wizard.
	 * @param enable <code>true</code> to enable the next button, <code>false</code> otherwise.
	 */
	public void setEnableNextButton(boolean enable)
	{
		nextButton.setEnabled(enable);
	}

	/**
	 * Enables the back button on the wizard.
	 * @param enable <code>true</code> to enable the back button, <code>false</code> otherwise.
	 */
	public void setEnableBackButton(boolean enable)
	{
		backButton.setEnabled(enable);
	}

	/**
	 * Sets the next button label.
	 * @param text the button label.
	 */
	protected void setNextButtonText(String text)
	{
		nextButton.setText(text);
		
	}
	
	/**
	 * Sets the back button label.
	 * @param text the button label.
	 */
	protected void setBackButtonText(String text)
	{
		backButton.setText(text);
	}
	
	/**
	 * Sets visible next button.
	 * @param visible
	 */
	protected void setNextButtonVisible(boolean visible)
	{
		nextButton.setVisible(visible);	
	}
	
	/**
	 * Sets visible back button.
	 * @param visible
	 */
	protected void setBackButtonVisible(boolean visible)
	{
		backButton.setVisible(visible);	
	}


	/**
	 * Add a listener to the next button.
	 * @param listener the listener to add.
	 */
	protected void addNextButtonListener(SelectHandler listener)
	{
		nextButton.addSelectHandler(listener);
	}

	/**
	 * @return the originalTitle
	 */
	public String getOriginalTitle() {
		return originalTitle;
	}

	/**
	 * Returns the card list.
	 * @return teh card list.
	 */
	public ArrayList<WizardCard> getCardStack()
	{
		return cardStack;
	}

	public void showErrorAndHide(String title, final String failureReason, final String failureDetails, final Throwable throwable)
	{
		ErrorMessageBox.showError(title, failureReason, failureDetails, new Callback<Dialog, Void>() {
			
			@Override
			public void onSuccess(Dialog result) {
			}
			
			@Override
			public void onFailure(Void reason) {
				hide();
				fireFailed(throwable, failureReason, failureDetails);
			}
		});
	}

	public void fireCompleted(TRId trId)
	{
		for (WizardListener listener:listeners) listener.completed(trId);
	}

	public void fireAborted()
	{
		for (WizardListener listener:listeners) listener.aborted();
	}

	public void fireFailed(Throwable throwable, String reason, String details)
	{
		for (WizardListener listener:listeners) listener.failed(throwable, reason, details);
	}
}
