/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client.util;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.Label;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.Dialog.PredefinedButton;
import com.sencha.gxt.widget.core.client.box.MessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ErrorMessageBox {


	private static final String DETAILS = "Details";

	
	public static void showError(String title, String failureReason, final String failureDetails)
	{
		showError(title, failureReason, failureDetails, new NOPCallBack<Dialog, Void>());
	}
	
	public static void showError(String title, String failureReason, final String failureDetails, final Callback<Dialog, Void> callback)
	{
		final MessageBox box = new MessageBox(title);
		box.setMessage(failureReason);
		box.addHideHandler(new HideHandler() {
			
			@Override
			public void onHide(HideEvent event) {
				Dialog dialog = (Dialog) event.getSource();
				
				if (dialog.getHideButton().getText().equals(DETAILS)){
				    //box.close();
				    showErrorDetails("Error details", failureDetails);
				} else callback.onSuccess(dialog);
			}
		});
		/*FIXME box.setIcon(MessageBox.ERROR);
		box.getDialog().cancelText = DETAILS;
		box.getDialog().setButtons(MessageBox.OKCANCEL);*/
		box.show();
	}
	
	public static void showErrorDetails(String title, String failureDetails)
	{
	    final Dialog simple = new Dialog();  
	    simple.setHeadingText(title);  
	    simple.setPredefinedButtons(PredefinedButton.OK);  
	    simple.setBodyStyleName("pad-text");  
	    
	    
	    simple.add(new Label("<PRE>"+failureDetails+"</PRE>"));  
	    //simple.getItem(0).getFocusSupport().setIgnore(true);
	    
	    //FIXME simple.setScrollMode(ScrollMode.AUTO);
	    
	    simple.setHideOnButtonClick(true);
	    simple.setWidth(400);
	    simple.setHeight(400);
	    simple.show();
	}

}
