/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.wizardwidget.client.WizardCard;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.widget.core.client.Dialog.PredefinedButton;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.box.ConfirmMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TabResourcesSelectionCard extends WizardCard {

	protected TabResourcesSelectionCard thisCard;
	protected TRId trId;
	protected TDOpenSession tdOpenSession;
	protected TabResourcesSelectionPanel tabResourcesSelectionPanel;
	protected TabResource selectedTabResource = null;

	public TabResourcesSelectionCard(TRId trId,
			final TDOpenSession tdOpenSession) {
		super("Select a Tabular Resource", "");
		Log.debug("TabResourcesSelectionCard");
		this.tdOpenSession = tdOpenSession;
		thisCard = this;
		this.trId = trId;

		tabResourcesSelectionPanel = new TabResourcesSelectionPanel(thisCard,
				res);

		tabResourcesSelectionPanel
				.addSelectionHandler(new SelectionHandler<TabResource>() {

					public void onSelection(SelectionEvent<TabResource> event) {
						tdOpenSession
								.setSelectedTabResource(tabResourcesSelectionPanel
										.getSelectedItem());
						getWizardWindow().setEnableNextButton(true);
					}

				});

		setContent(tabResourcesSelectionPanel);

	}

	@Override
	public void setup() {
		Command sayFinish = new Command() {

			public void execute() {
				retrieveLastTable();
			}

		};

		getWizardWindow().setNextButtonCommand(sayFinish);
		// getWizardWindow().setFinishCommand(sayFinish);

	}

	protected void retrieveLastTable() {
		TDGWTServiceAsync.INSTANCE.getLastTable(tdOpenSession
				.getSelectedTabResource().getTrId(),
				new AsyncCallback<TableData>() {

					@Override
					public void onFailure(Throwable caught) {
						Log.debug("Attention",
								"This tabular resource does not have a valid table");
						AlertMessageBox d = new AlertMessageBox("Attention",
								"This tabular resource does not have a valid table");
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {
								deleteTRWithLastTableNull();

							}
						});
						d.show();

					}

					@Override
					public void onSuccess(TableData result) {
						Log.debug("Retrieve last table: " + result);
						updateTDOpenSessionInfo(result);
					}

				});

	}

	protected void deleteTRWithLastTableNull() {
		final ConfirmMessageBox mb = new ConfirmMessageBox("Delete",
				"Would you like to delete this tabular resource without table?");
		mb.addHideHandler(new HideHandler() {
			public void onHide(HideEvent event) {
				if (mb.getHideButton() == mb.getButtonById(PredefinedButton.YES
						.name())) {
					callDeleteLastTable();
				} else if (mb.getHideButton() == mb
						.getButtonById(PredefinedButton.NO.name())) {
					// perform NO action
				}
			}
		});
		mb.setWidth(300);
		mb.show();

	}

	protected void callDeleteLastTable() {
		Log.debug("Delete TR:"
				+ tdOpenSession.getSelectedTabResource().getTrId());
		TDGWTServiceAsync.INSTANCE.removeTabularResource(tdOpenSession
				.getSelectedTabResource().getTrId(), new AsyncCallback<Void>() {

			public void onFailure(Throwable caught) {
				AlertMessageBox d = new AlertMessageBox("Error",
						"Error on delete TabResource: "
								+ caught.getLocalizedMessage());
				d.addHideHandler(new HideHandler() {

					public void onHide(HideEvent event) {
						// TODO Auto-generated method stub

					}
				});
				d.show();

			}

			public void onSuccess(Void result) {
				Log.debug("Remove tabular resource success");
				Log.debug("Check current tr for close: "+trId);
				if (trId!=null && trId.getId()!=null && trId.getId().compareTo(
						tdOpenSession.getSelectedTabResource().getTrId()
								.getId()) == 0) {
					Log.debug("Fire Close Event on current TR");
					getEventBus().fireEvent(new RibbonEvent(RibbonType.CLOSE));
				} else {
					Log.debug("No tr opened");
				}
				tabResourcesSelectionPanel.gridReload();
			}

		});
	}

	protected void updateTDOpenSessionInfo(TableData table) {
		TabResource tabResource = tdOpenSession.getSelectedTabResource();
		tabResource.setTrId(table.getTrId());
		tdOpenSession.setSelectedTabResource(tabResource);
		Log.debug("TdOpenSession: " + tdOpenSession);
		setTabularResource();
	}

	protected void setTabularResource() {
		TDGWTServiceAsync.INSTANCE.setTabResource(
				tdOpenSession.getSelectedTabResource(),
				new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						AlertMessageBox d = new AlertMessageBox("Error",
								"Error on set TabResource: "
										+ caught.getLocalizedMessage());
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {
								// TODO Auto-generated method stub

							}

						});
						d.show();

					}

					public void onSuccess(Void result) {
						getWizardWindow().fireCompleted(
								tdOpenSession.getSelectedTabResource()
										.getTrId());
						getWizardWindow().close(false);
						Log.info("OpenTD Tabular Resource selected :"
								+ tdOpenSession.getSelectedTabResource());
					}

				});

	}

}
