/**
 * 
 */
package org.gcube.portlets.user.td.resourceswidget.client.save;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.SaveResourceSession;
import org.gcube.portlets.user.td.resourceswidget.client.workspace.WorkspacePanel;
import org.gcube.portlets.user.td.wizardwidget.client.WizardCard;
import org.gcube.portlets.widgets.lighttree.client.Item;
import org.gcube.portlets.widgets.lighttree.client.ItemType;
import org.gcube.portlets.widgets.lighttree.client.event.ItemSelectionEvent;
import org.gcube.portlets.widgets.lighttree.client.event.ItemSelectionHandler;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Command;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.form.validator.EmptyValidator;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class WorkSpaceSelectionCard extends WizardCard {

	protected SaveResourceSession saveResourceSession;
	protected WorkSpaceSelectionCard thisCard;
	protected TextField fileName;
	protected TextField fileDescription;

	protected Item item;
	protected VerticalLayoutContainer p;
	protected WorkspacePanel wpanel;

	public WorkSpaceSelectionCard(final SaveResourceSession saveResourceSession) {
		super("Save in Workspace", "");

		this.saveResourceSession = saveResourceSession;
		thisCard = this;

		FramedPanel formPanel = new FramedPanel();
		formPanel.setHeaderVisible(false);
		p = new VerticalLayoutContainer();
		formPanel.setWidget(p);

		fileName = new TextField();
		fileName.setAllowBlank(false);
		fileName.addValidator(new EmptyValidator<String>());
		fileName.setWidth("410px");
		fileName.setValue(saveResourceSession.getFileName());
		
		
		p.add(new FieldLabel(fileName, "Name"), new VerticalLayoutData(-1,
				-1));

		fileDescription = new TextField();
		fileDescription.setAllowBlank(false);
		fileDescription.addValidator(new EmptyValidator<String>());
		fileDescription.setWidth("410px");
		fileDescription.setValue(saveResourceSession.getFileDescription());
		p.add(new FieldLabel(fileDescription, "Description"),
				new VerticalLayoutData(-1, -1));

		Log.debug("Set Workspace Panel");
		wpanel = new WorkspacePanel();
		wpanel.setSpWidth("410px");
		wpanel.setSpHeight("330px");
		List<ItemType> lItemType = new ArrayList<ItemType>();
		lItemType.add(ItemType.ROOT);
		lItemType.add(ItemType.FOLDER);
		wpanel.setShowableTypes(lItemType);
		wpanel.setSelectableTypes(lItemType);
		wpanel.addSelectionHandler(new ItemSelectionHandler() {

			public void onSelection(ItemSelectionEvent event) {
				item = event.getSelectedItem();
				Log.debug("Selected Item:" + item);
				if (item.getType() == ItemType.FOLDER
						|| item.getType() == ItemType.ROOT) {
					thisCard.saveResourceSession.setItemId(item.getId());
				} else {
					thisCard.saveResourceSession.setItemId(null);
					Log.debug("Item type:" + item.getType());
				}
			}
		});
		p.add(new FieldLabel(wpanel, "Folder"), new VerticalLayoutData(-1, -1));
		wpanel.loadTree();
		setContent(formPanel);

	}

	protected void checkExportData() {
		Log.debug("File Name:" + fileName.getCurrentValue() + " Item id: "
				+ saveResourceSession.getItemId());
		wpanel.disable();
		fileName.disable();
		getWizardWindow().setEnableNextButton(false);
		getWizardWindow().setEnableBackButton(false);
		AlertMessageBox d;
		HideHandler hideHandler = new HideHandler() {

			public void onHide(HideEvent event) {
				wpanel.enable();
				getWizardWindow().setEnableNextButton(true);
				getWizardWindow().setEnableBackButton(true);
				fileName.enable();
			}
		};
		if (fileName.getCurrentValue() != null
				&& !fileName.getCurrentValue().isEmpty() && fileName.validate()) {
			if (fileDescription.getCurrentValue() != null
					&& !fileDescription.getCurrentValue().isEmpty()
					&& fileDescription.validate()) {

				if (saveResourceSession.getItemId() != null) {
					saveResourceSession.setFileName(fileName.getCurrentValue());
					saveResourceSession.setFileDescription(fileDescription
							.getCurrentValue());
					goNext();
				} else {
					d = new AlertMessageBox("Attention", "No folder selected");
					d.addHideHandler(hideHandler);
					d.setModal(false);
					d.show();

				}
			} else {
				d = new AlertMessageBox("Attention",
						"No valid file description");
				d.addHideHandler(hideHandler);
				d.setModal(false);
				d.show();

			}
		} else {
			d = new AlertMessageBox("Attention", "No valid file name");
			d.addHideHandler(hideHandler);
			d.setModal(false);
			d.show();
		}

	}

	@Override
	public void setup() {
		Log.debug("WorkSpaceSelectionCard Call Setup ");
		Command sayNextCard = new Command() {

			public void execute() {
				Log.debug("WorkSpaceSelectionCard Call sayNextCard:" + wpanel);
				checkExportData();
			}

		};

		getWizardWindow().setNextButtonCommand(sayNextCard);

		Command sayPreviousCard = new Command() {
			public void execute() {
				try {
					getWizardWindow().previousCard();
					getWizardWindow().removeCard(thisCard);
					Log.debug("Remove WorkSpaceSelectionCard");
				} catch (Exception e) {
					Log.error("sayPreviousCard :" + e.getLocalizedMessage());
				}
			}
		};

		getWizardWindow().setPreviousButtonCommand(sayPreviousCard);
		getWizardWindow().setEnableNextButton(true);
		getWizardWindow().setEnableBackButton(true);

	}

	protected void goNext() {
		OperationInProgressCard csvOperationInProgressCard = new OperationInProgressCard(
				saveResourceSession);
		getWizardWindow().addCard(csvOperationInProgressCard);
		Log.info("NextCard OperationInProgressCard");
		getWizardWindow().nextCard();
	}

}
