package org.gcube.portlets.user.td.tablewidget.client.template;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TemplateDeleteDialog  extends Window {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";
	protected TemplateDeleteSession templateDeleteSession;
	protected EventBus eventBus;
	
	public TemplateDeleteDialog(EventBus eventBus) {
		this.eventBus=eventBus;
		initWindow();
		
		TemplateDeletePanel templateDeletePanel= new TemplateDeletePanel(this, eventBus);
		add(templateDeletePanel); 
	}
	
	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Delete Template");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ResourceBundle.INSTANCE.templateDelete());

	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			
			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}
	
	protected void close (){
		hide();
	}
	
	
	protected void templatesDelete(final TemplateDeleteSession templateDeleteSession){	
		this.templateDeleteSession=templateDeleteSession;
		
		TDGWTServiceAsync.INSTANCE.startTemplateDelete(templateDeleteSession,
				new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						Log.debug("Delete Template Error: "
								+ caught.getLocalizedMessage());
						UtilsGXT3.alert("Apply Template Error ",
								"Error in invocation of delete template operation!");

					}

					public void onSuccess(Void result) {
						UtilsGXT3.info("Delete Template",
								"Template deleted!");

					}

				});
		
	
	}
	
	
}
