package org.gcube.portlets.user.td.tablewidget.client;



import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.tablewidget.client.progress.ChangeTableTypeProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.type.TableTypeElement;
import org.gcube.portlets.user.td.tablewidget.client.type.TableTypeProperties;
import org.gcube.portlets.user.td.tablewidget.client.type.TableTypeStore;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ChangeTableTypePanel  extends FramedPanel {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";
	
	protected TRId trId;
	protected TableData table;
	protected String headingTitle;
	protected VerticalLayoutContainer vl;
	protected EventBus eventBus;
	protected ChangeTableTypeSession changeTableTypeSession;
	protected ChangeTableTypeProgressDialog changeTableTypeProgressDialog; 
	
	protected ComboBox<TableTypeElement> comboTableType;
	protected TextButton change;

	
	
	public ChangeTableTypePanel(TRId trId, EventBus eventBus) {
		super();
		this.trId=trId;
		this.eventBus = eventBus;
		forceLayoutOnResize=true;
		create();
	}
	
	protected void create(){
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		
		
		TableTypeProperties props = GWT.create(TableTypeProperties.class);
		ListStore<TableTypeElement> storeTableType = new ListStore<TableTypeElement>(props.id());
	
		storeTableType.addAll(TableTypeStore.getTableTypes());
		
		Log.trace("Store created");

		comboTableType = new ComboBox<TableTypeElement>(storeTableType,
				props.label());

		Log.trace("ComboTableType created");

		
		comboTableType.setEmptyText("Select a Table Type...");
		comboTableType.setItemId("ComboTableType");
		comboTableType.setWidth("200px");
		comboTableType.setEditable(false);
		comboTableType.setTriggerAction(TriggerAction.ALL);

		 
		change=new TextButton("Change");
		change.addSelectHandler(new SelectHandler() {
			
			public void onSelect(SelectEvent event) {
				onChangeTableType();
				
			}
		});
		
		vl = new VerticalLayoutContainer();
		vl.setScrollMode(ScrollMode.AUTO);
		vl.setAdjustForScroll(true);

		
		vl.add(new FieldLabel(comboTableType, "Table Type"), new VerticalLayoutData(1,
				-1));
		vl.add(change, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		
		add(vl);
		show();
		load();
		
	}
	
	protected void onChangeTableType(){
		TableTypeElement tableTypeElement = comboTableType.getCurrentValue();
		if(tableTypeElement!=null){
			changeTableTypeSession=new ChangeTableTypeSession(trId,tableTypeElement.getTableType());
			callChangeTableType();
		} else {
			UtilsGXT3.alert("Attention", "Select a table type!");
		}
	}
	
	private void callChangeTableType() {
		TDGWTServiceAsync.INSTANCE.startChangeTableType(
				changeTableTypeSession, new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						Log.debug("Change The Table Type Error: "
								+ caught.getLocalizedMessage());
						UtilsGXT3.alert("Error Changing The Table Type",
								"Error in invocation of Change Table Type operation!");

					}

					public void onSuccess(Void result) {
						changeTableTypeProgressDialog= new ChangeTableTypeProgressDialog(changeTableTypeSession, eventBus);
					}

				});

	}
	
	
	protected void setCurrentType(){
		TableTypeElement tElement=TableTypeStore.getTableTypeElement(table.getTypeName());
		comboTableType.setValue(tElement); 
		
	}
	
	
	private void load() {
		TDGWTServiceAsync.INSTANCE.getTable(trId,
				new AsyncCallback<TableData>() {

					public void onFailure(Throwable caught) {
						Log.error("Error retrieving table: "
								+ caught.getMessage());
						UtilsGXT3.alert("Error retrieving table",caught.getMessage());
					}

					public void onSuccess(TableData result) {
						Log.debug("Retrieved table: "+result.toString());
						table=result;
						setCurrentType();
						
					}

				});

	}
	
	
	
	public void update(TRId trId) {
		this.trId = trId;
		load();
	}
	
	
}
	