package org.gcube.portlets.user.td.tablewidget.client.template;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

public class TemplateDeletePanel extends FramedPanel {
	protected String WIDTH = "560px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected TemplateDeleteDialog parent;
	protected TemplateDeleteSession templateDeleteSession;

	private TextButton btnDelete;
	private TextButton btnClose;

	protected ListLoader<ListLoadConfig, ListLoadResult<TemplateData>> loader;
	protected Grid<TemplateData> grid;
	protected ListStore<TemplateData> store;

	public TemplateDeletePanel(TemplateDeleteDialog parent,
			EventBus eventBus) {
		this.parent = parent;
		Log.debug("TemplateDeletePanel");
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		this.eventBus = eventBus;

		create();

	}

	protected void create() {

		IdentityValueProvider<TemplateData> identity = new IdentityValueProvider<TemplateData>();
		CheckBoxSelectionModel<TemplateData> sm = new CheckBoxSelectionModel<TemplateData>(
				identity);

		TemplateDataProperties props = GWT.create(TemplateDataProperties.class);

		ColumnConfig<TemplateData, String> nameCol = new ColumnConfig<TemplateData, String>(
				props.name(), 120, "Name");
		ColumnConfig<TemplateData, String> agencyCol = new ColumnConfig<TemplateData, String>(
				props.agency(), 120, "Agency");

		ColumnConfig<TemplateData, String> descriptionCol = new ColumnConfig<TemplateData, String>(
				props.description(), 160, "Description");

		List<ColumnConfig<TemplateData, ?>> l = new ArrayList<ColumnConfig<TemplateData, ?>>();
		l.add(nameCol);
		l.add(agencyCol);
		l.add(descriptionCol);

		ColumnModel<TemplateData> cm = new ColumnModel<TemplateData>(l);

		store = new ListStore<TemplateData>(props.id());

		RpcProxy<ListLoadConfig, ListLoadResult<TemplateData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<TemplateData>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<TemplateData>> callback) {
				loadData(loadConfig, callback);
			}
		};
		loader = new ListLoader<ListLoadConfig, ListLoadResult<TemplateData>>(
				proxy);

		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, TemplateData, ListLoadResult<TemplateData>>(
				store) {
		});

		grid = new Grid<TemplateData>(store, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {

					public void execute() {
						loader.load();
					}
				});
			}
		};

		sm.setSelectionMode(SelectionMode.MULTI);
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		grid.setHeight("418px");
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.getView().setAutoFill(true);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);
		grid.setColumnResize(true);
		grid.getView().setAutoExpandColumn(descriptionCol);

		ToolBar toolBar = new ToolBar();
		toolBar.add(grid);
		toolBar.addStyleName(ThemeStyles.getStyle().borderTop());
		toolBar.getElement().getStyle().setProperty("borderBottom", "none");

		btnDelete = new TextButton("Delete");
		btnDelete.setIcon(ResourceBundle.INSTANCE.templateDelete());
		btnDelete.setIconAlign(IconAlign.RIGHT);
		btnDelete.setTitle("Delete Template");
		btnDelete.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Deletee");
				delete();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ResourceBundle.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Cancel filter");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		flowButton.add(btnDelete, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(grid, new VerticalLayoutData(-1, -1, new Margins(0)));
		v.add(toolBar, new VerticalLayoutData(1, 25, new Margins(0)));
		v.add(flowButton, new VerticalLayoutData(-1, 36,
				new Margins(5, 2, 5, 2)));
		add(v);

	}

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<TemplateData>> callback) {

		TDGWTServiceAsync.INSTANCE
				.getTemplates(new AsyncCallback<ArrayList<TemplateData>>() {

					public void onFailure(Throwable caught) {
						Log.error("load templates failure:"
								+ caught.getLocalizedMessage());
						UtilsGXT3.alert("Error retrieving templates",
								"Error retrieving templates");
						callback.onFailure(caught);
					}

					public void onSuccess(ArrayList<TemplateData> result) {
						Log.trace("loaded " + result.size() + " Occurences");
						callback.onSuccess(new ListLoadResultBean<TemplateData>(
								result));

					}

				});

	}

	/*protected void setMenu() {
		Menu contextMenu = new Menu();

		MenuItem deleteTemplateItem = new MenuItem("Delete");
		deleteTemplateItem.setId("DeleteTemplate");
		deleteTemplateItem.setIcon(ResourceBundle.INSTANCE.removeTemplate());
		deleteTemplateItem.addSelectionHandler(new SelectionHandler<Item>() {

			@Override
			public void onSelection(SelectionEvent<Item> event) {
				Log.debug("Delete Template");
				TemplateData templateDesc = getSelectedItem();

			}
		});

		grid.setContextMenu(contextMenu);
	}*/

	protected ArrayList<TemplateData> getSelectedItem() {
		ArrayList<TemplateData> templates=new ArrayList<TemplateData>();
		for(TemplateData template:grid.getSelectionModel().getSelectedItems()){
			templates.add(template);
		}
		return templates;
	}

	protected void delete() {
		templateDeleteSession = new TemplateDeleteSession();
		ArrayList<TemplateData> templates=getSelectedItem();
		if(templates==null|| templates.size()==0){
			UtilsGXT3.info("Attention",
					"Select the template to be deleted");
		} else {
			templateDeleteSession.setTemplates(getSelectedItem());
			Log.debug("templateDeleteSession: " + templateDeleteSession);
			parent.templatesDelete(templateDeleteSession);

		}
		
	}

	protected void close() {
		parent.close();
	}

}
