/**
 * 
 */
package org.gcube.portlets.user.td.tablewidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class DuplicatesRowsProgressUpdater extends Timer {

	protected ArrayList<DuplicatesRowsProgressListener> listeners = new ArrayList<DuplicatesRowsProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getDuplicatesMonitor(new AsyncCallback<DuplicatesMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(DuplicatesMonitor result) {
						Log.info("retrieved DuplicatesMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationUpdate(result.getProgress());
							break;	
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(DuplicatesMonitor result) {
		Log.info("Operation on duplicates Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Operation on duplicates";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Operation on duplicates";
			details = "Operation on duplicates failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(DuplicatesMonitor result) {
		Log.info("Operation on duplicates Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped operation on duplicates";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped operation on duplicates";
			details = "Operation on duplicates stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (DuplicatesRowsProgressListener listener : listeners)
			listener.operationInitializing();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (DuplicatesRowsProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (DuplicatesRowsProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (DuplicatesRowsProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (DuplicatesRowsProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link DuplicatesRowsProgressListener} to this
	 * {@link DuplicatesRowsProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(DuplicatesRowsProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link DuplicatesRowsProgressListener} from this
	 * {@link DuplicatesRowsProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(DuplicatesRowsProgressListener listener) {
		listeners.remove(listener);
	}
}
