package org.gcube.portlets.user.td.tablewidget.client.template;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.tablewidget.client.progress.TemplateApplyProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TemplateApplyDialog  extends Window {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";
	protected TemplateApplySession templateApplySession;
	protected TRId trId;
	protected EventBus eventBus;
	
	public TemplateApplyDialog(TRId trId, EventBus eventBus) {
		this.trId=trId;
		this.eventBus=eventBus;
		initWindow();
		
		TemplateApplyPanel templateApplyPanel= new TemplateApplyPanel(this,trId, eventBus);
		add(templateApplyPanel); 
	}
	
	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Apply Template");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ResourceBundle.INSTANCE.templateApply());

	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			
			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}
	
	protected void close (){
		hide();
	}
	
	
	protected void applyTemplate(final TemplateApplySession templateApplySession){	
		this.templateApplySession=templateApplySession;
		
		TDGWTServiceAsync.INSTANCE.startTemplateApply(templateApplySession,
				new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						Log.debug("Apply Template Error: "
								+ caught.getLocalizedMessage());
						UtilsGXT3.alert("Apply Template Error ",
								"Error in invocation of apply template operation!");

					}

					public void onSuccess(Void result) {
						callApplyTemplateProgressDialog();
					}

				});
		
	
	}

	
	

	protected void callApplyTemplateProgressDialog() {
		TemplateApplyProgressDialog d = new TemplateApplyProgressDialog(
				this, eventBus);
		d.show();
	}
	
	
	
	
	
}
