/**
 * 
 */
package org.gcube.portlets.user.td.taskswidget.server.service;

import java.io.Serializable;
import java.util.List;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Dec 4, 2013
 * 
 */
public class TaskTabularDataService implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1803960635546100029L;

	public static Logger logger = LoggerFactory.getLogger(TaskTabularDataService.class);

	private String scope;
	private TabularDataService tabularDataService;
	private String username;

	public TaskTabularDataService(String scope, String username) throws Exception {
		this.scope = scope;
		
		try {
			logger.trace("Instancing tabular data service factory with scope: "+ scope + " and user: " + username);
			ScopeProvider.instance.set(scope);
			this.username = username;
			this.tabularDataService = TabularDataServiceFactory.getService();
//			this.tabularDataService = TabularDataServiceFactory.getService(username);
		} catch (Exception e) {
			logger.error("Error on instancing Tabular Data Service Client", e);
			this.tabularDataService = null;
			throw new Exception("Tabular data service is null");
		}
	}

	public TabularDataService getTabularDataService() {
		return tabularDataService;
	}

	public String getScope() {
		return scope;
	}

	/**
	 * @param currentTabularResource
	 * @return
	 * @throws NoSuchTabularResourceException 
	 */
	public List<Task> getTasks(TabularResourceId currentTabularResource) throws NoSuchTabularResourceException {
		ScopeProvider.instance.set(scope);
		return tabularDataService.getTasks(currentTabularResource);
	}

	/**
	 * @param operationId
	 * @return
	 * @throws NoSuchTaskException 
	 */
	public Task getTask(TaskId operationId) throws NoSuchTaskException {
		ScopeProvider.instance.set(scope);
		return tabularDataService.getTask(operationId);
	}

	/**
	 * @return
	 */
	public List<OperationDefinition> getCapabilities() {
		AuthorizationProvider.instance.set(new AuthorizationToken(username));
		ScopeProvider.instance.set(scope);
		return tabularDataService.getCapabilities();
	}

	/**
	 * @return
	 */
	public List<TabularResource> getTabularResources() {
		AuthorizationProvider.instance.set(new AuthorizationToken(username));
		ScopeProvider.instance.set(scope);
		return tabularDataService.getTabularResources();
	}
	

	/**
	 * 
	 * @param operationId
	 * @return
	 * @throws NoSuchOperationException
	 */
	public OperationDefinition getOperationDescriptionById(long operationId) throws NoSuchOperationException {
		ScopeProvider.instance.set(scope);
		return tabularDataService.getCapability(operationId);
		
	}


}
