package org.gcube.portlets.user.td.taskswidget.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.gwtservice.server.TDGWTServiceImpl;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.taskswidget.client.rpc.TdTasksWidgetService;
import org.gcube.portlets.user.td.taskswidget.server.exception.TdConverterException;
import org.gcube.portlets.user.td.taskswidget.server.service.TaskTabularDataService;
import org.gcube.portlets.user.td.taskswidget.server.session.SessionUtil;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdJobModel;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdOperationModel;
import org.gcube.portlets.user.td.taskswidget.shared.job.TdTaskModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class TdTasksWidgetServiceImpl extends RemoteServiceServlet implements TdTasksWidgetService {

	public static Logger logger = LoggerFactory.getLogger(TdTasksWidgetServiceImpl.class);
	public TDGWTServiceImpl gwtServiceInstance = null;
//	public static int fakeCacheSize = 50;  //TODO FAKE CODE
	

	/* (non-Javadoc)
	 * @see javax.servlet.GenericServlet#init()
	 */
	
	protected TaskTabularDataService getTabularDataServiceClient() {
		
		try {
			ASLSession aslSession = getASLSession();
			TaskTabularDataService serviceClient = SessionUtil.getTaskTdServiceClient(aslSession);
			
			if(serviceClient==null){
				serviceClient = new TaskTabularDataService(aslSession.getScope(), aslSession.getUsername());
				SessionUtil.setTaskServiceClient(aslSession,serviceClient);
			}

			return serviceClient;
			
		}catch (Exception e) {
			logger.error("Error on get Tabular Data Service Client", e);
		}
		
		return null;
	}
	
	/**
	 * Use this to get GWT service instance after servlet init
	 * @return
	 */
	protected TDGWTServiceImpl getGWTServiceInstance(){
		if(gwtServiceInstance==null)
			gwtServiceInstance = new TDGWTServiceImpl();
		
		return gwtServiceInstance;
	}

	
	/**
	 * 
	 * @return
	 */
	protected ASLSession getASLSession() {
		return SessionUtil.getAslSession(this.getThreadLocalRequest().getSession());
	}

	
	/**
	 * @return
	 * @throws Exception 
	 */
	protected TabularResourceId getCurrentTabularResource() throws Exception {

		try {
			
			logger.trace("Get current tabular resource..");
			System.out.println("Get current tabular resource..");
			
			HttpSession httpSession = this.getThreadLocalRequest().getSession();
			
			TabResource currentTabulaResource = org.gcube.portlets.user.td.gwtservice.server.SessionUtil.getTabResource(httpSession);
			
//			TabResource currentTabulaResource = gwtTdService.getTabResourceInformation(httpSession);
			int id = Integer.parseInt(currentTabulaResource.getTrId().getId());
			
			logger.trace("Found current tabular resource TR id: "+id+", returning");
			System.out.println("Found current tabular resource TR id: "+id+", returning");
			return new TabularResourceId(id);
			
		
		} catch (Exception e) {
			logger.error("Error on get current tabula resource",e);
			throw new Exception("Error on recovering current tabular resource");
		}

		//TODO FAKE CODE
//		return new TabularResourceId(6);
	}

	@Override
	public int countTdTasksFromCache() throws Exception{
		
//		/***********************FAKE CODE*******************************/
//		
//		return fakeCacheSize;
//		
//		/***********************END FAKE CODE*************************/
		
		logger.trace("Get tabular data - cache tasks size");
		HashMap<String, TdTaskModel> cacheTasks;
		
		try{
			ASLSession aslSession = getASLSession();
			cacheTasks = SessionUtil.getTasksCache(aslSession);
			
			if(cacheTasks==null){
				logger.warn("Cache is empty, returning size 0");
				return 0;
			}
			
			}catch (Exception e) {
				logger.error("Error on count cached tasks",e);
				return 0;
			}
		
		return cacheTasks!=null?cacheTasks.size():0;
	}

	@Override
	public List<TdTaskModel> getTdTasks(int start, int limit, boolean forceupdate) throws Exception {
		logger.trace("Get tabular data tasks, start: "+start+" limit: "+limit+" forceupdate: "+forceupdate);
		
//		printServlets();

		List<TdTaskModel> listTaskModel = null;
		List<TdTaskModel> sub = new ArrayList<TdTaskModel>();
		try{
		
			TaskTabularDataService service = getTabularDataServiceClient();
			
			ASLSession aslSession = getASLSession();
			if(service==null)
				throw new Exception("An error occurred on cantacting the Tabular Data service, try again later");
	
			
			if(forceupdate){
				logger.error("Force update is  true, invaliditing tasks cache");
				SessionUtil.setTasksCache(aslSession, null);
			}
			
			HashMap<String, TdTaskModel> hashTaskModel = SessionUtil.getTasksCache(aslSession);
			
			if(hashTaskModel==null){ //CACHE IS EMPTY
				logger.warn("Cache is empty, retriving data from service");
				hashTaskModel = new HashMap<String, TdTaskModel>();
				
//				for (TabularResource tr : service.getTabularResources())
//					System.out.println(tr);
				
				TabularResourceId trId = getCurrentTabularResource();
				logger.trace("Found TabularResourceId: "+trId);
//				System.out.println("Found TabularResourceId: "+trId);
			
				List<Task> listTask = service.getTasks(trId);
				logger.trace("List Task have size: "+listTask.size());
				for (Task task : listTask) {
					try {
						
						logger.trace("Found Task id: "+task.getId() +" converting..");
						TdTaskModel taskModel = TdConverterBeanGWT.taskToTdTaskModel(task, trId, getTabularDataServiceClient());
						
						logger.trace("Converted Task: "+taskModel);
						
						if(task.getId()!=null)
							hashTaskModel.put(task.getId().getValue(), taskModel);
						
					} catch (TdConverterException e) {
						logger.error("Error on converting Task with id: "+task.getId(), e);
					}
				}
				
				logger.trace("Saving cache with : "+hashTaskModel.size() +" task/s model");
				SessionUtil.setTasksCache(aslSession, hashTaskModel); //SAVING CACHE
			}
			
			int end = Math.min(start+limit, hashTaskModel.size());
			start = Math.min(start, end);
	
			listTaskModel = new ArrayList<TdTaskModel>(hashTaskModel.values());
			
			logger.trace("chunk selected data bounds [start: "+start+" end: " + end+"]");
			
			listTaskModel = listTaskModel.subList(start, end);
			
			sub = new ArrayList<TdTaskModel>(listTaskModel);
		}catch (Exception e) {
			logger.error("Error occurred on retrieving Tasks", e);
			throw new Exception("Sorry an error occurred on retrieving Tasks, try again later");
		}
		

		
		return sub;
		
	}


	@Override
	public List<TdJobModel> getListJobForTaskId(String taskId) throws Exception{

		//TODO
		return null;
	}
	

	@Override
	public TdTaskModel getTdTaskForId(String taskId) throws Exception{
		logger.trace("Get tabular data task for id: "+taskId);
		TaskTabularDataService service = getTabularDataServiceClient();
		
		TaskId operationId = new TaskId(taskId);
		
		TdTaskModel taskModel = new TdTaskModel();

		try {
			
			TabularResourceId trId = getCurrentTabularResource();
			
			Task task = service.getTask(operationId);
			taskModel = TdConverterBeanGWT.taskToTdTaskModel(task, trId, getTabularDataServiceClient());
		
		} catch (NoSuchTaskException e) {
			logger.error("Error on recovering Task with id: "+operationId, e);
			throw new Exception("An error occurred on retrieving the Tabular Data Task");
		}
//		} catch (NoSuchTabularResourceException e) {
//			logger.error("Error on recovering Task with id: "+operationId, e);
//			throw new Exception("An error occurred on retrieving the Tabular Data Task");
//		}
		
		return taskModel;
	}



	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.td.taskswidget.client.rpc.TdTasksWidgetService#getTdServiceClientCapabilities()
	 */
	@Override
	public List<TdOperationModel> getTdServiceClientCapabilities() throws Exception {
		TaskTabularDataService service = getTabularDataServiceClient();
		
		if(service==null)
			throw new Exception("An error occurred on cantacting the Tabular Data service, try again later");

		List<TdOperationModel> listOperationModel = new ArrayList<TdOperationModel>();

		for (OperationDefinition  operationDefinition: service.getCapabilities()) {

			try {
				TdOperationModel operationModel = TdConverterBeanGWT.operationDefinitionToOperationModel(operationDefinition);
				listOperationModel.add(operationModel);
			} catch (TdConverterException e) {
				logger.error("Error on converting Operation Descriptor with id: "+operationDefinition.getOperationId(), e);
			}
		}
		
		return listOperationModel;
	}

}
