package org.gcube.portlets.user.tdtemplateoperation.client;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.monitorwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.tdtemplateoperation.client.event.ActionCompletedEvent;
import org.gcube.portlets.user.tdtemplateoperation.client.properties.ComboColumnDataPropertiesCombo;
import org.gcube.portlets.user.tdtemplateoperation.client.properties.ComboTimeTypeProperties;
import org.gcube.portlets.user.tdtemplateoperation.client.resources.ResourceBundleTemplateOperation;
import org.gcube.portlets.user.tdtemplateoperation.shared.ServerObjectId;
import org.gcube.portlets.user.tdtemplateoperation.shared.TdBaseComboDataBean;
import org.gcube.portlets.user.tdtemplateoperation.shared.TdColumnData;
import org.gcube.portlets.user.tdtemplateoperation.shared.TdPeriodType;
import org.gcube.portlets.user.tdtemplateoperation.shared.action.CreateTimeDimensionColumnAction;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.SimpleCheckBox;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jun 10, 2014
 * 
 */
public class CreateTimeDimensionColumnPanel extends FramedPanel implements DeletableContainer {
	protected String WIDTH = "500px";
	protected String HEIGHT = "250px";
	protected EventBus eventBus;
	protected TextField label = null;
	protected String columnName;
	// protected ColumnData column;

	protected TextButton createTimeGroupButton = new TextButton("Group by Time");

	protected ListLoader<ListLoadConfig, ListLoadResult<TdColumnData>> gridLoader;
//	protected Grid<TdColumnData> grid;
	protected CheckBoxSelectionModel<TdColumnData> sm;
	protected FieldLabel columnsSelectLabel;

	private VerticalLayoutContainer verticalFunctionsLayout;
	private ListStore<TdColumnData> gridStore;

	private ListStore<TdPeriodType> storeTimeCombo;
	private ComboBox<TdPeriodType> comboTimeTypes;

	
	private HTML error = new HTML();
	private boolean errorCase = false;
	private ServerObjectId serverObjectId;

	private ListStore<TdColumnData> storeYearColumns;
	private ComboBox<TdColumnData> comboYearColumns;
	private List<TdColumnData> listColumns;
	
	private ListStore<TdColumnData> storeOtherColumns;
	private ComboBox<TdColumnData> comboOtherColumns;
	
//	private TdPeriodType nonePeriod = new TdPeriodType("None", "<None>");
	private TdPeriodType yearPeriod;
	private SimpleCheckBox checkBoxActiveMultiDimension;
	private Command onClose;

	
	public CreateTimeDimensionColumnPanel(ServerObjectId serverObjectId, List<TdColumnData> listColumns, EventBus eventBus, Command onClose) {
		this.serverObjectId = serverObjectId;
		this.eventBus = eventBus;
		this.listColumns = listColumns;
		this.onClose = onClose;
		init();
		build();
		setEnableGroupByButton(false);
		
		TdTemplateOperation.templateOperationService.getYearTimeDimension(new AsyncCallback<TdPeriodType>() {

			@Override
			public void onFailure(Throwable caught) {
			}

			@Override
			public void onSuccess(TdPeriodType result) {
				yearPeriod = result;
			}
		});
		
		
	}

	public void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		initComboYearColumns();
		initComboTimeTypes();
		initComboOtherColumns();
	}

	public void errorText(String text, boolean visible) {
		String html = "<p><img src=\""
				+ ResourceBundleTemplateOperation.INSTANCE.alert().getSafeUri()
						.asString()
				+ "\"/><span style=\"color:red; font-size:11px; margin-left:1px; vertical-align:middle;\">"
				+ text + "</span></p>";
		error.setHTML(html);
	}

	protected void build() {

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.setScrollMode(ScrollMode.AUTOY);
		v.setAdjustForScroll(true);

		v.add(new FieldLabel(null, "Year"), new VerticalLayoutData(1,-1));
		v.add(comboYearColumns, new VerticalLayoutData(1, -1, new Margins(0)));

		verticalFunctionsLayout = new VerticalLayoutContainer();
		verticalFunctionsLayout.setScrollMode(ScrollMode.AUTOY);
		verticalFunctionsLayout.setAdjustForScroll(true);
		
		
//		v.add(new FieldLabel(null, "Grouping to Multi-TimeDimension"));
		final HBoxLayoutContainer hBoxPrincipal = new HBoxLayoutContainer();
		hBoxPrincipal.add(new FieldLabel(null, "Multi-Group"), new BoxLayoutData(new Margins(2, 5, 2,5)));
		hBoxPrincipal.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		checkBoxActiveMultiDimension = new SimpleCheckBox();
		final HBoxLayoutContainer hBox2 = new HBoxLayoutContainer();

		hBoxPrincipal.add(checkBoxActiveMultiDimension);
		checkBoxActiveMultiDimension.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				hBox2.setEnabled(checkBoxActiveMultiDimension.getValue());
			}
		});
		
		hBox2.add(comboTimeTypes,  new BoxLayoutData(new Margins(2, 5, 2,5)));
		comboTimeTypes.addSelectionHandler(new SelectionHandler<TdPeriodType>() {

			@Override
			public void onSelection(SelectionEvent<TdPeriodType> event) {
				if(comboTimeTypes.getCurrentValue()!=null){
//					GWT.log("comparing nonePeriod: "+comboTimeTypes.getCurrentValue().compareTo(nonePeriod));
//					if(comboTimeTypes.getCurrentValue().compareTo(nonePeriod)==0)
//						hBoxPrincipal.setEnabled(false);
//					else
//						hBoxPrincipal.setEnabled(true);	
				}
			}
		});
		
		hBox2.add(comboOtherColumns,new BoxLayoutData(new Margins(2, 5, 2,5)));
		v.add(hBoxPrincipal);
		v.add(hBox2);
		hBox2.setEnabled(false);

		HBoxLayoutContainer hBox = new HBoxLayoutContainer();
		hBox.add(createTimeGroupButton, new BoxLayoutData(new Margins(2, 5, 2,5)));
		v.add(hBox, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));

		v.add(error, new VerticalLayoutData(1, -1, new Margins(0, 1, 10, 1)));

		add(v, new VerticalLayoutData(1, -1, new Margins(0)));
		
		createTimeGroupButton.addSelectHandler(new SelectHandler() {
			
			@Override
			public void onSelect(SelectEvent event) {
				boolean isValidForm = validateGroupByTimeForm();

				if (isValidForm)
					callStartGropuByTime();
				
			}
		});
	}

	protected void setEnableGroupByButton(boolean bool) {
		createTimeGroupButton.setEnabled(bool);
	}

	protected void verticalFunctionsLayoutEnable(boolean bool) {
		verticalFunctionsLayout.setEnabled(bool);
	}

	public void update(String columnName) {
		this.columnName = columnName;
		gridLoader.load();
	}
	
	protected void loadColumns(List<TdColumnData> result){
		listColumns = (ArrayList<TdColumnData>) result;
		gridStore.clear();
		gridStore.addAll(listColumns);
	}

	private void callStartGropuByTime() {

		CreateTimeDimensionColumnAction groupAction = new CreateTimeDimensionColumnAction(comboYearColumns.getCurrentValue(), yearPeriod);
		
		TdPeriodType otherTimeGroup = comboTimeTypes.getCurrentValue();
		
		if(checkBoxActiveMultiDimension.getValue()){
			groupAction.setOtherPeriodTypeColumn(otherTimeGroup);
			groupAction.setOtherColumn(comboOtherColumns.getCurrentValue());
		}

		GWT.log("Builded GroupTimeColumnAction: " + groupAction);
//		GWT.log("eventBus: " + eventBus);
		eventBus.fireEvent(new ActionCompletedEvent(groupAction));
		
		if(onClose!=null)
			onClose.execute();
	}

	@Override
	public void deleteFired(VerticalLayoutContainer panel) {
		try {
			verticalFunctionsLayout.remove(panel);
		} catch (Exception e) {
			GWT.log("error on deleting " + panel);
		}
		verticalFunctionsLayout.forceLayout();
	}
	
	/**
	 * 
	 */
	protected void initComboYearColumns() {
		
		// Column Data
		ComboColumnDataPropertiesCombo propsColumnData = GWT.create(ComboColumnDataPropertiesCombo.class);
		storeYearColumns = new ListStore<TdColumnData>(propsColumnData.id());
		
		if(listColumns!=null)
			storeYearColumns.addAll(listColumns);
		
		comboYearColumns = new ComboBox<TdColumnData>(storeYearColumns, propsColumnData.label());
		comboYearColumns.setAllowBlank(false);

		comboYearColumns.addSelectionHandler(new SelectionHandler<TdColumnData>() {
			
			public void onSelection(SelectionEvent<TdColumnData> event) {
//				boolean isValid = validateGroupByTimeForm();
				setEnableGroupByButton(true);
				changeOtherColumns();
//				if(isValid)
					
			}

		});

		comboYearColumns.setEmptyText("Select a column...");
		comboYearColumns.setWidth(150);
		comboYearColumns.setTypeAhead(false);
		comboYearColumns.setEditable(false);
		comboYearColumns.setTriggerAction(TriggerAction.ALL);
	}
	
	/**
	 * 
	 */
	protected void changeOtherColumns() {
		storeOtherColumns.clear();
		comboOtherColumns.reset();
		comboOtherColumns.clear();
		
		TdColumnData yearSelected = comboYearColumns.getCurrentValue();
		for (TdColumnData col : listColumns) {
			GWT.log("Compare result: "+col.compareTo(yearSelected) +" col: "+col +" with yearSelected: "+yearSelected);
			if(col.compareTo(yearSelected)!=0){
				storeOtherColumns.add(col);
			}
			
		}
		
		comboOtherColumns.redraw();
	}

	protected void initComboOtherColumns() {
		
		// Column Data
		ComboColumnDataPropertiesCombo propsColumnData = GWT.create(ComboColumnDataPropertiesCombo.class);
		storeOtherColumns = new ListStore<TdColumnData>(propsColumnData.id());
		
		comboOtherColumns = new ComboBox<TdColumnData>(storeOtherColumns, propsColumnData.label());
		comboOtherColumns.setAllowBlank(false);

		comboOtherColumns.addSelectionHandler(new SelectionHandler<TdColumnData>() {
			
			public void onSelection(SelectionEvent<TdColumnData> event) {
				boolean isValid = validateGroupByTimeForm();
				setEnableGroupByButton(isValid);
			}

		});

		comboOtherColumns.setEmptyText("Select a column...");
		comboOtherColumns.setWidth(150);
		comboOtherColumns.setTypeAhead(false);
		comboOtherColumns.setEditable(false);
		comboOtherColumns.setTriggerAction(TriggerAction.ALL);
	}
	
	protected void addListColumns(List<TdColumnData> columns){
		if(listColumns!=null)
			listColumns.clear();
		else{
			listColumns = new ArrayList<TdColumnData>(columns.size());
		}
		
		listColumns.addAll(columns);
		storeYearColumns.addAll(listColumns);
	}

	protected boolean validateGroupByTimeForm() {

		TdColumnData selectedColumn = comboYearColumns.getCurrentValue();
		if (selectedColumn == null) {
			UtilsGXT3.alert("Attention", "Attention no column selected!");
			return false;
			
		} else if(checkBoxActiveMultiDimension.getValue()){
			
			if(comboTimeTypes.getCurrentValue()==null){
				UtilsGXT3.alert("Attention", "Attention no time-dimension selected!");
				return false;
			}
			
			if(comboOtherColumns.getCurrentValue()==null){
				UtilsGXT3.alert("Attention", "Attention no multi-group column selected!");
				return false;
			}
			return true;
		}else 
			return true;
	}
	
	
	/**
	 * 
	 */
	protected void initComboTimeTypes() {

		// Column Data
		ComboTimeTypeProperties propsTimeTypeCombo = GWT.create(ComboTimeTypeProperties.class);
		storeTimeCombo = new ListStore<TdPeriodType>(propsTimeTypeCombo.id());

		GWT.log("StoreTimeType created");

		comboTimeTypes = new ComboBox<TdPeriodType>(storeTimeCombo, propsTimeTypeCombo.label());

		GWT.log("Combo TimeType created");

		addHandlersForComboOperator(propsTimeTypeCombo.label());

		// comboTimeTypes.setLoader(loader);
		comboTimeTypes.setEmptyText("Select a time type...");
		comboTimeTypes.setWidth(150);
		comboTimeTypes.setTypeAhead(false);
		comboTimeTypes.setEditable(false);
		comboTimeTypes.setTriggerAction(TriggerAction.ALL);

		comboTimeTypes.setAllowBlank(false);
		
		TdTemplateOperation.templateOperationService.getTimeDimensionGroupPeriodType(new AsyncCallback<List<TdPeriodType>>() {

			@Override
			public void onFailure(Throwable caught) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void onSuccess(List<TdPeriodType> result) {
				storeTimeCombo.addAll(result);
				
			}
		});
	}

	protected void addHandlersForComboOperator(
			final LabelProvider<TdBaseComboDataBean> labelProvider) {
		comboTimeTypes
				.addSelectionHandler(new SelectionHandler<TdPeriodType>() {
					public void onSelection(SelectionEvent<TdPeriodType> event) {
						TdPeriodType periodType = event.getSelectedItem();
						updateComboOperatorStatus(periodType);
					}

				});
	}

	protected void updateComboOperatorStatus(TdPeriodType periodType) {

	}

	/**
	 * @param loadConfig
	 * @param callback
	 */
	protected void loadDataForTimeTypes(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<TdPeriodType>> callback) {

		GWT.log("loadDataForPeriodType");
		TdTemplateOperation.templateOperationService.getListTimeTypes(
				new AsyncCallback<List<TdPeriodType>>() {

					@Override
					public void onFailure(Throwable caught) {
						callback.onFailure(caught);

					}

					@Override
					public void onSuccess(List<TdPeriodType> result) {
						GWT.log("loaded TdPeriodType having size: "
								+ result.size());
						callback.onSuccess(new ListLoadResultBean<TdPeriodType>(
								result));
					}
				});

	}

	protected void close() {
		/*
		 * if (parent != null) { parent.close(); }
		 */
	}

	public boolean isErrorCase() {
		return errorCase;
	}

	public void errorHandler(boolean error) {
		this.errorCase = error;
		setEnableGroupByButton(!error);
	}

}
