/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td.map;

import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.portlets.user.tdwx.datasource.td.map.ColumnTypeMap;
import org.gcube.portlets.user.tdwx.datasource.td.map.DataTypeMap;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefinitionBuilder {
    protected Logger logger = LoggerFactory.getLogger(ColumnDefinitionBuilder.class);
    protected Column serviceColumn;
    protected String tooltipMessage;
    protected String columnName;
    protected String columnLocalId;
    protected boolean visible;
    protected ColumnType type;
    protected String columnLabel;
    protected int ordinalPosition;

    public ColumnDefinitionBuilder(Column serviceColumn, int ordinalPosition) {
        this.serviceColumn = serviceColumn;
        this.ordinalPosition = ordinalPosition;
        this.visible = true;
        this.type = ColumnType.USER;
        org.gcube.data.analysis.tabulardata.model.column.ColumnType ct = serviceColumn.getColumnType();
        if (ColumnTypeMap.isIdColumnType(ct)) {
            this.columnLabel = "Id";
            this.visible = false;
            this.type = ColumnType.SYSTEM;
        } else {
            if (ColumnTypeMap.isValidationColumnType(ct)) {
                this.type = ColumnType.VALIDATION;
            }
            NamesMetadata labelsMetadata = null;
            try {
                labelsMetadata = (NamesMetadata)serviceColumn.getMetadata(NamesMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                this.logger.debug("labelMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
            }
            if (labelsMetadata == null) {
                this.columnLabel = "nolabel";
            } else {
                LocalizedText cl = null;
                cl = labelsMetadata.getTextWithLocale("en");
                if (cl == null) {
                    this.columnLabel = "nolabel";
                    this.logger.debug("ColumnLabel no label in en");
                } else {
                    this.columnLabel = cl.getValue();
                }
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ColumnType getType() {
        return this.type;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        this.columnName = this.serviceColumn.getName();
        return this.columnName;
    }

    public String getColumnLocalId() {
        this.columnLocalId = this.serviceColumn.getLocalId().getValue();
        return this.columnLocalId;
    }

    public ValidationReferencesMetadata getValidationReferencesMetadata() {
        ValidationReferencesMetadata refs = null;
        try {
            refs = (ValidationReferencesMetadata)this.serviceColumn.getMetadata(ValidationReferencesMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.logger.debug("ValidationReferencesMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
        }
        return refs;
    }

    public String getTooltipMessage() {
        String valids = new String();
        ValidationsMetadata val = null;
        try {
            val = (ValidationsMetadata)this.serviceColumn.getMetadata(ValidationsMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.logger.debug("NamesMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
        }
        if (val != null) {
            List listValidationsMetadata = val.getValidations();
            for (Validation validation : listValidationsMetadata) {
                valids.concat(validation.getDescription() + "\n");
            }
        }
        this.tooltipMessage = valids;
        return this.tooltipMessage;
    }

    public ColumnDefinition build() {
        ColumnDefinition columnDefinition = new ColumnDefinition(this.getColumnName(), this.getColumnLocalId(), this.getColumnLabel());
        DataType dataType = this.serviceColumn.getDataType();
        columnDefinition.setValueType(DataTypeMap.getValueType(dataType));
        columnDefinition.setType(this.getType());
        columnDefinition.setPosition(this.ordinalPosition);
        columnDefinition.setTooltipMessage(this.getTooltipMessage());
        columnDefinition.setColumnTypeName(this.serviceColumn.getColumnType().getName());
        columnDefinition.setColumnDataType(this.serviceColumn.getDataType().getName());
        columnDefinition.setWidth(100);
        columnDefinition.setEditable(false);
        columnDefinition.setVisible(this.isVisible());
        return columnDefinition;
    }
}

