/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrderDirection;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.portlets.user.tdwx.datasource.td.map.ColumnDefinitionBuilder;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceX;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.server.datasource.Direction;
import org.gcube.portlets.user.tdwx.server.datasource.util.TableJSonBuilder;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableId;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDXDataSource
implements DataSourceX {
    public static final String JSON_ROWS_FIELD = "ROWS";
    public static final String JSON_TOTAL_LENGTH_FIELD = "total";
    public static final String JSON_OFFSET_FIELD = "offset";
    protected Logger logger = LoggerFactory.getLogger(TDXDataSource.class);
    protected String dataSourceFactoryId;
    protected String tableName;
    protected TableDefinition tableDefinition;
    protected int tableSize = -1;
    protected ColumnDefinition autogeneratePrimaryColumn = null;
    protected TableJSonBuilder jsonBuilder;
    protected TabularDataService service;
    protected org.gcube.data.analysis.tabulardata.model.table.TableId serviceTableId;
    protected Table serviceTable;

    public static TDXDataSource createTDDataSource(String dataSourceFactoryId, ASLSession aslSession, String tableName) throws DataSourceXException {
        TDXDataSource dataSource = new TDXDataSource(dataSourceFactoryId, aslSession, tableName);
        return dataSource;
    }

    public TDXDataSource(String dataSourceFactoryId, ASLSession aslSession, String tableName) throws DataSourceXException {
        long tableId;
        if (dataSourceFactoryId == null) {
            this.logger.error("An error occurred, dataSourceFactoryId is null");
            throw new DataSourceXException("An error occurred, dataSourceFactoryId is null");
        }
        if (tableName == null) {
            this.logger.error("An error occurred, tableName is null");
            throw new DataSourceXException("An error occurred, tableName is null");
        }
        this.dataSourceFactoryId = dataSourceFactoryId;
        this.tableName = tableName;
        AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername()));
        this.service = TabularDataServiceFactory.getService();
        try {
            tableId = Long.parseLong(tableName);
        }
        catch (NumberFormatException e) {
            this.logger.error("An error occurred, tableName is not a long", (Throwable)e);
            throw new DataSourceXException("An error occurred, no tableName is not a long", (Throwable)e);
        }
        this.serviceTableId = new org.gcube.data.analysis.tabulardata.model.table.TableId(tableId);
        try {
            this.serviceTable = this.service.getTable(this.serviceTableId);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, no such table", (Throwable)e);
            throw new DataSourceXException("An error occurred, no such table", (Throwable)e);
        }
        this.logger.debug("Service Table: " + this.serviceTable);
    }

    public String getDataSourceFactoryId() {
        return this.dataSourceFactoryId;
    }

    public TableDefinition getTableDefinition() throws DataSourceXException {
        if (this.tableDefinition == null) {
            this.tableDefinition = this.extractTableDefinition();
        }
        return this.tableDefinition;
    }

    protected TableDefinition extractTableDefinition() throws DataSourceXException {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        TableId id = new TableId(this.dataSourceFactoryId, this.tableName);
        TableDefinition tableDefinition = new TableDefinition(id, this.tableName, JSON_ROWS_FIELD, JSON_TOTAL_LENGTH_FIELD, JSON_OFFSET_FIELD, columns);
        tableDefinition.setModelKeyColumnId("id");
        return tableDefinition;
    }

    protected List<ColumnDefinition> getColumnDefinitions() throws DataSourceXException {
        List serviceListColumn = this.serviceTable.getColumns();
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        for (int i = 0; i < serviceListColumn.size(); ++i) {
            Column serviceColumn = (Column)serviceListColumn.get(i);
            ColumnDefinition column = this.getColumnDefinition(serviceColumn, i);
            columns.add(column);
        }
        return columns;
    }

    protected ColumnDefinition getColumnDefinition(Column serviceColumn, int ordinalPosition) {
        ColumnDefinitionBuilder columnDefinitionBuilder = new ColumnDefinitionBuilder(serviceColumn, ordinalPosition);
        ColumnDefinition columnDefinition = columnDefinitionBuilder.build();
        this.logger.debug("Column Definition:" + columnDefinition);
        return columnDefinition;
    }

    protected ColumnDefinition createPrimaryKeyColumn(List<ColumnDefinition> columns) {
        ArrayList<String> ids = new ArrayList<String>(columns.size());
        for (ColumnDefinition column : columns) {
            ids.add(column.getId());
        }
        String id = "idColumn";
        int i = 0;
        while (ids.contains(id)) {
            id = "idColumn" + i++;
        }
        return new ColumnDefinition(id, id, id, ValueType.INTEGER, -1, false, false, ColumnType.SYSTEM);
    }

    public String getDataAsJSon(int start, int limit, String sortingColumn, Direction direction) throws DataSourceXException {
        this.logger.trace("getDataAsJSon start: " + start + " limit: " + limit + " sortingColumn: " + sortingColumn + " direction: " + direction);
        this.tableSize = 0;
        try {
            this.tableSize = this.service.getQueryLenght(this.serviceTableId, null);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, tableSize is not recovered", (Throwable)e);
            throw new DataSourceXException("An error occurred, tableSize is not recovered", (Throwable)e);
        }
        start = Math.max(0, start);
        start = Math.min(start, this.tableSize);
        if (start + limit > this.tableSize) {
            limit = this.tableSize - start;
        }
        this.logger.trace("checked bounds start: " + start + " limit: " + limit);
        TableDefinition tableDefinition = this.getTableDefinition();
        QueryOrder queryOrder = null;
        if (sortingColumn != null) {
            if (tableDefinition.getColumns().get(sortingColumn) == null) {
                this.logger.error("The specified sorting column \"" + sortingColumn + "\" don't exists");
                throw new DataSourceXException("The specified sorting column \"" + sortingColumn + "\" don't exists");
            }
            ColumnDefinition columnDefinition = (ColumnDefinition)tableDefinition.getColumns().get(sortingColumn);
            Column column = this.serviceTable.getColumnByName(columnDefinition.getId());
            switch (direction) {
                case ASC: {
                    queryOrder = new QueryOrder(column.getLocalId(), QueryOrderDirection.ASCENDING);
                    break;
                }
                case DESC: {
                    queryOrder = new QueryOrder(column.getLocalId(), QueryOrderDirection.DESCENDING);
                    break;
                }
            }
        }
        String json = this.getJSon(start, queryOrder);
        this.logger.trace("Returning json");
        this.logger.debug(json);
        return json;
    }

    protected ArrayList<ColumnDefinition> sort(Collection<ColumnDefinition> columns) {
        ArrayList<ColumnDefinition> lcolumns = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition column : columns) {
            lcolumns.add(column);
        }
        for (int hight = lcolumns.size() - 1; hight > 0; --hight) {
            for (int i = 0; i < hight; ++i) {
                if (lcolumns.get(i).getPosition() <= lcolumns.get(i + 1).getPosition()) continue;
                ColumnDefinition cd = lcolumns.get(i);
                lcolumns.set(i, lcolumns.get(i + 1));
                lcolumns.set(i + 1, cd);
            }
        }
        return lcolumns;
    }

    protected String getJSon(int start, QueryOrder queryOrder) throws DataSourceXException {
        TableJSonBuilder json = this.getBuilder();
        TableDefinition tableDefinition = this.getTableDefinition();
        Collection<ColumnDefinition> columns = tableDefinition.getColumns().values();
        ArrayList<ColumnDefinition> lcolumns = this.sort(columns);
        this.logger.debug("ColumnDefinition:\n" + lcolumns.toString());
        json.startRows();
        int id = start;
        QueryPage queryPage = new QueryPage(start, 200);
        String serviceJson = null;
        try {
            serviceJson = queryOrder == null ? this.service.queryAsJson(this.serviceTableId, queryPage) : this.service.queryAsJson(this.serviceTableId, queryPage, queryOrder);
        }
        catch (NoSuchTableException e) {
            this.logger.error("An error occurred, no such table", (Throwable)e);
            throw new DataSourceXException("An error occurred, no such table", (Throwable)e);
        }
        JSONArray currentRow = null;
        int i = -1;
        int j = -1;
        int totalRows = -1;
        try {
            JSONObject obj = new JSONObject(serviceJson);
            JSONArray rows = obj.getJSONArray("rows");
            totalRows = rows.length();
            for (i = 0; i < totalRows; ++i) {
                json.startRow();
                currentRow = rows.getJSONArray(i);
                j = 0;
                for (ColumnDefinition column : lcolumns) {
                    String columnId = column.getId();
                    if (currentRow.isNull(j)) {
                        json.addValue(columnId, "");
                    } else {
                        switch (column.getValueType()) {
                            case BOOLEAN: {
                                Boolean b = currentRow.getBoolean(j);
                                json.addValue(columnId, b);
                                break;
                            }
                            case DOUBLE: {
                                Double d = currentRow.getDouble(j);
                                json.addValue(columnId, d);
                                break;
                            }
                            case FLOAT: {
                                Double f = currentRow.getDouble(j);
                                json.addValue(columnId, f);
                                break;
                            }
                            case INTEGER: {
                                int integ = currentRow.getInt(j);
                                json.addValue(columnId, Integer.valueOf(integ));
                                break;
                            }
                            case LONG: {
                                Long l = currentRow.getLong(j);
                                json.addValue(columnId, l);
                                break;
                            }
                            case STRING: {
                                String s = currentRow.getString(j);
                                json.addValue(columnId, s);
                                break;
                            }
                            default: {
                                this.logger.warn("Unknow value type " + column.getValueType());
                            }
                        }
                    }
                    ++j;
                }
                json.endRow();
            }
        }
        catch (JSONException e) {
            this.logger.error("An error occurred while parsing json document\nAt Row " + i + ",Column " + j + "\nRow Content: " + currentRow + "\nLenght rows " + totalRows, (Throwable)e);
            throw new DataSourceXException("An error occurred,  while reading json of service", (Throwable)e);
        }
        json.endRows();
        json.setTotalLength(this.tableSize);
        json.setOffset(start);
        this.logger.trace("produced " + ((id += i) - start) + " rows");
        json.close();
        return json.toString();
    }

    protected TableJSonBuilder getBuilder() throws DataSourceXException {
        if (this.jsonBuilder == null) {
            this.jsonBuilder = new TableJSonBuilder(this.getTableDefinition());
        } else {
            this.jsonBuilder.clean();
        }
        return this.jsonBuilder;
    }

    protected int getTableSize() throws DataSourceXException {
        return this.tableSize;
    }

    public void close() {
    }
}

