/**
 * 
 */
package org.gcube.portlets.user.tdwx.client.config;

import java.util.HashMap;
import java.util.Map;

import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;

import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.widget.core.client.grid.GridViewConfig;


  
 /**
  * 
  * @author "Giancarlo Panichi" 
  * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
  *
  * A bridge between the GridViewConfig and the TableViewConfig.
  */
public class TabularDataGridViewConfig implements GridViewConfig<DataRow> {
	
	protected RowStyleProvider rowStyleProvider;
	protected Row row;
	protected TableDefinition definition;
	
	public TabularDataGridViewConfig(TableViewConfig config, TableDefinition definition)
	{
		this.rowStyleProvider = config.getRowStyleProvider();
		this.definition=definition;
		
		Map<String, ColumnKey> keys = new HashMap<String, ColumnKey>();
		for (ColumnDefinition column:definition.getColumnsAsList()) keys.put(column.getLabel(), column.getKey());
		row = new Row(keys);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getColStyle(DataRow model, ValueProvider<? super DataRow, ?> valueProvider, int rowIndex,	int colIndex) {
		return "";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getRowStyle(DataRow model, int rowIndex) {
		row.setDataRow(model);
		return rowStyleProvider.getRowStyle(row);
	}

}
